import React from 'react'
import { useState } from 'react'
import useAxiosIntercept from '../../hooks/useAxiosIntercept';
import Overlay from "../../utils/Overlay"
import Error from '../UI/Error';
import Message from "../../utils/Message"
import Success from '../UI/Success';
export default function AddNewBattery({ setaddNewBattery, deploymentcenterId, isSuccess, setisSuccess, setisCreated, setsuccessData, data, setdata, index }) {

    const axiosPrivate = useAxiosIntercept();
    let batterySerialNumberCout = 0;
    let batteryCapacityCount = 0;
    const [isSubmit, setisSubmit] = useState(false);
    //const [successMessage, setSuccessMessage] = useState("");
    const successMessage = "Battery created successfully";
    const [isBatteryCreated, setisbatteryCreated] = useState(false);
    const onBackdropClick = () => {

        setisCreated(false);
    }

    const close = () => {
        setaddNewBattery(false);
        document.body.classList.remove('hidden');
    }
    const [swappableBattery, setswappableBattery] = useState([{
        key: Date.now(),
        serial_number: "",
        total_charging_capacity: "",
        charger_type: "S",
        batteryError: ""
    }]);
    const addAnotherBattery = () => {
        setswappableBattery([...swappableBattery,
        {
            key: Date.now(),
            serial_number: "",
            total_charging_capacity: "",
            charger_type: "S"
        }])

    }
    const validations = () => {

        const battery = [...swappableBattery];
        for (let index = 0; index < battery.length; index++) {
            if (battery[index].serial_number == "") {
                battery[index].batteryIdError = "Charger identifier number is required"
            }

            else {
                batterySerialNumberCout++;
                battery[index].batteryIdError = ""

            }

            if (battery[index].total_charging_capacity == "") {
                battery[index].batteryCapacityError = "Battery capacity is required"
            }
            else {
                if (battery[index].total_charging_capacity <= 0) {
                    battery[index].batteryCapacityError = "Value should be greater than 0"


                }
                else {
                    batteryCapacityCount++;
                    battery[index].batteryCapacityError = ""

                }


            }
        }
        setswappableBattery(battery);

    }
    const addBattery = async () => {

        validations();

        const request = {
            centre_id: deploymentcenterId,
            chargers: swappableBattery,
        }
        if (batteryCapacityCount == swappableBattery.length && batterySerialNumberCout == swappableBattery.length) {
            setisSubmit(true);
            for (var i = 0; i < swappableBattery.length; i++) {

                delete swappableBattery[i]["batteryIdError"];
                delete swappableBattery[i]["batteryCapacityError"];
                delete swappableBattery[i]["batteryError"];
                delete swappableBattery[i]["batterySuccess"];

            }
            const URL = process.env.REACT_APP_CREATE_CHARGING_STATION;
            const response = await axiosPrivate.post(URL, request);
            if (response?.data?.status == "200") {
                const temp = [...data];
                temp[index].total_swappable_batteries = parseInt(temp[index].total_swappable_batteries) + parseInt(swappableBattery?.length);
                setdata(temp);
                setaddNewBattery(false);
                setisCreated(true);
                setsuccessData({
                    message: {
                        text: "Battery created successfully"
                    },
                    successLink: "/charging_centers",
                    successValue: "Go Back To Charging Centre Listing",
                    isSuccess: true,
                    onBackdropClick: onBackdropClick
                })
                setisSuccess(!isSuccess);

            }
            else {
                const data = [...swappableBattery];
                swappableBattery.map((battery, i) => {
                    if (response?.data?.response?.errors?.chargers && response?.data?.response?.errors?.chargers?.length > "0") {
                        response?.data?.response?.errors?.chargers.map((err, index) => {

                            if (battery.key == err?.key) {

                                data[i].batteryError = err?.errors[0]?.message

                            }

                        })
                    }


                })

                setswappableBattery(data);

            }
        }

    }
    const handleremove = (id, index) => {
        const filtered = swappableBattery.filter((obj) => { return obj.key !== id })
        setswappableBattery(filtered);



    }
    return (
        <>

            <Overlay>
                <div class="model_box_child manageBookingTimeP ChargingCentersP_AddBattery" id="ChargingCentersP_AddBattery" style={{ width: "552px" }}>
                    <div class="ap_heading">
                        <h4>
                            Add new battery size
                            <span class="material-symbols-rounded black close_model" onClick={close}>
                                close
                            </span>
                        </h4>
                    </div>
                    <div class="contentSection">
                        <section>
                            <div class="addTime dForm mt-16">
                                <div class="fieldGroup mt-0 fullWidth mr-16">
                                    <label>Add swappable battery</label>
                                </div>

                                <div class="lists">
                                    {swappableBattery && swappableBattery?.length > "0" && swappableBattery.map((battery, index) => {
                                        return (<>
                                            <div className={index == "0" ? "xType mt-0" : "xType mt-16"}>
                                                <div class="fieldGroup mt-0 fullWidth mr-16">
                                                    <span><input type="text" placeholder="Enter charger identifier number" class="fullWidth" value={swappableBattery[index].serial_number} onChange={(e) => {
                                                        const data = [...swappableBattery];
                                                        data[index]["serial_number"] = e.target.value;
                                                        data[index]["batteryIdError"] = "";
                                                        data[index]["batteryError"] = "";
                                                        data[index]["batterySuccess"] = "";

                                                        setswappableBattery(data);
                                                    }} />

                                                    </span>
                                                    {swappableBattery[index].batteryIdError && <Error error={swappableBattery[index].batteryIdError} newclass="xType mt-5" />}


                                                </div>

                                                <div class="fieldGroup fullWidth mt-0">
                                                    <span><input type="number" placeholder="Enter battery capacity (kWh)" class="fullWidth" value={swappableBattery[index].total_charging_capacity}
                                                        onChange={(e) => {
                                                            const data = [...swappableBattery];
                                                            data[index]["total_charging_capacity"] = e.target.value;
                                                            data[index]["batteryCapacityError"] = "";
                                                            data[index]["batteryError"] = "";
                                                            data[index]["batterySuccess"] = "";

                                                            setswappableBattery(data);

                                                        }}
                                                    /></span>
                                                    {swappableBattery[index].batteryCapacityError && <Error error={swappableBattery[index].batteryCapacityError} newclass="xType mt-5" />}
                                                </div>
                                                <div class="ml-12" style={{ visibility: index == 0 ? "hidden" : "" }}

                                                ><i class="material-symbols-rounded grey mt-m arrow" onClick={() => { handleremove(battery.key, index) }}>delete</i></div>
                                            </div>
                                            {swappableBattery[index].batteryError && <Error error={swappableBattery[index].batteryError} />}
                                            {swappableBattery[index].batterySuccess && <Success success={swappableBattery[index].batterySuccess} />}

                                        </>)

                                    })}




                                </div>
                                <div class="link">
                                    <i class="material-symbols-rounded mt-m activeFill">
                                        battery_charging_30
                                    </i>
                                    <a onClick={addAnotherBattery}>Add another battery</a>
                                </div>
                            </div>
                        </section>
                        <div class="actionButtons mt-24">
                            <span>
                                <a class="btn prim" onClick={addBattery} >Add new battery</a>
                            </span>
                        </div>
                    </div>
                </div>

            </Overlay>


        </>
    )
}
