import React from 'react'
import { useState } from 'react'
import Overlay from '../../utils/Overlay'
import Error from '../UI/Error';
import Success from "../UI/Success"
import useAxiosIntercept from '../../hooks/useAxiosIntercept';
export default function AddNewBay({ setaddNewBay, deploymentcenterId, isSuccess, setisSuccess, setisCreated, setsuccessData, setdata, data, index }) {

    const axiosPrivate = useAxiosIntercept();
    let baySerialNumberCount = 0;
    let bayChargingCapacityCount = 0;
    const successMessage = "Charging bay created successfully"
    const close = () => {
        setaddNewBay(false);
        document.body.classList.remove('hidden');
    }
    const [chargingBay, setchargingBay] = useState([{
        key: Date.now(),
        bay_serial_number: "",
        total_charging_power: ""
    }]);
    const addAnotherBay = () => {
        setchargingBay([...chargingBay,
        {
            key: Date.now(),
            bay_serial_number: "",
            total_charging_power: "",

        }])

    }
    const validations = () => {
        const bay = [...chargingBay];
        for (let index = 0; index < bay.length; index++) {
            if (bay[index].bay_serial_number == "") {
                bay[index].bayIdError = "Bay identifier number is required"
            }
            else {
                baySerialNumberCount++;
                bay[index].bayIdError = ""

            }
            if (bay[index].total_charging_power == "") {
                bay[index].bayCapacityError = "Bay charger capacity is required"
            }
            else {
                if (bay[index].total_charging_power <= 0) {
                    bay[index].bayCapacityError = "Value should be greater than 0"

                }
                else {
                    bayChargingCapacityCount++;
                    bay[index].bayCapacityError = "";

                }


            }

        }
        setchargingBay(bay);

    }
    const onBackdropClick = () => {

        setisCreated(false);
    }
    const addBay = async () => {
        validations();
        const request = {
            centre_id: deploymentcenterId,
            charger_bay: chargingBay
        }

        if (baySerialNumberCount == chargingBay.length && bayChargingCapacityCount == chargingBay.length) {
            for (var i = 0; i < chargingBay.length; i++) {

                delete chargingBay[i]["bayIdError"];
                delete chargingBay[i]["bayCapacityError"];
                delete chargingBay[i]["bayError"];
                delete chargingBay[i]["baySuccess"];

            }

            const URL = process.env.REACT_APP_CREATE_CHARGING_STATION;
            const response = await axiosPrivate.post(URL, request);
            if (response?.data?.status == "200") {
                const temp = [...data];
                temp[index].total_car_space = parseInt(temp[index].total_car_space) + parseInt(chargingBay?.length);
                setdata(temp);
                setaddNewBay(false);
                setisCreated(true);
                setsuccessData({
                    message: {
                        text: "Bay created successfully"
                    },
                    successLink: "/charging_centers",
                    successValue: "Go Back To Charging Centre Listing",
                    isSuccess: true,
                    onBackdropClick: onBackdropClick
                })
                setisSuccess(!isSuccess);

            }
            else {
                const data = [...chargingBay];
                chargingBay.map((bay, i) => {
                    if (response?.data?.response?.errors?.charger_bay && response?.data?.response?.errors?.charger_bay?.length > "0") {
                        response?.data?.response?.errors?.charger_bay.map((err, index) => {

                            if (bay.key == err?.key) {

                                data[i].bayError = err?.errors[0]?.message

                            }

                        })
                    }



                })
                setchargingBay(data);

            }



        }

    }
    const handleremove = (id, index) => {
        const filtered = chargingBay.filter((obj) => { return obj.key !== id })
        setchargingBay(filtered);
    }
    return (
        <>
            <Overlay>
                <div class="model_box_child manageBookingTimeP ChargingCentersP_AddBattery" id="ChargingCentersP_AddBattery" style={{ width: "552px" }}>
                    <div class="ap_heading">
                        <h4>
                            Add new Charging Bay
                            <span class="material-symbols-rounded black close_model" onClick={close}>
                                close
                            </span>
                        </h4>
                    </div>
                    <div class="contentSection">
                        <section>
                            <div class="addTime dForm mt-16">
                                <div class="fieldGroup mt-0 fullWidth mr-16">
                                    <label>Add charging bay</label>
                                </div>

                                <div class="lists">
                                    {chargingBay && chargingBay?.length > "0" && chargingBay.map((bay, index) => {
                                        return (<>
                                            <div className={index == "0" ? "xType mt-0" : "xType mt-16"}>
                                                <div class="fieldGroup mt-0 fullWidth mr-16">
                                                    <span><input type="text" placeholder="Enter charger identifier number" class="fullWidth" value={chargingBay[index].bay_serial_number}
                                                        onChange={(e) => {
                                                            const data = [...chargingBay];
                                                            data[index]["bay_serial_number"] = e.target.value;
                                                            data[index]["bayIdError"] = "";
                                                            data[index]["bayError"] = "";
                                                            data[index]["baySuccess"] = "";
                                                            setchargingBay(data);


                                                        }} />

                                                    </span>
                                                    {chargingBay[index].bayIdError && <Error error={chargingBay[index].bayIdError} newclass="xType mt-5" />}


                                                </div>

                                                <div class="fieldGroup fullWidth mt-0">
                                                    <span><input type="number" placeholder="Enter battery capacity (kWh)" class="fullWidth" value={chargingBay[index].total_charging_power}
                                                        onChange={(e) => {
                                                            const data = [...chargingBay];
                                                            data[index]["total_charging_power"] = e.target.value;
                                                            data[index]["bayCapacityError"] = "";
                                                            data[index]["bayError"] = "";
                                                            data[index]["baySuccess"] = "";
                                                            setchargingBay(data);


                                                        }}
                                                    /></span>

                                                    {chargingBay[index].bayCapacityError && <Error error={chargingBay[index].bayCapacityError} newclass="xType mt-5" />}
                                                </div>
                                                <div class="ml-12" style={{ visibility: index == 0 ? "hidden" : "" }}

                                                ><i class="material-symbols-rounded grey mt-m arrow" onClick={() => { handleremove(bay.key, index) }}>delete</i></div>
                                            </div>
                                            {chargingBay[index].bayError && <Error error={chargingBay[index].bayError} />}
                                            {chargingBay[index].baySuccess && <Success success={chargingBay[index].baySuccess} />}

                                        </>)

                                    })}




                                </div>

                                <div class="link">
                                    <i class="material-symbols-rounded mt-m activeFill">
                                        battery_charging_30
                                    </i>
                                    <a onClick={addAnotherBay} >Add another bay</a>
                                </div>
                            </div>
                        </section>
                        <div class="actionButtons mt-24">
                            <span>
                                <a class="btn prim" onClick={addBay} >Add new bay</a>
                            </span>

                        </div>
                    </div>
                </div>

            </Overlay>
        </>
    )
}
