import React from 'react'
import useAxiosIntercept from '../../hooks/useAxiosIntercept'
import useHttp from '../../hooks/useHttp'
import usePaginate from '../../hooks/usePaginate'
import Spinner from '../UI/Spinner'
import { useState } from 'react'
import { useEffect } from 'react'
import moment from 'moment'
import { useParams } from 'react-router-dom'
import MarkInactivePopUp from './MarkInactivePopUp'
import NoData from '../UI/NoData'
import Loading from '../UI/Loading'
import DataNotFound from '../UI/DataNotFound'
import useAuth from '../../hooks/useAuth'
export default function ChargingBayList({ deployment_center_id, setisUpdated, setsuccessData, onBackdropClick, centre_id }) {
    const axiosPrivate = useAxiosIntercept();
    const params = useParams();
    const { auth } = useAuth();
    const [hasMore, setHasMore] = useState(false);
    const [markinactivePopUp, setMarkInactivePopUp] = useState(false)
    const [chargingBayList, setchargingBayList] = useState("");
    const [reasons, setReasons] = useState("");
    const [currentPage, setCurrentPage] = useState(1);
    const [usersPerPage, setUsersPerPage] = useState(5);
    const [total_records, setTotalRecords] = useState(0);
    const [isSuccess, setisSuccess] = useState(false);
    const perpageLimit = 10;
    const [pageNumber, setPageNumber] = useState(1);
    const { isLoading, sendRequest: getChargingBays } = useHttp();
    const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);

    const [chargingbayData, setchargingbayData] = useState({
        id: "",
        total_charging_power: "",
        update_url: "",
        center_id: "",
        bay_id: ""
    });
    const [updateRequest, setupdateRequest] = useState({
        centre_id: "",
        bay_serial_number: "",
        status: "",
        reason_id: ""


    })
    const handleClick = async (serial_no, total_power, status, bay_id, index) => {
        const UPDATE_URL = process.env.REACT_APP_UPDATE_CHARGING_BAY
        if (status == "A") {
            const URL = process.env.REACT_APP_BOOKING_CANCELLATION_REASON + `&object_type=CB`;
            const response = await axiosPrivate.get(URL);
            setchargingbayData({
                id: serial_no,
                total_charging_power: total_power,
                update_url: UPDATE_URL,
                center_id: deployment_center_id,
                bay_id: bay_id,
                index: index

            })
            setupdateRequest({

                status: "D",
                bay_id: bay_id

            })



            if (response?.data?.status == "200") {
                setReasons(response?.data?.response?.data?.cancellation_reasons);
            }
            setMarkInactivePopUp(true);


        }
        else {
            const req = {
                bay_id: bay_id,
                status: "A"
            }
            const response = await axiosPrivate.post(UPDATE_URL, req);

            if (response?.data?.status == "200") {
                const temp = [...chargingBayList];
                temp[index].status = "A";
                setchargingBayList(temp);
                setisSuccess(!isSuccess)
                setisUpdated(true);
                setsuccessData({
                    message: {
                        text: response?.data?.message
                    },
                    successLink: `/charging_centers/details/${centre_id}`,
                    successValue: "Go Back To Charging Centre Details",
                    isSuccess: true,
                    onBackdropClick: onBackdropClick
                })

            }
        }
    }
    let url = process.env.REACT_APP_CHARGING_BAY_LIST;
    url = url + `&centre_id=${params.centre_id}&limit=${perpageLimit}&page=${pageNumber}`

    useEffect(() => {
        const setchargingBays = (bays) => {
            const { data } = bays?.data?.response;
            if (data?.charging_bays) {

                setchargingBayList((prev) => {

                    return [...new Set([...prev, ...data?.charging_bays])]

                });

                setTotalRecords(data?.total)

            }
            else {
                setchargingBayList({})
            }

            if (data?.total == data?.charging_bays?.length) {
                setHasMore(false);
            }
            else {

                setHasMore(bays?.data?.response?.data?.charging_bays?.length > 0);
            }

        };
        if (pageNumber == 1 || (Math.ceil(total_records / perpageLimit) >= pageNumber)) {

            getChargingBays(
                {
                    url
                },
                setchargingBays

            );
        }


    }, [ url, getChargingBays, pageNumber])
    return (
        <>

            {markinactivePopUp && <MarkInactivePopUp heading="Mark charging bay inactive" reasons={reasons} data={chargingbayData} updateRequest={updateRequest} setupdateRequest={setupdateRequest} setMarkInactivePopUp={setMarkInactivePopUp}

                isSuccess={isSuccess} setisSuccess={setisSuccess} setisUpdated={setisUpdated} setsuccessData={setsuccessData} list={chargingBayList} setlist={setchargingBayList} type={"bay"}
            />}

            {chargingBayList == "" ? <><Spinner /></> : chargingBayList && Object.keys(chargingBayList)?.length != "0" ? (<>
                <div class="dataTableDynamic">
                    <table>
                        <tbody>
                            <tr>
                                <th>Charging bay ID</th>
                                <th>Charging power</th>
                                <th>Added on</th>
                                <th>Status</th>
                                <th>&nbsp;</th>
                            </tr>
                            {chargingBayList && chargingBayList?.length > 0 && chargingBayList.map((chargingbay, index) => {
                                const AddedOn = `${chargingbay?.created_on}`
                                if (chargingBayList?.length === index + 1) {
                                    return (<>
                                        <tr ref={lastElementRef}>
                                            <td><span>#{chargingbay.bay_serial_number}</span></td>
                                            <td>{chargingbay.total_charging_power} kWh</td>
                                            <td>{moment(AddedOn).format("DD MMMM YYYY")}</td>
                                            <td class={chargingbay.status == "A" ? "success" : "error"}>{chargingbay.status == "A" ? "Active" : "Inactive"}</td>
                                            {auth.priviliges.includes("write_charging_center") &&
                                                <td class="right">
                                                    <div class="actionNav">
                                                        <i class="material-symbols-rounded mt-m grey">more_vert</i>
                                                        <div class="dropMenuWrap">
                                                            <ul class="dropMenu" style={{ width: "180px" }}>
                                                                <li>
                                                                    <a onClick={() => { handleClick(chargingbay.bay_serial_number, chargingbay.total_charging_power, chargingbay.status, chargingbay.bay_id, index) }} class="error open_model" data-target="assignInactive1">{chargingbay.status == "A" ? "Mark as inactive" : "Mark as active"}</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </td>}
                                        </tr>

                                    </>)

                                }
                                else {
                                    return (<>
                                        <tr ref={lastElementRef}>
                                            <td><span>#{chargingbay.bay_serial_number}</span></td>
                                            <td>{chargingbay.total_charging_power} kWh</td>
                                            <td>{moment(AddedOn).format("DD MMMM YYYY")}</td>
                                            <td class={chargingbay.status == "A" ? "success" : "error"}>{chargingbay.status == "A" ? "Active" : "Inactive"}</td>
                                             {auth.priviliges.includes("write_charging_center") &&
                                                <td class="right">
                                                    <div class="actionNav">
                                                        <i class="material-symbols-rounded mt-m grey">more_vert</i>
                                                        <div class="dropMenuWrap">
                                                            <ul class="dropMenu" style={{ width: "180px" }}>
                                                                <li>
                                                                    <a onClick={() => { handleClick(chargingbay.bay_serial_number, chargingbay.total_charging_power, chargingbay.status, chargingbay.bay_id, index) }} class="error open_model" data-target="assignInactive1">{chargingbay.status == "A" ? "Mark as inactive" : "Mark as active"}</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </td>}
                                        </tr>

                                    </>)

                                }




                            })}

                        </tbody>
                    </table>

                </div>
                {isLoading && pageNumber != "1" && <div><Loading/></div>}
                {pageNumber != "1" && pageNumber > Math.ceil(total_records / perpageLimit) && (<NoData/>)}

            </>) : (<DataNotFound/>)}


        </>
    )
}
