import React from 'react'
import { useEffect } from 'react'
import { useState } from 'react'
import useHttp from '../../hooks/useHttp'
import usePaginate from '../../hooks/usePaginate'
import { pageTitles } from '../../configuration/GlobalConfig'
import DeploymentCenterListing from './DeploymentCenterListing'
import DeploymentCenterSummary from './DeploymentCenterSummary'
import SearchBar from '../UI/SearchBar/SearchBar'
import Button from '../UI/Button'
import Loading from '../UI/Loading'
import Spinner from '../UI/Spinner'
import NoData from '../UI/NoData'
 import useAuth from '../../hooks/useAuth'
export default function DeploymentCentre() {
    document.title = pageTitles.CHARGING_CENTRES_LIST;
    const [hasMore, setHasMore] = useState(false);
    const [deploymentCenterList, setdeploymentCenterList] = useState("");
    const [currentPage, setCurrentPage] = useState(1);
    const [usersPerPage, setUsersPerPage] = useState(5);
    const [total_records, setTotalRecords] = useState(0);
    const [searchValue, setSearchValue] = useState("");
    const [eventInitiated, setEventInitiated] = useState(false);
    const [isSuccess, setisSuccess] = useState(false);
    const perpageLimit = 10;
    const { auth } = useAuth();
    const [pageNumber, setPageNumber] = useState(1);
    const { isLoading, sendRequest: getDeploymentCentres } = useHttp();
    const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);

    const paginate = (number) => {
        setCurrentPage((prev) => {
            if (!eventInitiated && searchValue !== "") {

                return 1;
            }
            return number;
        });

    };
    let url = process.env.REACT_APP_DEPLOYEMENT_CENTER_LIST;

    url = url + `&page=${pageNumber}&limit=${perpageLimit}`;
    if (searchValue !== "") {

        url = url + `&search_by=centre_name&search_keyword=${searchValue}`
    }
    useEffect(() => {
        const setDeploymentCentres = (centres) => {
            const { data } = centres?.data?.response;
            if (data?.deployment_centres) {
                setdeploymentCenterList((prev) => {

                    return [...new Set([...prev, ...data?.deployment_centres])]

                });
                setTotalRecords(data?.count)

            }
            else {
                setdeploymentCenterList({})
            }

            if (data?.count == data?.deployment_centres?.length) {
                setHasMore(false);
            }
            else {

                setHasMore(centres?.data?.response?.data?.deployment_centres?.length > 0);
            }

        };
        if (pageNumber == 1 || (Math.ceil(total_records / perpageLimit) >= pageNumber)) {

            getDeploymentCentres(
                {
                    url
                },
                setDeploymentCentres

            );
        }


    }, [url, getDeploymentCentres, pageNumber, searchValue, isSuccess])
    return (
        <>
            <div class="subContent AttendantDashBoard">
                 <DeploymentCenterSummary />
                <div class="searchPanel mb-24">
                    <SearchBar placeholder={"Search by charging station name"} searchValue={searchValue} setSearchValue={setSearchValue} setPageNumber={setPageNumber} setData={setdeploymentCenterList} />
                    {auth.priviliges.includes("write_charging_center") && <Button value={"Add new charging station"} btn_link={"/addNewChargingCentre"} />}
                </div>
                <DeploymentCenterListing data={deploymentCenterList} currentPage={currentPage} usersPerPage={usersPerPage} paginate={paginate}
                    total_records={total_records} setUsersPerPage={setUsersPerPage} setCurrentPage={setCurrentPage} isSuccess={isSuccess} setisSuccess={setisSuccess}
                    lastElementRef={lastElementRef} setdata={setdeploymentCenterList}

                />
                {isLoading && pageNumber != "1" && <Loading />}

                {pageNumber != "1" && pageNumber > Math.ceil(total_records / perpageLimit) && (<NoData />)}
            </div>
        </>
    )
}
