import moment from 'moment';
import React, { useEffect, useState } from 'react';
import { useLocation, useParams } from 'react-router-dom';
import { axiosPrivate } from '../../api/PrivateRequestServices';
import { pageTitles } from '../../configuration/GlobalConfig';
import Message from '../../utils/Message';
import ChargingBayList from './ChargingBayList';
import MarkInactivePopUp from './MarkInactivePopUp';
import SwappableBatteriesList from './SwappableBatteriesList';
import useAuth from '../../hooks/useAuth';
export default function DeploymentCenterDetails() {
    document.title = pageTitles.CHARGING_CENTRES_DETAILS;
    const params = useParams();
    const { auth } = useAuth();
    const [centreDetails, setcentreDetails] = useState({
        name: "",
        id: "",
        addedOn: "",
        total_swappable_batteries: "",
        total_car_space: "",
        status: ""
    });

    const [reasons, setReasons] = useState("");
    const centre_id = params.centre_id
    const { state } = useLocation();
    const [markinactivePopUp, setMarkInactivePopUp] = useState(false);
    const [showSubComponent, setshowSubComponent] = useState({
        charging_bay: true,
    });
    const [data, setData] = useState({
        id: "",
        name: "",
        update_url: "",
        centre_id: ""
    })
    const [updateRequest, setupdateRequest] = useState({
        centre_id: "",
        status: "",

    })
    const onBackdropClick = () => {

        setisUpdated(false);
    }
    const [isSuccess, setisSuccess] = useState(false);
    const [isUpated, setisUpdated] = useState(false);
    const [successData, setsuccessData] = useState({
        message: {
            text: ""
        },
        successLink: "",
        successValue: "",
        isSuccess: "",
        onBackdropClick: ""

    })
    const handler = (e) => {
        setshowSubComponent({ [e.target.id]: true });
    };
    const handleClick = async () => {

        const UPDATE_URL = process.env.REACT_APP_UPDATE_DEPLOYMENT_CENTRE;
        if (state && state?.status == "A" || centreDetails.status == "A") {
            const URL = process.env.REACT_APP_BOOKING_CANCELLATION_REASON + `&object_type=DC`;
            const response = await axiosPrivate.get(URL);
            if (response?.data?.status == "200") {
                setReasons(response?.data?.response?.data?.cancellation_reasons);
            }
            setData({
                name: state ? state.name : centreDetails.name,
                centre_id: state ? state.id : centreDetails.id,
                update_url: UPDATE_URL


            })
            setupdateRequest({

                status: "D",
                centre_id: centre_id

            })
            setMarkInactivePopUp(true);
        }
        else {
            const req = {
                status: "A",
                centre_id: centre_id
            }
            const response = await axiosPrivate.post(UPDATE_URL, req);
            if (response?.data?.status == "200") {
                setisSuccess(!isSuccess)
                if (state) {
                    state.status = "A"
                }
                else {
                    setcentreDetails({ status: "A" })
                }
                setisUpdated(true);
                setsuccessData({
                    message: {
                        text: response?.data?.message
                    },
                    successLink: `/charging_centers/details/${centre_id}`,
                    successValue: "Go Back To Charging Centre Details",
                    isSuccess: true,
                    onBackdropClick: onBackdropClick
                })


            }

        }
    }
    const getDetails = async () => {
        let URL = process.env.REACT_APP_DEPLOYEMENT_CENTER_LIST + `&centre_id=${centre_id}`;
        const response = await axiosPrivate.get(URL);
        if (response?.data?.status == "200") {
            setcentreDetails({
                name: response?.data?.response?.data?.deployment_centres[0]?.centre_name,
                id: response?.data?.response?.data?.deployment_centres[0]?.centre_id,
                addedOn: response?.data?.response?.data?.deployment_centres[0]?.created_at,
                status: response?.data?.response?.data?.deployment_centres[0]?.status,
                total_car_space: response?.data?.response?.data?.deployment_centres[0]?.total_car_space,
                total_swappable_batteries: response?.data?.response?.data?.deployment_centres[0]?.total_swappable_batteries


            })


        }

    }
    useEffect(() => {
        if (!state || state == undefined) {
            getDetails();

        }


    }, [isUpated]);

    return (
        <>
            {isUpated && <Message
                message={successData.message}
                successLink={successData.successLink}
                successValue={successData.successValue}
                isSuccess={successData.isSuccess}
                onBackdropClick={successData.onBackdropClick}
                setShowMessage={setisUpdated}
                doNotNavigate={true}

            />}
            {markinactivePopUp && <MarkInactivePopUp heading="Mark station as inactive" reasons={reasons} data={data} setMarkInactivePopUp={setMarkInactivePopUp}
                updateRequest={updateRequest} setupdateRequest={setupdateRequest} isSuccess={isSuccess} setisSuccess={setisSuccess} type={"centre"} status_value={state ? state?.status : setcentreDetails}
                state={state} setisUpdated={setisUpdated} setsuccessData={setsuccessData}

            />}

            <div class="subContent">
                <div class="boxType1 bgBox2">
                    <div class="userInfo big mr-0">
                        <div class="name">
                            <span>{state ? state.name : centreDetails.name}</span>
                            <span><b className={state?.status == "A" || centreDetails?.status == "A" ? "success" : "error"}>{state?.status == "A" || centreDetails?.status == "A" ? "Active" : "Inactive"}</b>&nbsp;&nbsp;•&nbsp;&nbsp;#{centre_id}&nbsp;&nbsp;•&nbsp;&nbsp;Added on {state ? state.added_on : moment(centreDetails.addedOn).format("DD MMMM YYYY")}</span>
                            {/* <span>#{state ? state.id : centreDetails.id} • Added on {state ? state.added_on : moment(centreDetails.addedOn).format("DD MMMM YYYY")}</span> */}
                        </div>
                        {auth.priviliges.includes("write_charging_center") &&
                            <div style=
                                {{ marginLeft: "auto" }}
                            >
                                <div class="actionNav wBorder">
                                    <i class="material-symbols-rounded mt-m grey">more_vert</i>
                                    <div class="dropMenuWrap">
                                        <ul class="dropMenu" style={{ width: "180px" }}>
                                            <li>
                                                <a class="error open_model" data-target="assignInactive" onClick={handleClick}>{state ? state.status == "A" ? "Mark as inactive" : "Mark as active" : centreDetails.status == "A" ? "Mark as inactive" : "Mark as active"}</a>

                                                {/* <a class="error open_model" data-target="assignInactive" onClick={handleClick}>{state && state.status == "A" || centreDetails.status == "A" ? "Mark as inactive" : "Mark as active"}</a> */}
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>}
                    </div>
                    <div class="navTabs mt-24 mb-24">
                        <ul class="level1">
                            <li class={showSubComponent.charging_bay ? "selected" : ""}>
                                <a onClick={handler} id="charging_bay">Charging bay ({state ? state.total_car_space : centreDetails.total_car_space})</a>
                            </li>
                            <li class={showSubComponent.batteries ? "selected" : ""}>
                                <a onClick={handler} id="batteries">Swappable batteries ({state ? state.total_swappable_batteries : centreDetails.total_swappable_batteries})</a>
                            </li>
                        </ul>
                    </div>
                    {showSubComponent.charging_bay && <ChargingBayList deployment_center_id={state ? state.id : centreDetails.id} setisUpdated={setisUpdated} setsuccessData={setsuccessData} onBackdropClick={onBackdropClick} centre_id={centre_id} />}
                    {showSubComponent.batteries && <SwappableBatteriesList deployment_center_id={state ? state.id : centreDetails.id} setisUpdated={setisUpdated} setsuccessData={setsuccessData} onBackdropClick={onBackdropClick} centre_id={centre_id} />}

                </div>
            </div>
        </>
    )
}
