import React from 'react'
import { useState } from 'react'
import Spinner from '../UI/Spinner'
import Pagination from '../Customer/Pagination'
import Message from '../../utils/Message'
import { Link } from 'react-router-dom'
import { useNavigate } from 'react-router-dom'
import moment from 'moment'
import AddNewBattery from './AddNewBattery'
import AddNewBay from './AddNewBay'
import DataNotFound from '../UI/DataNotFound'
import useAuth from '../../hooks/useAuth'
export default function DeploymentCenterListing({ data, currentPage, usersPerPage, paginate, total_records, setUsersPerPage, setCurrentPage, isSuccess, setisSuccess, lastElementRef, setdata }) {
    const navigate = useNavigate();
    const { auth } = useAuth();
    const [addNewBattery, setaddNewBattery] = useState(false);
    const [addNewBay, setaddNewBay] = useState(false);
    const [deploymentcenterId, setdeploymentcenterId] = useState("");
    const [isCreated, setisCreated] = useState(false);
    const [successData, setsuccessData] = useState({
        message: {
            text: ""
        },
        successLink: "",
        successValue: "",
        isSuccess: "",
        onBackdropClick: ""

    });
    const [index, setIndex] = useState("")
    return (
        <>
            {isCreated && <Message
                message={successData.message}
                successLink={successData.successLink}
                successValue={successData.successValue}
                isSuccess={successData.isSuccess}
                onBackdropClick={successData.onBackdropClick}
                setShowMessage={setisCreated}
                doNotNavigate={true}

            />}
            {addNewBattery && <AddNewBattery setaddNewBattery={setaddNewBattery} deploymentcenterId={deploymentcenterId} isSuccess={isSuccess} setisSuccess={setisSuccess} addNewBattery={addNewBattery} setisCreated={setisCreated} setsuccessData={setsuccessData} setdata={setdata} data={data} index={index} />}
            {addNewBay && <AddNewBay setaddNewBay={setaddNewBay} deploymentcenterId={deploymentcenterId} isSuccess={isSuccess} setisSuccess={setisSuccess} setisCreated={setisCreated} setsuccessData={setsuccessData} setdata={setdata} data={data} index={index} />}

            {data == "" ? (<Spinner />) : data && Object.keys(data)?.length != "0" ? (<>
                <div class="dataTableDynamic">
                    <table>
                        <tbody>
                            <tr>
                                <th>Charging station name</th>
                                <th>Location</th>
                                <th>Added on</th>
                                <th>Swappable batteries</th>
                                <th>Recharge bay slots</th>
                                <th>Status</th>
                                <th>&nbsp;</th>
                            </tr>
                            {data && data?.length > "0" && data.map((deploymentcenter, index) => {
                                if (data?.length == index + 1) {
                                    return (<>
                                        <tr ref={lastElementRef}>
                                            <td>
                                                <div>{deploymentcenter.centre_name}</div>
                                                <em>{"#" + deploymentcenter.centre_id}</em>
                                            </td>
                                            <td>{deploymentcenter.address ? deploymentcenter.address : "N/A"}</td>
                                            <td>{moment(deploymentcenter.created_at).format("DD MMMM YYYY")}</td>
                                            <td>
                                                <div class="">{deploymentcenter.total_swappable_batteries} batteries</div>

                                            </td>
                                            <td>
                                                <div class="">{deploymentcenter.total_car_space} bays</div>

                                            </td>
                                            <td class={deploymentcenter.status == "A" ? "success" : "error"}>{deploymentcenter.status == "A" ? "Active" : "Inactive"}</td>
                                            <td class="right">
                                                <div class="actionNav">
                                                    <i class="material-symbols-rounded mt-m grey">more_vert</i>
                                                    <div class="dropMenuWrap">
                                                        <ul class="dropMenu" style={{ width: "180px" }}>
                                                            {auth.priviliges.includes("write_charging_center") &&
                                                                <>
                                                            <li>
                                                                <a class="open_model" data-target="ChargingCentersP_AddBattery" onClick={() => { setaddNewBattery(true); setdeploymentcenterId(deploymentcenter.centre_id) }}>Add new charging device</a>
                                                            </li>
                                                            <li>
                                                                <a class="open_model" data-target="ChargingCentersP_AddBattery" onClick={() => { setaddNewBay(true); setdeploymentcenterId(deploymentcenter.centre_id) }}>Add new charging bay</a>
                                                            </li></>}
                                                            <li onClick={() => { navigate(`/charging_centers/details/${deploymentcenter.centre_id}`, { state: { name: deploymentcenter.centre_name, id: deploymentcenter.centre_id, added_on: moment(deploymentcenter.created_at).format("DD MMMM YYYY"), status: deploymentcenter.status, total_car_space: deploymentcenter.total_car_space, total_swappable_batteries: deploymentcenter.total_swappable_batteries } }) }}>
                                                                <Link >View details</Link>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>

                                    </>)

                                }
                                else {
                                    return (<>
                                        <tr >
                                            <td>
                                                <div>{deploymentcenter.centre_name}</div>
                                                <em>{"#" + deploymentcenter.centre_id}</em>
                                            </td>
                                            <td>{deploymentcenter.address ? deploymentcenter.address : "N/A"}</td>
                                            <td>{moment(deploymentcenter.created_at).format("DD MMMM YYYY")}</td>
                                            <td>
                                                <div class="">{deploymentcenter.total_swappable_batteries} batteries</div>

                                            </td>
                                            <td>
                                                <div class="">{deploymentcenter.total_car_space} bays</div>

                                            </td>
                                            <td class={deploymentcenter.status == "A" ? "success" : "error"}>{deploymentcenter.status == "A" ? "Active" : "Inactive"}</td>
                                            <td class="right">
                                                <div class="actionNav">
                                                    <i class="material-symbols-rounded mt-m grey">more_vert</i>
                                                    <div class="dropMenuWrap">
                                                        <ul class="dropMenu" style={{ width: "180px" }}>
                                                            {auth.priviliges.includes("write_charging_center") &&
                                                                <>
                                                            <li>
                                                                <a class="open_model" data-target="ChargingCentersP_AddBattery" onClick={() => { setaddNewBattery(true); setdeploymentcenterId(deploymentcenter.centre_id); setIndex(index) }}>Add new charging device</a>
                                                            </li>
                                                            <li>
                                                                <a class="open_model" data-target="ChargingCentersP_AddBattery" onClick={() => { setaddNewBay(true); setdeploymentcenterId(deploymentcenter.centre_id); setIndex(index) }}>Add new charging bay</a>
                                                                    </li></>}
                                                            {auth.priviliges.includes("read_charging_center") &&
                                                                <li onClick={() => { navigate(`/charging_centers/details/${deploymentcenter.centre_id}`, { state: { name: deploymentcenter.centre_name, id: deploymentcenter.centre_id, added_on: moment(deploymentcenter.created_at).format("DD MMMM YYYY"), status: deploymentcenter.status, total_car_space: deploymentcenter.total_car_space, total_swappable_batteries: deploymentcenter.total_swappable_batteries } }) }}>
                                                                    <Link >View details</Link>
                                                                </li>}
                                                        </ul>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>

                                    </>)
                                }


                            })}

                        </tbody>
                    </table>

                </div>



            </>) : (<DataNotFound/>)}

        </>
    )
}
