import React from 'react'
import { useState, useEffect } from 'react'
import useAxiosIntercept from '../../hooks/useAxiosIntercept'

export default function DeploymentCenterSummary() {

    const axiosPrivate = useAxiosIntercept();
    const [summary, setSummary] = useState("");
    const getDeploymentCenterSummary = async () => {
        const URL = process.env.REACT_APP_DEPLOYMENT_CENTRE_SUMMARY;
        const response = await axiosPrivate.get(URL);
        if (response?.data?.status == "200") {
            setSummary(response?.data?.response?.data)
        }
    }
    useEffect(() => {
        getDeploymentCenterSummary();

    }, [])
    return (
        <>
            <div class="xRow fullWidth lookUpDataDashboard mb-24">
                <div class="boxT1">
                    <p>Total charging stations</p>
                    <span>{summary?.total_active_centres}</span>
                    {/* <div class="numberBrif">
                        <p>
                            <span>Swapable</span>
                            <span>100</span>
                        </p>
                        <p>
                            <span>Recharge bay</span>
                            <span>100</span>
                        </p>
                    </div> */}
                </div>
                <div class="boxT1">
                    <p>Swappable batteries</p>
                    <span>{summary?.total_active_swappable_batteries}</span>
                    {/* <div class="numberBrif">
                        <p>
                            <span>Full charged</span>
                            <span>100</span>
                        </p>
                        <p>
                            <span>Recharging</span>
                            <span>100</span>
                        </p>
                    </div> */}
                </div>
                <div class="boxT1">
                    <p>Recharge bays</p>
                    <span>{summary?.total_active_bays}</span>
                    {/* <div class="numberBrif">
                        <p>
                            <span>Booked</span>
                            <span>100</span>
                        </p>
                        <p>
                            <span>Free</span>
                            <span>100</span>
                        </p>
                    </div> */}
                </div>
            </div>

        </>
    )
}
