import React from 'react'
import Overlay from '../../utils/Overlay'
import useAxiosIntercept from '../../hooks/useAxiosIntercept'
import { useState } from 'react'
import Success from '../UI/Success'
import Error from '../UI/Error'
import { useParams } from 'react-router-dom'
import { message } from 'antd'
export default function MarkInactivePopUp({ heading, reasons, data, updateRequest, setMarkInactivePopUp, isSuccess, setisSuccess, type, status_value, state, setsuccessData, setisUpdated, list, setlist }) {

    const axiosPrivate = useAxiosIntercept();
    const params = useParams();
    const [success, setSuccess] = useState("");
    const [error, setError] = useState("")
    const [reasonId, setReasonId] = useState("");
    const centre_id = params.centre_id;
    const handleInput = (e) => {
        setError("")
        setReasonId(e.target.id);

    }
    const close = () => {
        setMarkInactivePopUp(false);
        document.body.classList.remove("hidden");

    }
    const onBackdropClick = () => {

        setisUpdated(false);
    }
    const markInactive = async () => {
        if (reasonId == "") {
            setError("Please select any reason")

        }
        else {
            const URL = data.update_url + `&reason_id=${reasonId}`;
            const response = await axiosPrivate.post(URL, updateRequest);
            if (response?.data?.status == "200") {
                if (type && type == "centre") {
                    if (status_value == "A") {
                        state.status = "D"
                    }
                    else {
                        status_value({
                            status: "D"
                        })
                    }

                }
                if (type && type == "battery") {
                    const temp = [...list];
                    temp[data?.index].status = "D";
                    setlist(temp);

                }
                if (type && type == "bay") {
                    const temp = [...list];
                    temp[data?.index].status = "D";
                    setlist(temp);


                }
                close();
                setisSuccess(!isSuccess)
                setisUpdated(true);
                setsuccessData({
                    message: {
                        text: response?.data?.message
                    },
                    successLink: `/charging_centers/details/${centre_id}`,
                    successValue: "Go Back To Charging Centre Details",
                    isSuccess: true,
                    onBackdropClick: onBackdropClick
                })
            }
            else {
                setError(response?.data?.response?.errors[0]?.message);
            }

        }



    }
    return (
        <>
            <Overlay>
                <div class="model_box_child assignInactive1" id="assignInactive1" style={{ width: "300px" }}>
                    <div class="ap_heading">
                        <h4>{heading}<span class="material-symbols-rounded black close_model" onClick={close}>close</span>
                        </h4>
                    </div>
                    <div class="contentSection">
                        <section class="assignPromoP dForm">
                            <div class="promoText customer">
                                {data.id && <h4>#{data.id}</h4>}
                                {data.name && <h4>{data.name}</h4>}
                                {data.total_charging_power && <p>{data.total_charging_power} kWh</p>}
                                {data.centre_id && <p>#{data.centre_id}</p>}
                            </div>
                            <div class="fieldGroup">
                                <label>Select reason to mark inactive</label>
                                <ul class="yType">
                                    {reasons && reasons?.length > "0" && reasons.map((reason, i) => {

                                        return (<>
                                            <li>
                                                <input type="radio" id={reason.reason_id} name="radio" value={reason.reason} onClick={handleInput} />
                                                <label for={reason.reason_id}>{reason.reason}</label>
                                            </li>


                                        </>)


                                    })}



                                </ul>
                            </div>
                        </section>
                        <div class="actionButtons mt-24">
                            <span>
                                <a onClick={markInactive} class="btn prim btnError">Mark inactive</a>
                                <Success success={success} />
                                <Error error={error} />
                            </span>
                        </div>


                    </div>
                </div>


            </Overlay>

        </>
    )
}
