import React, { useEffect } from 'react'
import useHttp from '../../hooks/useHttp';
import usePaginate from '../../hooks/usePaginate';
import { useState } from 'react'
import moment from 'moment';
import { useParams } from 'react-router-dom';
import Spinner from '../UI/Spinner';
import Loading from '../UI/Loading';
import useAxiosIntercept from '../../hooks/useAxiosIntercept';
import MarkInactivePopUp from './MarkInactivePopUp';
import NoData from '../UI/NoData';
import DataNotFound from '../UI/DataNotFound';
import useAuth from '../../hooks/useAuth';
export default function SwappableBatteriesList({ deployment_center_id, setisUpdated, setsuccessData, onBackdropClick, centre_id }) {
    const params = useParams();
    const { auth } = useAuth();
    const axiosPrivate = useAxiosIntercept();
    const [batteryData, setBatteryData] = useState({
        id: "",
        total_charging_power: "",
        update_url: "",
        centre_id: ""
    });
    const [updateRequest, setupdateRequest] = useState({
        charger_id: "",
        status: "D"


    })
    const [hasMore, setHasMore] = useState(false);
    const [markinactivePopUp, setMarkInactivePopUp] = useState(false)
    const [reasons, setReasons] = useState("");
    const [batteries, setBatteries] = useState("");
    const [total_records, setTotalRecords] = useState(0);
    const [isSuccess, setisSuccess] = useState(false);
    const perpageLimit = 10;
    const [pageNumber, setPageNumber] = useState(1);
    const { isLoading, sendRequest: getSwappableBatteries } = useHttp();
    const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);
    let url = process.env.REACT_APP_SWAPPABLE_BATTERY_LIST;
    url = url + `&deployment_centre_id=${params.centre_id}&limit=${perpageLimit}&page=${pageNumber}`
    const hadleClick = async (charger_id, total_battery_capacity, status, serialno, index) => {
        const UPDATE_URL = process.env.REACT_APP_UPDATE_CHARGER
        if (status == "A") {
            const URL = process.env.REACT_APP_BOOKING_CANCELLATION_REASON + `&object_type=C`;
            const response = await axiosPrivate.get(URL);
            if (response?.data?.status == "200") {
                setReasons(response?.data?.response?.data?.cancellation_reasons);
            }
            setBatteryData({
                id: serialno,
                total_charging_power: total_battery_capacity,
                update_url: UPDATE_URL,
                center_id: deployment_center_id,
                index: index


            });
            setupdateRequest({
                charger_id: charger_id,
                status: "D"

            })
            setMarkInactivePopUp(true);

        }
        else {
            const req = {
                charger_id: charger_id,
                status: "A"
            }
            const response = await axiosPrivate.post(UPDATE_URL, req);

            if (response?.data?.status == "200") {
                const temp = [...batteries];
                temp[index].status = "A";
                setBatteries(temp);
                setisSuccess(!isSuccess);
                setisUpdated(true);
                setsuccessData({
                    message: {
                        text: response?.data?.message
                    },
                    successLink: `/charging_centers/details/${centre_id}`,
                    successValue: "Go Back To Charging Centre Details",
                    isSuccess: true,
                    onBackdropClick: onBackdropClick
                })

            }

        }
    }

    useEffect(() => {
        const setswappablebatteries = (batteries) => {
            const { data } = batteries?.data?.response;

            if (data?.chargers) {

                setBatteries((prev) => {

                    return [...new Set([...prev, ...data?.chargers])]

                });

                setTotalRecords(data?.total)

            }
            else {
                setBatteries({})
            }

            if (data?.total == data?.chargers?.length) {
                setHasMore(false);
            }
            else {

                setHasMore(batteries?.data?.response?.data?.chargers?.length > 0);
            }

        };
        if (pageNumber == 1 || (Math.ceil(total_records / perpageLimit) >= pageNumber)) {

            getSwappableBatteries(
                {
                    url
                },
                setswappablebatteries

            );
        }


    }, [ url, getSwappableBatteries, pageNumber])
    return (
        <>

            {markinactivePopUp && <MarkInactivePopUp heading="Mark battery inactive" reasons={reasons} data={batteryData} setMarkInactivePopUp={setMarkInactivePopUp}
                updateRequest={updateRequest} setupdateRequest={setupdateRequest} isSuccess={isSuccess} setisSuccess={setisSuccess} setsuccessData={setsuccessData} setisUpdated={setisUpdated}
                type={"battery"} list={batteries} setlist={setBatteries}

            />}
            {batteries == "" ? <><Spinner /></> : batteries && Object.keys(batteries)?.length != "0" ? (<>
                <div class="dataTableDynamic">
                    <table>
                        <tbody>
                            <tr>
                                <th>Swappable battery ID</th>
                                <th>Charging power</th>
                                <th>Added on</th>
                                <th>Status</th>
                                <th>&nbsp;</th>
                            </tr>
                            {batteries && batteries?.length > 0 && batteries.map((battery, index) => {
                                const AddedOn = `${battery?.created_at}`

                                if (batteries?.length === index + 1) {

                                    return (<>
                                        <tr ref={lastElementRef}>
                                            <td><span>#{battery.serial_number}</span></td>
                                            <td>{battery.total_charging_capacity} kWh</td>
                                            <td>{moment(AddedOn).format("DD MMMM YYYY")}</td>
                                            <td class={battery.status == "A" ? "success" : "error"}>{battery.status == "A" ? "Active" : "Inactive"}</td>
                                            {auth.priviliges.includes("write_charging_center") &&
                                                <td class="right">
                                                    <div class="actionNav">
                                                        <i class="material-symbols-rounded mt-m grey">more_vert</i>
                                                        <div class="dropMenuWrap">
                                                            <ul class="dropMenu" style={{ width: "180px" }}>
                                                                <li>
                                                                    <a onClick={() => { hadleClick(battery.charger_id, battery.total_charging_capacity, battery.status, battery.serial_number, index) }} class="error open_model" data-target="assignInactive1">{battery.status == "A" ? "Mark as inactive" : "Mark as active"}</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </td>}
                                        </tr>

                                    </>)

                                }
                                else {
                                    return (<>
                                        <tr>
                                            <td><span>#{battery.serial_number}</span></td>
                                            <td>{battery.total_charging_capacity} kWh</td>
                                            <td>{moment(AddedOn).format("DD MMMM YYYY")}</td>
                                            <td class={battery.status == "A" ? "success" : "error"}>{battery.status == "A" ? "Active" : "Inactive"}</td>
                                           {auth.priviliges.includes("write_charging_center") &&
                                                <td class="right">
                                                    <div class="actionNav">
                                                        <i class="material-symbols-rounded mt-m grey">more_vert</i>
                                                        <div class="dropMenuWrap">
                                                            <ul class="dropMenu" style={{ width: "180px" }}>
                                                                <li>
                                                                    <a onClick={() => { hadleClick(battery.charger_id, battery.total_charging_capacity, battery.status, battery.serial_number, index) }} class="error open_model" data-target="assignInactive1">{battery.status == "A" ? "Mark as inactive" : "Mark as active"}</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </td>}
                                        </tr>

                                    </>)

                                }



                            })}

                        </tbody>
                    </table>
                </div>
                {isLoading && pageNumber != "1" && <Loading/>}
                {pageNumber != "1" && pageNumber > Math.ceil(total_records / perpageLimit) && (<NoData/>)}



            </>) : (<DataNotFound/>)}

        </>

    )

}
