import React from "react";
import { useState } from "react";
import Overlay from "../../utils/Overlay";
import { Link } from "react-router-dom";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import Error from "../UI/Error";
import { useParams } from "react-router-dom";
import Success from "../../components/UI/Success";
export default function AssignCredits({
  onBackdropClick,
  firstname,
  lastname,
  setshowassignPopUp,
  reasons,
  setpromoassigned,
  promoAssigned,
}) {
  const [creditAmout, setcreditAmount] = useState("");
  const [reasonid, setreasonid] = useState("");
  const [remarks, setremarks] = useState("");
  const params = useParams();
  const [isSubmit, setisSubmit] = useState(false);
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");
  const customer_user_id = params.user_id;
  //const reasons = [{ id: "8", label: "Loyality credit to user" }];
  const axiosPrivate = useAxiosIntercept();
  const submit = async () => {
    setisSubmit(true);
    const URL = process.env.REACT_APP_ADD_CREDITS;
    const body = {
      credit_amount: creditAmout,
      reason_id: reasonid,
      customer_user_id: customer_user_id,
      staff_note: remarks,
    };
    if (
      creditAmout != "" &&
      reasonid != "" &&
      customer_user_id != "" &&
      remarks != ""
    ) {
      const response = await axiosPrivate.post(URL, body);

      if (response?.data?.status == "200") {
        setErrorMessage("");

        setpromoassigned(!promoAssigned);
        setSuccessMessage("Credits added successfully");
        setTimeout(() => {
          //setSuccess(!success);
          onBackdropClick();
        }, 3000);
      } else {
        setErrorMessage("");
        setErrorMessage(response?.data?.message);
      }
    }
  };
  return (
    <>
      <Overlay>
        <div
          class="model_box_child assignCreditsP"
          id="assignCreditsP"
          style={{ width: "300px" }}
        >
          <div class="ap_heading">
            <h4>
              Assign credits
              <span
                class="material-symbols-rounded black close_model"
                onClick={onBackdropClick}
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection">
            <section class="assignPromoP dForm">
              <div class="promoText customer">
                <p>Customer name</p>
                <em>{firstname ? firstname + " " + lastname : "Guest"}</em>
              </div>
              <div class="fieldGroup">
                <label>Credits</label>
                <div class="multiOption">
                  <input
                    type="number"
                    value={creditAmout}
                    placeholder="Enter credits"
                    name=""
                    onChange={(e) => {
                      setcreditAmount(e.target.value);
                    }}
                  />
                  <div class="sepText bg">
                    <span>$</span>
                  </div>
                </div>
                {isSubmit && creditAmout == "" && (
                  <Error error={"Credit amount is required"} />
                )}
              </div>
              <div class="fieldGroup">
                <label>Select reason</label>
                <ul class="yType">
                  {reasons &&
                    reasons.map((reason) => {
                      return (
                        <>
                          <li>
                            <input
                              type="radio"
                              id={reason.reason_id}
                              name="radio"
                              onClick={(e) => {
                                setreasonid(e.target.id);
                              }}
                              value={reason.reason_name}
                            />
                            <label for={reason.reason_id}>
                              {reason.reason_name}
                            </label>
                          </li>
                        </>
                      );
                    })}
                </ul>
                {isSubmit && reasonid == "" && (
                  <Error error={"Reason id is required"} />
                )}
              </div>
              <div class="fieldGroup">
                <label>Remarks</label>
                <span>
                  <textarea
                    type="text"
                    value={remarks}
                    placeholder="Enter any remarks"
                    name=""
                    onChange={(e) => {
                      setremarks(e.target.value);
                    }}
                  ></textarea>
                </span>
                {isSubmit && remarks == "" && (
                  <Error error={"Remarks is required"} />
                )}
              </div>
            </section>
            <div class="actionButtons mt-24">
              <span>
                <Link href="" class="btn prim fullW" onClick={submit}>
                  Add credits
                </Link>
              </span>
            </div>
            {successMessage ? (
              <>{successMessage && <Success success={successMessage} />}</>
            ) : (
              ""
            )}
            {creditAmout === "" && errorMessage ? (
              <>
                <Error error={errorMessage} />
              </>
            ) : (
              ""
            )}
          </div>
        </div>
      </Overlay>
    </>
  );
}
