import React from 'react'
import { useState } from 'react';
import ViewChargeHistory from '../../utils/ViewChargeHistory';
import useAxiosIntercept from '../../hooks/useAxiosIntercept';
import { Circle } from 'rc-progress';
import { Time } from '../../utils/Time';
export default function BatteryStatus({ bookingstatus, bookingData, vehicle_registration_no, package_name, vehicle_brand, vehicle_model, variant_image, booking_id, setOpenImage,
  openImage,
  imageData,
  setimageData }) {
  const axiosPrivate = useAxiosIntercept();
  const [showchargeHistory, setShowChargeHistory] = useState(false);
  const charging_status = bookingData?.charging_data?.service_status;
  const initial_charge = bookingData?.charging_data?.initial_charge;
  const charging_done = bookingData?.charging_data?.charging_done;
  const charging_time = bookingData?.charging_data?.charging_time;
  const charging_cost = bookingData?.charging_data?.charging_cost;
  const final_charge = bookingData?.charging_data?.final_charge;
  const initial_charging_time = bookingData?.charging_data?.initial_charging_time ? Time(bookingData?.charging_data?.initial_charging_time) : "";
  const final_charging_time = bookingData?.charging_data?.final_charging_time ? Time(bookingData?.charging_data?.final_charging_time) : "";
  //const =initial_charge-final_charge;
  const final_charging = parseFloat(initial_charge) + parseFloat(final_charge);
  const [activityLog, setactivityLog] = useState([]);
  const chargeHistory = async () => {

    const request = {
      booking_id: booking_id,
      service_id: "1"

    }
    const response = await axiosPrivate.post(process.env.REACT_APP_GET_SERVICE_HISTORY, request);
    if (response?.status == "200") {
      setactivityLog(response?.data?.response?.data?.service_log[0]?.activity_log);


    }
    setShowChargeHistory(true);

  }
  const onBackdropClick = () => {
    setShowChargeHistory(false);
    document.body.classList.remove("hidden");
  }
  return (
    <>
      {showchargeHistory && activityLog.length > 0 && <ViewChargeHistory onBackdropClick={onBackdropClick} vehicle_registration_no={vehicle_registration_no} package_name={package_name}
        vehicle_brand={vehicle_brand} vehicle_model={vehicle_model} variant_image={variant_image} activityLog={activityLog} setOpenImage={setOpenImage}
        openImage={openImage}
        imageData={imageData}
        setimageData={setimageData}
      />}
      <div class="batteryStatus">
        <div class="progressBlock">
          <div class="bdinfo">
            <span>Started at</span>
            <p>{charging_status != "1" ? initial_charging_time : "--"}</p>
          </div>

          <div class={charging_status != "1" ? "progress-bar" : "progress-bar inactive"}>
            <Circle percent={charging_status == "1" ? 0 : final_charging} strokeWidth={5} strokeColor="#c49102" trailWidth={5} gapDegree="20" />

            <canvas
              id="inactiveProgress"
              class="progress-inactive"
              height="156px"
              width="156px"
            ></canvas>
            <canvas
              id="activeProgress"
              class="progress-active"
              height="156px"
              width="156px"
            ></canvas>

            <div class="progressinfo">
              <span>Battery</span>
              {<p>{charging_status == "1" ? "--" : charging_status == "2" ? initial_charge + "%" : (final_charging) + "%"}</p>}
              {/* <p>{charging_status != "1" ? init + "%" : "--"}</p> */}
              <span class="chrg">{charging_status != "1" ? "charging" : "not started"}</span>
            </div>
            <span class="chargingPointIco"></span>
          </div>

          <div class="bdinfo restchrg">
            {charging_status == "3" || charging_status == "4" || charging_status == "5" ? (<><span>{final_charging}% by</span></>) : ""}

            <p>{bookingstatus == "I" ? final_charging_time : "--"}</p>
          </div>

          <input
            type="range"
            id="progressController"
            hidden
            min="0"
            max="100"
            value="25"
          />
        </div>
        {
          charging_status != "1" ? (<div class="batteryChargeStatus mt-24">
            <div class="iCharge">
              <p>Initial charge</p>
              <span class="success">
                {initial_charge + "%"}
                <i
                  onClick={chargeHistory}
                  class="material-symbols-rounded grey arrowBottom mt-m arrow open_modelr"
                  data-target="cHistoryP"
                >
                  expand_more
                </i>
              </span>
            </div>
            <div class="chargeDone">
              <p>Charge done</p>
              <span class="success">
                {charging_status == "2" ? "--" : (<>{final_charge + "%"} <em>({charging_done + "kWh"})</em></>)}

              </span>
            </div>
            <div>
              <p>Total time</p>
              <span class="">{charging_time + " mins"}</span>
            </div>
            <div>
              <p>Charge bill</p>
              <span class="">{"$ " + charging_cost}</span>
            </div>
          </div>) : (<div class="batteryChargeStatus mt-24">
            <div class="iCharge">
              <p>Initial charge</p>
              <span>--</span>
            </div>
            <div class="chargeDone">
              <p>Charge done</p>
              <span>--</span>
            </div>
            <div>
              <p>Total time</p>
              <span class="">--</span>
            </div>
            <div>
              <p>Charge bill</p>
              <span class="">--</span>
            </div>
          </div>)
        }



      </div >
    </>
  )
}
