import React, { useState, useEffect } from "react";
import { useLocation, useParams, Link } from "react-router-dom";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import UpComingBookings from "./UpComingBookings";
import PastBookings from "./PastBookings";
import useHttp from "../../hooks/useHttp";
import usePaginate from "../../hooks/usePaginate";
import NoData from "../UI/NoData";
import Loading from "../UI/Loading";

const Bookings = ({ Bookingtype, firstname, lastname, userImage }) => {
  const params = useParams();
  const axiosPrivate = useAxiosIntercept();
  const [total_records, setTotalRecords] = useState(0);
  const [currentPage, setCurrentPage] = useState(1);
  const [usersPerPage, setUsersPerPage] = useState(5);
  const [isAttendantChanged, setisAttendantChanged] = useState(false);
  const [isPuppyChanged, setisPuppyChanged] = useState(false);
  const [isPaymentDone, setisPaymentDone] = useState(false);
  const [pageNumber, setPageNumber] = useState(1);
  const [isCancelled, setisCancelled] = useState(false);
  const [hasMore, setHasMore] = useState(false);
  const [BookingsDetails, setBookingsDetails] = useState("");
  const paginate = (number) => {
    setCurrentPage((prev) => {
      return number;
    });
  };
  const perPageLimit = 10;
  const url =
    process.env.REACT_APP_GET_BOOKING_HISTORY +
    `&page=${pageNumber}&limit=${perPageLimit}&`;
  const pastBookingrequest = {
    customer_user_id: params.user_id,
    is_active: 0,
    show_puppy_info: 1,
    show_driver_info: 1,
  };
  const upComingBookingrequest = {
    customer_user_id: params.user_id,
    is_active: 1,
    show_puppy_info: 1,
    show_driver_info: 1,
  };
  const request_method = "post";

  const { isLoading, sendRequest: getusers } = useHttp();

  const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);


  const request_body =
    Bookingtype == "pastBookings" ? pastBookingrequest : upComingBookingrequest;

  useEffect(() => {

    const setSearchedusers = (searchedUsers) => {
      const { data } = searchedUsers?.data?.response;

      if (data?.booking_records) {

        setBookingsDetails((prev) => {
          return [...new Set([...prev, ...data?.booking_records])];
        });
        setTotalRecords(data?.total);
      } else {

        setBookingsDetails({});
      }
      if (data?.total == data?.booking_records?.length) {
        setHasMore(false);
      } else {
        setHasMore(
          searchedUsers.data.response.data?.booking_records?.length > 0
        );
      }
    };
    if (
      pageNumber == 1 ||
      Math.ceil(total_records / perPageLimit) >= pageNumber
    ) {
      getusers(
        {
          url,
          request_method,
          request_body,
        },

        setSearchedusers
      );
    }

    // }
  }, [url, pageNumber, getusers, isCancelled]);
  // useEffect(() => {
  //   let isMounted = true;
  //   const controller = new AbortController();
  //   const getBookingsDetalis = async () => {
  //     const URL =
  //       process.env.REACT_APP_GET_BOOKING_HISTORY +
  //       `&page=${currentPage}&limit=${usersPerPage}&`;
  //     try {
  //       const pastBookingrequest = {
  //         customer_user_id: params.user_id,
  //         is_active: 0,
  //         show_puppy_info: 1,
  //         show_driver_info: 1,
  //       };
  //       const upComingBookingrequest = {
  //         customer_user_id: params.user_id,
  //         is_active: 1,
  //         show_puppy_info: 1,
  //         show_driver_info: 1,
  //       };

  //       const response = await axiosPrivate.post(
  //         URL,
  //         Bookingtype === "pastBookings"
  //           ? pastBookingrequest
  //           : upComingBookingrequest
  //       );

  //       if (response.data.status === 200) {
  //         isMounted &&
  //           setBookingsDetails(response?.data?.response?.data?.booking_records);
  //         setTotalRecords(response?.data?.response?.data?.total);
  //       } else {
  //         setBookingsDetails({});
  //       }
  //     } catch (err) {}
  //   };

  //   getBookingsDetalis();

  //   return () => {
  //     isMounted = false;
  //     controller.abort();
  //   };
  // }, [currentPage, isAttendantChanged, isPuppyChanged]);

  return (
    <>


      {Bookingtype === "pastBookings" ? (
        <PastBookings
          pastBookingData={BookingsDetails}
          total_records={total_records}
          pageNumber={pageNumber}
          setPageNumber={setPageNumber}
          perPageLimit={perPageLimit}
          paginate={paginate}
          isPaymentDone={isPaymentDone}
          setisPaymentDone={setisPaymentDone}
          setBookingsDetails={setBookingsDetails}
          lastElementRef={lastElementRef}
        />
      ) : (
        <UpComingBookings
          upComingBookingData={BookingsDetails}
          setupcomingBookings={setBookingsDetails}
          userImage={userImage}
          total_records={total_records}
          pageNumber={pageNumber}
          setPageNumber={setPageNumber}
          perPageLimit={perPageLimit}
          isAttendantChanged={isAttendantChanged}
          setisAttendantChanged={setisAttendantChanged}
          isPuppyChanged={isPuppyChanged}
          setisPuppyChanged={setisPuppyChanged}
          paginate={paginate}
          lastElementRef={lastElementRef}
          isCancelled={isCancelled}
          setisCancelled={setisCancelled}
        />
      )}
      <div>{isLoading && pageNumber != "1" && <Loading />}</div>
      {pageNumber != "1" && pageNumber > Math.ceil(total_records / perPageLimit) && (<NoData />)}

    </>
  );
};

export default Bookings;
