import { useState, useEffect } from "react";

//import UserList from "./List";
//import SelectBox from "./SelectBox";
import usePaginate from "../../../hooks/usePaginate";
import useHttp from "../../../hooks/useHttp";
import NoData from "../../UI/NoData";

import CorporateListing from "./CorporateListing";
import Loading from "../../UI/Loading";

const perPageLimit = 10;

function CorporateInfo({
  searchValue,
  setSearchValue,
  pageNumber,
  setPageNumber,
  corporateDetails,
  setCorporateDetails,
}) {
  const [searchText, setSearchText] = useState("");

  const [hasMore, setHasMore] = useState(false);
  const [showModal, setShowModal] = useState(false);
  const [selectedUser, setSelectedUser] = useState(null);
  const [filteredValue, setValue] = useState("");
  const [total_records, setTotalRecords] = useState(0);

  var search_by;
  const [success, setSuccess] = useState(false);

  let url = process.env.REACT_APP_GET_CORPORATE_LIST_FOR_CUSTOMERS;
  if (searchValue === "") {
    url =
      url +
      `&show_package_info=1&show_energy_info=1&show_business_info=1&page=${pageNumber}&limit=${perPageLimit}`;
  }
  if (searchValue !== "") {
    let pattern = /^[0-9]{8,10}$/;
    if (!pattern.test(searchValue.trim())) {
      search_by = "partner_name";
    } else {
      search_by = "phone";
    }
    url =
      url +
      `&show_package_info=1&show_energy_info=1&show_business_info=1&search_by=${search_by}&search_keyword=${searchValue.trim()}&limit=${perPageLimit}&page=${pageNumber}`;
  }

  const { isLoading, sendRequest: getusers } = useHttp();

  const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);

  useEffect(() => {
    const setSearchedusers = (searchedUsers) => {
      const { data } = searchedUsers?.data?.response;

      if (data?.partners) {
        setCorporateDetails((prev) => {
          return [...new Set([...prev, ...data?.partners])];
        });
        setTotalRecords(data?.total);
      } else {
        setCorporateDetails({});
      }
      if (data?.total == data?.partners?.length) {
        setHasMore(false);
      } else {
        setHasMore(searchedUsers.data.response.data?.partners.length > 0);
      }
    };
    if (
      pageNumber == 1 ||
      Math.ceil(parseInt(total_records) / perPageLimit) >= pageNumber
    ) {
      getusers(
        {
          url,
        },

        setSearchedusers
      );
    }

    // }
  }, [url, pageNumber, getusers]);

  const confirmUser = (user) => {
    setShowModal(true);
    setSelectedUser(user);
  };

  return (
    <div className="App">
      <CorporateListing
        corporate={corporateDetails}
        lastElementRef={lastElementRef}
        setShowModal={setShowModal}
        showModal={showModal}
        setCorporateDetails={setCorporateDetails}
        confirmUser={confirmUser}
        selectedUser={selectedUser}
        attendantStatus={filteredValue}
        success={success}
        setSuccess={setSuccess}
      />

      <div>{isLoading && pageNumber != 1 && <Loading />}</div>
      {pageNumber != "1" && pageNumber > Math.ceil(total_records / perPageLimit) && (<NoData />)}
    </div>
  );
}

export default CorporateInfo;
