import React, { useEffect } from "react";
import { Link, useNavigate } from "react-router-dom";
import { Text } from "../../UI/Text";
import Card from "../../UI/Card";
import { useState } from "react";
import PatnerProfile from "../../../utils/PartnerProfile";
import { FormatDate } from "../../../utils/FormatDate";
import Notification from "../../../utils/Notification";
import Image from "../../UI/Image";
import NotificationNew from "../../../utils/NotificationNew";
import Spinner from "../../UI/Spinner";
import DataNotFound from "../../UI/DataNotFound";
import useAuth from "../../../hooks/useAuth";
const CorporateListing = ({
  corporate,
  page,
  setCorporateDetails,
  success,
  setSuccess,
  lastElementRef,
}) => {
  const { auth } = useAuth();
  //const [partners, setPartners] = useState(partner);
  const [showMessage, setShowMessage] = useState(false);
  const [notifyData, setNotifyData] = useState();
  const [showDropDown, setShowDropDown] = useState(false);
  const [showPackageDropdown, setShowPackageDropdown] = useState(false);
  const [showDeletePopUP, setShowDeletePopUP] = useState(false);
  const [index, setIndex] = useState("");
  const [partnerStatus, setPartnerStatus] = useState("");
  const [showPopUP, setShowPopUP] = useState(false);
  const navigate = useNavigate();
  const style = {
    mainDivClass: "userInfo",
    subDivClass: "name",
  };

  // useEffect(() => {
  //   setPartners(partner);
  // }, [partner]);

  const handelPackageDropdown = (e, index) => {
    setShowPackageDropdown({ [index]: true });
  };

  const handleDeletePartner = (e, partner_id, status, i) => {
    setPartnerStatus(status);

    setIndex(i);
    setNotifyData({
      id: i,
      name:
        status === "D"
          ? "Do you want to activate"
          : "Do you want to Deactivate",
      text: "this partner customer ?",
      buttonNameYes: "Confirm",
      buttonNameNo: "Cancel",
      status: status,
      url: process.env.REACT_APP_UPDATE_PARTNER_STATUS,
      apiRequest: {
        partner_id: partner_id,
        status: status === "A" ? "D" : "A",
      },
    });
    setShowDeletePopUP(true);
    // setPackageDetails([]);
  };

  const [showSubComponent, setshowSubComponent] = useState({
    viewDetails: false,
    partner_id: "",
  });

  const subContent = (e, partnerId) => {
    setshowSubComponent({ [e.target.id]: true, partner_id: partnerId });
    setShowPopUP(true);
  };

  const handelDropDown = () => {
    setShowDropDown(true);
  };
  const onBackdropClick = (operation_status, index) => {
    if (operation_status === true) {
      const temp = [...corporate];

      temp[index]["status"] = partnerStatus == "A" ? "D" : "A";

      setCorporateDetails(temp);
    }
    document.body.classList.remove("hidden");
    setShowDeletePopUP(false);
    setShowPopUP(false);
  };

  const logo = (name) => {
    var image = "";

    image = name.substring(0, 1).toUpperCase();

    return image;
  };

  return (
    <>

      {corporate == "" ? (
        <>
          <Spinner />
        </>
      ) : Object.keys(corporate).length !== 0 ? (
        <>
          {corporate.map((partnerDetails, i) => {
            const {
              partner_name,
              partner_logo,
              partner_id,
              package_info,
              energy_info,
              business_info,
              status,
              created_at,
              customer_count,
            } = partnerDetails;

            if (corporate.length === i + 1) {
              return (
                <>
                  <div className="boxType1 mt-24" ref={lastElementRef} key={i}>
                    <section className={status === "D" ? "inactive" : "active"}>
                      <div className="head">
                        <p>
                          {partner_logo ? (
                            <>
                              <img src={partner_logo} />
                            </>
                          ) : (
                            <></>
                          )}
                        </p>
                        <div className="headindTxt">
                          <p>
                            <span>{partner_name}</span>
                          </p>

                          <span className="nextLine subHeading">{`Onboarded on ${FormatDate(
                            created_at
                          )}`}</span>
                        </div>
                        {status === "D" && (
                          <ul className="tabsList">
                            <li className="listStatus">
                              {status === "D" ? "Inactive" : ""}
                            </li>
                          </ul>
                        )}

                        <div className="actionNav">
                          <i
                            className="material-symbols-rounded mt-m grey"
                            onMouseOver={handelDropDown}
                          >
                            more_vert
                          </i>

                          {showDropDown ? (
                            <div className="dropMenuWrap">
                              <ul className="dropMenu">
                                {auth.priviliges.includes("write_partners") &&
                                  <li
                                    onClick={() => {
                                      navigate(
                                        `/customers/partner/editPartner/${partner_id}`,
                                        { state: partnerDetails }
                                      );
                                    }}
                                  >
                                    {" "}
                                    <Link to="">Edit</Link>{" "}
                                  </li>}
                                {auth.priviliges.includes("read_partners") &&
                                  <li
                                    onClick={() => {
                                      navigate(
                                        `/customers/partner/CustomerPartnerDetails/${partner_id}`,
                                        { state: partnerDetails }
                                      );
                                    }}
                                  >
                                    {" "}
                                    <Link
                                      to=""
                                      id="viewDetails"
                                      className="open_model"
                                      data-target="contactInfo"
                                    >
                                      View contact info
                                    </Link>{" "}
                                  </li>}
                                {auth.priviliges.includes("write_partners") &&(
                                 status !== "D" ? (
                                  <li>
                                    {" "}
                                    <Link
                                      to=""
                                      onClick={(e) =>
                                        handleDeletePartner(
                                          e,
                                          partner_id,
                                          status,
                                          i
                                        )
                                      }
                                      className="error"
                                    >
                                      Deactivate account
                                    </Link>{" "}
                                  </li>
                                ) : (
                                  <li>
                                    {" "}
                                    <Link
                                      to=""
                                      onClick={(e) =>
                                        handleDeletePartner(
                                          e,
                                          partner_id,
                                          status,
                                          i
                                        )
                                      }
                                      className="success"
                                    >
                                      Activate account
                                    </Link>{" "}
                                  </li>
                                ))}
                                
                               
                              </ul>
                            </div>
                          ) : (
                            <></>
                          )}
                        </div>
                      </div>

                      <div className="dataTable">
                        <div>
                          <div class="col">
                            <div class="colItem">Packages assigned</div>
                            <div class="colItem actionNavList">
                              {package_info?.package_data.length}
                              <i
                                className="material-symbols-rounded arrowBottom mt-m"
                                onMouseOver={(e) => handelPackageDropdown(e, i)}
                              >
                                expand_more
                              </i>
                              {showPackageDropdown[i] && (
                                <div class="dropMenuWrap">
                                  {package_info?.package_data.length > 0 ? (
                                    <ul
                                      class="dropMenu pText"
                                      style={{ width: "220px" }}
                                    >
                                      {package_info?.package_data.map(
                                        (packageData) => {
                                          return (
                                            <li>
                                              {packageData.maximum_battery_unit ===
                                                "10000" &&
                                                packageData.minimum_battery_unit ==
                                                0 ? (
                                                <p>
                                                  {" "}
                                                  {packageData.package_name +
                                                    " "}
                                                  (All battery types)
                                                </p>
                                              ) : packageData.maximum_battery_unit ===
                                                "10000" &&
                                                packageData.minimum_battery_unit >
                                                0 ? (
                                                <p>
                                                  {packageData.package_name +
                                                    "  "}
                                                  (
                                                  {
                                                    packageData.minimum_battery_unit
                                                  }{" "}
                                                  kWh )
                                                </p>
                                              ) : (
                                                <p>
                                                  {packageData.package_name +
                                                    " "}
                                                  (
                                                  {packageData.minimum_battery_unit !==
                                                    "0"
                                                    ? `${packageData.minimum_battery_unit} - ${packageData.maximum_battery_unit}`
                                                    : `<${packageData.maximum_battery_unit}`}
                                                  {" kWh"})
                                                </p>
                                              )}

                                              {packageData?.package_created_at && (
                                                <span>
                                                  Assigned on{" "}
                                                  {FormatDate(
                                                    packageData?.package_created_at
                                                  )}
                                                </span>
                                              )}
                                            </li>
                                          );
                                        }
                                      )}
                                    </ul>
                                  ) : (
                                    <div class="dropMenuWrap">
                                      <ul
                                        class="dropMenu pText"
                                        style={{ width: "220px" }}
                                      >
                                        <li>
                                          <p>No package found</p>
                                        </li>
                                      </ul>
                                    </div>
                                  )}
                                </div>
                              )}
                            </div>
                          </div>

                          <div className="col">
                            <div className="colItem">Customers added</div>

                            <div className="colItem">
                              {customer_count ? customer_count : 0}
                            </div>
                          </div>
                          <div className="col">
                            <div className="colItem">
                              Energy consumed till date
                            </div>
                            <div className="colItem">{`${energy_info?.energy_consumed
                              ? parseFloat(
                                energy_info?.energy_consumed
                              ).toFixed(2)
                              : 0
                              } ${energy_info?.energy_unit}`}</div>
                          </div>
                          <div className="col">
                            <div className="colItem">
                              Total revenue till date
                            </div>
                            <div className="colItem">{`$${business_info?.total_revenue
                              ? business_info?.total_revenue
                              : 0
                              }`}</div>
                          </div>
                        </div>
                      </div>
                    </section>
                  </div>
                </>
              );
            } else {
              return (
                <>
                  <div className="boxType1 mt-24" key={i}>
                    <section className={status === "D" ? "inactive" : "active"}>
                      <div className="head">
                        <p>
                          {partner_logo ? (
                            <>
                              <img src={partner_logo} />
                            </>
                          ) : (
                            <></>
                          )}
                        </p>
                        <div className="headindTxt">
                          <p>
                            <span>{partner_name}</span>
                          </p>

                          <span className="nextLine subHeading">{`Onboarded on ${FormatDate(
                            created_at
                          )}`}</span>
                        </div>
                        {status === "D" && (
                          <ul className="tabsList">
                            <li className="listStatus">
                              {status === "D" ? "Inactive" : ""}
                            </li>
                          </ul>
                        )}

                        <div className="actionNav">
                          <i
                            className="material-symbols-rounded mt-m grey"
                            onMouseOver={handelDropDown}
                          >
                            more_vert
                          </i>
                          {showDropDown ? (
                            <div className="dropMenuWrap">
                              <ul className="dropMenu">
                                {auth.priviliges.includes("write_partners") &&
                                  <li
                                    onClick={() => {
                                      navigate(
                                        `/customers/partner/editPartner/${partner_id}`,
                                        { state: partnerDetails }
                                      );
                                    }}
                                  >
                                    {" "}
                                    <Link to="">Edit</Link>{" "}
                                  </li>}
                                {auth.priviliges.includes("read_partners") &&
                                  <li
                                    onClick={() => {
                                      navigate(
                                        `/customers/partner/CustomerPartnerDetails/${partner_id}`,
                                        { state: partnerDetails }
                                      );
                                    }}
                                  >
                                    {" "}
                                    <Link
                                      to=""
                                      id="viewDetails"
                                      className="open_model"
                                      data-target="contactInfo"
                                    >
                                      View contact info
                                    </Link>{" "}
                                  </li>}
                                {auth.priviliges.includes("write_partners") &&(
                                 status !== "D" ? (
                                  <li>
                                    {" "}
                                    <Link
                                      to=""
                                      onClick={(e) =>
                                        handleDeletePartner(
                                          e,
                                          partner_id,
                                          status,
                                          i
                                        )
                                      }
                                      className="error"
                                    >
                                      Deactivate account
                                    </Link>{" "}
                                  </li>
                                ) : (
                                  <li>
                                    {" "}
                                    <Link
                                      to=""
                                      onClick={(e) =>
                                        handleDeletePartner(
                                          e,
                                          partner_id,
                                          status,
                                          i
                                        )
                                      }
                                      className="success"
                                    >
                                      Activate account
                                    </Link>{" "}
                                  </li>
                                ))}
                                
                               
                              </ul>
                            </div>
                          ) : (
                            <></>
                          )}
                        </div>
                      </div>

                      <div className="dataTable">
                        <div>
                          <div class="col">
                            <div class="colItem">Packages assigned</div>
                            <div class="colItem actionNavList">
                              {package_info?.package_data.length}
                              <i
                                className="material-symbols-rounded arrowBottom mt-m"
                                onMouseOver={(e) => handelPackageDropdown(e, i)}
                              >
                                expand_more
                              </i>
                              {showPackageDropdown[i] && (
                                <div class="dropMenuWrap">
                                  {package_info?.package_data.length > 0 ? (
                                    <ul
                                      class="dropMenu pText"
                                      style={{ width: "220px" }}
                                    >
                                      {package_info?.package_data.map(
                                        (packageData) => {
                                          return (
                                            <li>
                                              {packageData.maximum_battery_unit ===
                                                "10000" &&
                                                packageData.minimum_battery_unit ==
                                                0 ? (
                                                <p>
                                                  {" "}
                                                  {packageData.package_name +
                                                    " "}
                                                  (All battery types)
                                                </p>
                                              ) : packageData.maximum_battery_unit ===
                                                "10000" &&
                                                packageData.minimum_battery_unit >
                                                0 ? (
                                                <p>
                                                  {packageData.package_name +
                                                    "  "}
                                                  (
                                                  {
                                                    packageData.minimum_battery_unit
                                                  }{" "}
                                                  kWh )
                                                </p>
                                              ) : (
                                                <p>
                                                  {packageData.package_name +
                                                    " "}
                                                  (
                                                  {packageData.minimum_battery_unit !==
                                                    "0"
                                                    ? `${packageData.minimum_battery_unit} - ${packageData.maximum_battery_unit}`
                                                    : `<${packageData.maximum_battery_unit}`}
                                                  {" kWh"})
                                                </p>
                                              )}

                                              {packageData?.package_created_at && (
                                                <span>
                                                  Assigned on{" "}
                                                  {FormatDate(
                                                    packageData?.package_created_at
                                                  )}
                                                </span>
                                              )}
                                            </li>
                                          );
                                        }
                                      )}
                                    </ul>
                                  ) : (
                                    <div class="dropMenuWrap">
                                      <ul
                                        class="dropMenu pText"
                                        style={{ width: "220px" }}
                                      >
                                        <li>
                                          <p>No package found</p>
                                        </li>
                                      </ul>
                                    </div>
                                  )}
                                </div>
                              )}
                            </div>
                          </div>

                          <div className="col">
                            <div className="colItem">Customers added</div>

                            <div className="colItem">
                              {customer_count ? customer_count : 0}
                            </div>
                          </div>
                          <div className="col">
                            <div className="colItem">
                              Energy consumed till date
                            </div>
                            <div className="colItem">{`${energy_info?.energy_consumed
                              ? parseFloat(
                                energy_info?.energy_consumed
                              ).toFixed(2)
                              : 0
                              } ${energy_info?.energy_unit}`}</div>
                          </div>
                          <div className="col">
                            <div className="colItem">
                              Total revenue till date
                            </div>
                            <div className="colItem">{`$${business_info?.total_revenue
                              ? business_info?.total_revenue
                              : 0
                              }`}</div>
                          </div>
                        </div>
                      </div>
                    </section>
                  </div>
                </>
              );
            }
          })}

          {showDeletePopUP && (
            <Notification
              notifyData={notifyData}
              onBackdropClick={onBackdropClick}
              success={success}
              setSuccess={setSuccess}
            />
          )}

          {showSubComponent.viewDetails && showPopUP && (
            <PatnerProfile
              onBackdropClick={onBackdropClick}
              showPopUP={showPopUP}
              partner_id={showSubComponent.partner_id}
              partner={corporate}
            />
          )}
        </>
      ) : (
        <>
          <DataNotFound />
        </>
      )}
    </>
  );
};
export default CorporateListing;
