import { useState, useReducer } from "react";
import CompanyDetails from "../../Partner/CreatePartner/CompanyDetails";
import VehicleBrandDetails from "./VehicleBrandDetails";
import useAxiosIntercept from "../../../../hooks/useAxiosIntercept";
import { useNavigate } from "react-router-dom";

const formData = {
  name: "",
  employee_name: "",
  designation: "",
  phone: "",
  email: "",
  partner_logo: "",
  selectBrand: [],
};

function reducer(state, action) {
  switch (action.type) {
    case "VEHICLE":
      return {
        ...state,
        selectBrand: action.data,
      };
    case "COMPANY":
      return {
        ...state,
        name: action.data.name,
        employee_name: action.data.employee_name,
        designation: action.data.designation,
        phone: action.data.phone,
        email: action.data.email,
        partner_logo: action.data.partner_logo,
      };
    default:
      return state;
  }
}

const CreateNewCorporate = () => {
  const [page, setPage] = useState(0);
  const Titles = ["Company Details", "Vehicle Brand Details"];
  const [partnerData, dispatch] = useReducer(reducer, formData);
  const axiosPrivate = useAxiosIntercept();
  const [formDataValue, setformDataValue] = useState({
    name: "",
    employee_name: "",
    designation: "",
    phone: "",
    email: "",
    partner_logo: "",
    selectBrand: [],
  });

  const createPartnerFunc = async () => {
    let formDataMain = new FormData();
    Object.keys(partnerData).map((item) => {
      if (item === "selectBrand") {
        formDataValue[item].map((dataItem, dataIndex) => {
          formDataMain.append(`brand_id[${dataIndex}]`, dataItem);
        });
      } else {
        formDataMain.append(item, formDataValue[item]);
      }
    });
    const config = { headers: { "content-type": "multipart/form-data" } };
    const response = await axiosPrivate.post(
      process.env.REACT_APP_CREATE_CORPORATE,
      formDataMain,
      config
    );
    setformDataValue({});
  };

  const getDetails = (info, type) => {
    dispatch({ type, data: info });
  };
  const navigate = useNavigate();
  const goBack = () => {
    navigate(-1);
  };

  return (
    <>
      {/* <h2>
        <a onClick={goBack} style={{ cursor: "pointer" }}>
          <span class="material-symbols-rounded mt-l black">arrow_back</span>
        </a>
        Add new partner customer
      </h2> */}
      <div class="border radius formSection">
        <div className="formSteps pad-24">
          <ul>
            {page === 0 ? (
              <li>
                <i>{page + 1}</i>
                <a href="">{Titles[page]}</a>
              </li>
            ) : (
              <li className="previous">
                <i></i>
                <a href="">{Titles[page - 1]}</a>
              </li>
            )}
            {page === 0 ? (
              <li className="next">
                <i>{page + 2}</i>
                <a href="">{Titles[page + 1]}</a>
              </li>
            ) : (
              <li>
                <i>{page + 1}</i>
                <a href="">{Titles[page]}</a>
              </li>
            )}
            {/* <!-- <li className="next"><i>3</i><a href="javascript:void(0);">Next step</a></li> --> */}
          </ul>
        </div>
        {page === 0 ? (
          <CompanyDetails
            formDataValue={formDataValue}
            setformDataValue={setformDataValue}
            getDetails={getDetails}
            page={page}
            setPage={setPage}
          />
        ) : (
          <VehicleBrandDetails
            getDetails={getDetails}
            formDataValue={partnerData}
            setformDataValue={setformDataValue}
            page={page}
            setPage={setPage}
          />
        )}
      </div>
    </>
  );
};

export default CreateNewCorporate;
