import React, { useEffect } from "react";
import { useState } from "react";
import useAxiosIntercept from "../../../../hooks/useAxiosIntercept";
import { useLocation, useParams } from "react-router-dom";
import { useFormInputValidation } from "react-form-input-validation";
import { Link } from "react-router-dom";
import Error from "../../../UI/Error";
import Message from "../../../../utils/Message";

const EditCompanyDetails = ({
  formDataValue,
  setformDataValue,
  page,
  setPage,
  getDetails,
  dataValues,
}) => {
  const params = useParams();
  const axiosPrivate = useAxiosIntercept();
  const [counter, setCounter] = useState(0);
  const [phone, setPhone] = useState("");
  const [totalRecords, setTotalRecords] = useState("");
  const [successMsg, setSuccessMsg] = useState("");
  const [otpErrorMsg, setOtpErrorMsg] = useState("");
  const [otpSuccessMsg, setOtpSuccessMsg] = useState("");
  const [showImage, setShowImage] = useState(false);
  const [error, setError] = useState("");
  const [imageError, setImageError] = useState("");

  const [thumbnail, setThumbnail] = useState(dataValues.partner_logo);
  const [verified, setVerified] = useState(false);
  const [checkOtp, setcheckOtp] = useState(true);
  const [otp, setOtp] = useState("");
  const [partnerList, setPartnerList] = useState([]);
  const [image, setImage] = useState(dataValues.partner_logo);
  const [texterrors, setTextErrors] = useState({
    nameError: "",
    employeeNameError: "",
    designationError: "",
  });

  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getPartnerList = async () => {
      let URL = process.env.REACT_APP_GET_PARTNER_LIST_FOR_CUSTOMERS;

      try {
        const response = await axiosPrivate.get(
          URL + `&partner_id=${params.partner_id}`,
          {
            signal: controller.signal,
          }
        );
        isMounted && setPartnerList(response?.data?.response?.data?.partners);
      } catch (err) {
        setError(err);
      }
    };
    getPartnerList();
    // }

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, []);

  const controller = new AbortController();


  const [fields, errors, form] = useFormInputValidation(
    {
      partner_name: dataValues.partner_name,
      phone: dataValues.phone,
      email: dataValues.email,
    },
    {
      partner_name: "required|string",
      phone: "required|numeric|digits_between:8,10",
      email: "required|email",
    }
  );



  const handelPage = async (e) => {
    setError("");
    setOtpErrorMsg("");

    const isValid = await form.validate(e);

    if (showImage === false && thumbnail === "") {
      setImageError("Please upload image");
    }

    if ((isValid && showImage === true) || (isValid && thumbnail !== "")) {
      Object.keys(errors).forEach((i) => (errors[i] = null));
      getDetails(
        {
          partner_name: fields.partner_name,

          phone: fields.phone,
          email: fields.email,
          partner_logo: image !== "" ? image : thumbnail,
        },
        "COMPANY"
      );
      setPage(1);

    }
  };

  function handleImage(e) {
    setImage(e.target.files[0]);
    setShowImage(true);

    setThumbnail(URL.createObjectURL(e.target.files[0]));
  }

  const removeImage = () => {
    setThumbnail("");
    setImage("");
    setShowImage(false);
  };

  return (
    <form onSubmit={handelPage}>
      <div className="subContent pad-24">
        <div className="pacakgeDetails mt-16 mb-24"></div>
        <div className="dForm w300">
          <div className="fieldGroup mt-0">
            <label>Company name</label>
            <span className={errors.partner_name ? "pt-8 error" : "pt-8"}>
              <input
                type="text"
                placeholder="Enter company name"
                name="partner_name"
                onChange={form.handleChangeEvent}
                value={fields.partner_name}
                autoComplete="off"
              />
            </span>
            {fields.partner_name !== "" ||
              (errors.partner_name && <Error error={errors.partner_name} />)}
          </div>

          <div className="fieldGroup mobileVerfiy">
            <label>Mobile number</label>
            <span className="mb-12">
              <input
                type="text"
                placeholder="Enter mobile number"
                name="phone"
                onChange={form.handleChangeEvent}
                value={fields.phone}
                autoComplete="off"
                maxLength="10"
                disabled
              />
            </span>
          </div>
          <div className="fieldGroup ">
            <label>Email</label>
            <span className="pt-8">
              <input
                type="text"
                placeholder="Enter email"
                name="email"
                onChange={form.handleChangeEvent}
                value={fields.email}
                autoComplete="off"
                disabled
              />
            </span>

            {errors.email && <Error error={errors.email} />}

            {/* {errors.email && (fields.email == "" || fields.email !== "") && (
              <Error error={errors.email} />
            )} */}
          </div>
          <div className="fieldGroup wAuto">
            <label>
              Upload company logo
              <em>
                Upload guidelines: JPG or PNG format of minimum 200x200 with
                white background
              </em>
            </label>
            <div className="customFileUploader">
              {showImage || thumbnail ? (
                <>
                  <div className="csutomImgUploads">
                    <span onClick={removeImage}>
                      <i className="material-symbols-rounded white arrowBottom mt-m arrow">
                        delete
                      </i>
                      <img src={thumbnail} alt="" />
                    </span>
                  </div>
                </>
              ) : (
                <>
                  <input
                    type="file"
                    id="actual-btn"
                    name="partner_logo"
                    onChange={handleImage}

                  // onChange={(e) => setImage(e.target.files[0])}
                  // onChange={form.handleChangeEvent}
                  />
                  <label htmlFor="actual-btn">
                    <i className="material-symbols-rounded grey arrowBottom mt-l arrow">
                      add_a_photo
                    </i>
                  </label>
                </>
              )}
            </div>
            {showImage === false && imageError != "" ? (
              <>{imageError && <Error error={imageError} />}</>
            ) : (
              <></>
            )}
          </div>
          <div className="actionButtons mt-24">
            <span className="">
              <button type="submit" className="btn prim">
                {page === 0 ? "Next" : "Submit"}
              </button>
            </span>
          </div>
        </div>
      </div>
    </form>
  );
};

export default EditCompanyDetails;
