import { useState, useReducer } from "react";

import useAxiosIntercept from "../../../../hooks/useAxiosIntercept";
import { Link, useLocation, useNavigate } from "react-router-dom";
import EditCompanyDetails from "./EditCompanyDetails";
import EditVehicleBrand from "./EditVehicleBrand";

function reducer(state, action) {
  switch (action.type) {
    case "VEHICLE":
      return {
        ...state,
        selectBrand: action.data,
      };
    case "COMPANY":
      return {
        ...state,
        partner_name: action.data.partner_name,

        phone: action.data.phone,
        email: action.data.email,
        partner_logo: action.data.partner_logo,
      };
    default:
      return state;
  }
}

const EditCorporateCustomer = () => {
  const dataValues = useLocation().state;
  const formData = {
    partner_name: dataValues.partner_name,
    partner_id: dataValues.partner_id,
    phone: dataValues.phone,
    email: dataValues.email,
    partner_logo: dataValues.partner_logo,
    selectBrand: dataValues.brand_id,
  };

  const [page, setPage] = useState(0);
  const Titles = ["Company Details", "Vehicle Brand Details"];
  const [partnerData, dispatch] = useReducer(reducer, formData);
  const axiosPrivate = useAxiosIntercept();
  const [formDataValue, setformDataValue] = useState(formData);
  const navigate = useNavigate();
  const goBack = () => {
    navigate(-1);
  };
  const handelPage = () => {
    if (page == 1) {
      setPage(0);
    }
    if (page == 0) {
      goBack();
    }
  };

  const getDetails = (info, type) => {
    dispatch({ type, data: info });
  };

  return (
    <>
      <h2>
        <a onClick={goBack} style={{ cursor: "pointer" }}>
          <span class="material-symbols-rounded mt-l black">arrow_back</span>
        </a>
        Edit corporate customer
      </h2>
      <div class="border radius formSection">
        <div className="formSteps pad-24">
          <ul>
            {page === 0 ? (
              <li>
                <i>{page + 1}</i>
                <a href="">{Titles[page]}</a>
              </li>
            ) : (
              <li className="previous">
                <i></i>
                <a href="">{Titles[page - 1]}</a>
              </li>
            )}
            {page === 0 ? (
              <li className="next">
                <i>{page + 2}</i>
                <a href="">{Titles[page + 1]}</a>
              </li>
            ) : (
              <li>
                <i>{page + 1}</i>
                <a href="">{Titles[page]}</a>
              </li>
            )}
            {/* <!-- <li className="next"><i>3</i><a href="javascript:void(0);">Next step</a></li> --> */}
          </ul>
        </div>
        {page === 0 ? (
          <EditCompanyDetails
            formDataValue={formDataValue}
            setformDataValue={setformDataValue}
            getDetails={getDetails}
            page={page}
            setPage={setPage}
            dataValues={dataValues}
          />
        ) : (
          <EditVehicleBrand
            getDetails={getDetails}
            formDataValue={partnerData}
            setformDataValue={setformDataValue}
            page={page}
            setPage={setPage}
            dataValues={dataValues}
          />
        )}
      </div>
    </>
  );
};

export default EditCorporateCustomer;
