import React from "react";
import { useState } from "react";
import { Link } from "react-router-dom";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Message from "../../../utils/Message";
import Error from "../../UI/Error";
export default function CreateCustomer() {
  const axiosPrivate = useAxiosIntercept();
  const [userdata, setuserdata] = useState({
    name: "",
    email: "",
    phone: "",
  });

  const [errors, setError] = useState({
    nameError: "",
    emailError: "",
    phoneError: "",
  });
  const [isSuccess, setIsSuccess] = useState(false);
  let isValidate = true;
  const [showMessage, setShowMessage] = useState(false);
  const [message, setMessage] = useState({});
  const handleInput = (e) => {
    setError("");
    const name = e.target.name;
    const value = e.target.value;
    setuserdata({ ...userdata, [name]: value });
  };
  const submit = (e) => {
    e.preventDefault();
    const data = { ...userdata, user_type: "C" };
    const nameRegex = /^[A-Za-z\s.]*$/;
    //const nameRegex=/^[a-zA-Z0-9 !@#$%^&*)(]{2,20}$/;
    const phoneregex = /^[0-9]{8,10}$/;
    const emailRegex = /^[\w-\.]+@([\w-]+\.)+[\w-]{2,4}$/;
    data.name = data.name.trim();
    //console.log(userdata.name)
    if (data.name === "" || !nameRegex.test(data.name)) {
      isValidate = false;
      setError(() => {
        return {
          nameError: "Enter a valid name",
        };
      });
    } else if (data.phone === "" || !phoneregex.test(userdata.phone)) {
      isValidate = false;
      setError(() => {
        return {
          phoneError: "Enter a valid phone",
        };
      });
    } else if (!emailRegex.test(userdata.email) && userdata.email !== "") {
      isValidate = false;
      setError(() => {
        return {
          emailError: "Enter a valid Email",
        };
      });
    }

    if (
      (errors.phoneError === "" || errors.phoneError === undefined) &&
      (errors.nameError === "" || errors.nameError === undefined) &&
      userdata.name !== "" &&
      userdata.phone !== "" &&
      isValidate === true
    ) {
      try {
        const URL = process.env.REACT_APP_ADD_NEW_CUSTOMER;
        const res = axiosPrivate
          .post(URL, data)
          .then((res) => {
            if (res?.status === 200 && res?.data?.message === "User Created") {
              setIsSuccess(true);
              setShowMessage(true);
              setMessage({
                id: 1,
                text: res?.data?.message,
              });

              setuserdata({ name: "", email: "", user_type: "", phone: "" });
            }

            if (
              res?.data?.message === "Api Response Error" &&
              res?.status === 200
            ) {
              setIsSuccess(false);
              setShowMessage(true);

              setMessage({
                id: 2,
                text: res?.data?.response?.errors[0].message,
                name: "",
                type: "",
              });
            }
          })
          .catch((error) => { });
      } catch (err) {
        console.log(err);
      }
    }
  };

  const onBackdropClick = () => {
    setShowMessage(false);
  };
  return (
    <>
      {showMessage && (
        <Message
          message={message}
          onBackdropClick={onBackdropClick}
          errorLink="/customers/createNewCustomer"
          successLink="/customers/users"
          errorValue="Try again"
          successValue="Go Back To Customers"
          isSuccess={isSuccess}
        />
      )}
      <div className="border radius formSection">
        <div className="subContent pad-24">
          <div className="dForm w300">
            <div className="fieldGroup mt-0">
              <label>Customer Name</label>
              <span className={errors.nameError ? "pt-8 error" : "pt-8"}>
                <input
                  type="text"
                  autoComplete="off"
                  placeholder="Enter name"
                  name="name"
                  value={userdata.name}
                  onChange={handleInput}
                />
              </span>
              <Error error={errors.nameError} />

              {/* <span style={{ color: "red" }} className="errormessage">
                {errors.nameError}
              </span> */}
            </div>
            <div className="fieldGroup mobileVerfiy">
              <label>Mobile Number</label>
              <span className={errors.phoneError ? "pt-8 error" : "pt-8"}>
                <input
                  type="number"
                  required
                  autoComplete="off"
                  placeholder="Enter mobile number"
                  name="phone"
                  value={userdata.phone}
                  onChange={handleInput}
                />
              </span>
              <Error error={errors.phoneError} />
              {/* <span style={{ color: "red" }} className="errormessage">
                {errors.phoneError}
              </span> */}
            </div>

            <div className="fieldGroup email">
              <label>Email</label>
              <span className={errors.emailError ? "pt-8 error" : "pt-8"}>
                <input
                  type="email"
                  autoComplete="off"
                  placeholder="Enter email"
                  name="email"
                  value={userdata.email}
                  onChange={handleInput}
                />
              </span>
              <Error error={errors.emailError} />
              {/* <span style={{ color: "red" }}>{errors.emailError}</span> */}
            </div>
            <div className="actionButtons mt-24">
              <span class="">
                <Link to="" onClick={submit} className="btn prim">
                  Create Customer
                </Link>
              </span>
            </div>
          </div>
        </div>
      </div >
    </>
  );
}
