import React, { useState, useEffect } from "react";
import { useLocation, useParams, Link } from "react-router-dom";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import UpComingBookings from "./UpComingBookings";
import PastBookings from "./PastBookings";
import VehicleDetails from "./VehicleDetails";
import PersonalDetails from "./PersonalDetails";
import Image from "../UI/Image";
import { FormatDate } from "../../utils/FormatDate";
import Bookings from "./Bookings";
import AssignCredits from "./AssignCredits";
import { useRef } from "react";
import useOutsideClick from "../../hooks/useOutsideClick";
import DataNotFound from "../UI/DataNotFound";
import useAuth from "../../hooks/useAuth";

const CustomerDetails = () => {
  const dropDownRef = useRef();
  const params = useParams();
  const axiosPrivate = useAxiosIntercept();
  const { auth, setAuth } = useAuth();
  const [userDetails, setUserDetails] = useState("");
  const [error, setError] = useState("");
  const [reasons, setReasons] = useState("");
  const [promoAssigned, setpromoassigned] = useState(false);
  const [showSubComponent, setshowSubComponent] = useState({
    upComingBookings: true,
  });
  const [showDropDown, setshowDropDown] = useState(false);
  const [showassignPopUp, setshowassignPopUp] = useState(false);
  const handler = (e) => {
    setshowSubComponent({ [e.target.id]: true });
  };
  const onBackdropClick = () => {
    document.body.classList.remove("hidden");
    setshowassignPopUp(false);
  };
  const handelDropDown = () => {
    setshowDropDown(true);
  };

  const openpopup = async () => {
    setshowDropDown(false);
    const URL = process.env.REACT_APP_GET_CREDIT_REASONS;
    const response = await axiosPrivate.get(URL);

    if (response?.data?.status == "200") {
      setReasons(response?.data?.response?.data?.reasons);
    }
    setshowassignPopUp(true);
  };
  useOutsideClick(dropDownRef, () => {
    if (showDropDown) {
      setshowDropDown(false);
    }
  });
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getUserDetails = async () => {
      const URL =
        process.env.REACT_APP_GET_SINGLE_USER +
        "&user_type=C&show_energy_info=1&show_vehicle_count=1&show_credit_info=1&show_booking_info=1";
      try {
        const response = await axiosPrivate.get(
          URL + `&user_id=${params.user_id}`,
          {
            signal: controller.signal,
          }
        );

        if (response.data.status === 200) {
          isMounted &&
            setUserDetails(response?.data?.response?.data?.user_info);
        } else {
          setUserDetails({});
        }
      } catch (err) {}
    };
    if (isMounted) {
      getUserDetails();
    }

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, [promoAssigned]);

  const {
    user_image,
    firstname,
    lastname,
    created_at,
    credit_info,
    email,
    phone,
    energy_info,
    booking_info,
  } = userDetails;
  return (
    <>
      {showassignPopUp && (
        <AssignCredits
          onBackdropClick={onBackdropClick}
          firstname={firstname}
          lastname={lastname}
          setshowassignPopUp={setshowassignPopUp}
          reasons={reasons}
          setpromoassigned={setpromoassigned}
          promoAssigned={promoAssigned}
        />
      )}
      {userDetails === "" ? (
        <div>Fetching User Details</div>
      ) : Object.keys(userDetails).length !== 0 ? (
        <div
          className={
            showSubComponent.upComingBookings
              ? "customersDetails"
              : "boxType1 bgBox2 customersDetails"
          }
        >
          {
            <>
              <div className="userInfo big mr-0">
                <Image
                  userImage={user_image}
                  name={firstname ? firstname : "Guest"}
                  className="imgBlock"
                />
                <div className="name">
                  {firstname ? (
                    <span>{firstname + " " + lastname}</span>
                  ) : (
                    <span>Guest</span>
                  )}

                  <span>Active since: {FormatDate(created_at)}</span>
                </div>
                <div className="navTabs">
                  <ul className="level2">
                    <li>
                      <a>{`$${
                        credit_info ? credit_info?.non_cb_plus_total : ""
                      } Credits`}</a>
                    </li>
                    <li>
                      <a>0 Promos</a>
                    </li>
                  </ul>
                  </div>
                  {auth.priviliges.includes("write_credits") &&
                    <div className="actionNav wBorder ml-24">
                      <i
                        class="material-symbols-rounded mt-m grey"
                        onMouseOver={handelDropDown}
                        ref={dropDownRef}
                      >
                        more_vert
                      </i>
                      {showDropDown ? (
                        <div className="dropMenuWrap">
                          <ul className="dropMenu" style={{ width: "180px" }}>
                            {/* <li>
                          {" "}
                          <Link class="open_model" data-target="assignPromo">
                            Assign a promo
                          </Link>{" "}
                        </li> */}
                            
                            <li>
                              {" "}
                              <Link
                                class="open_model"
                                data-target=""
                                onClick={openpopup}
                              >
                                Assign credits
                              </Link>{" "}
                            </li>
                            
                        
                            {/* <li>
                          {" "}
                          <Link
                            class="error open_model"
                            data-target="assignInactive"
                          >
                            Mark as inactive
                          </Link>{" "}
                        </li> */}
                          </ul>
                        </div>
                      ) : (
                        <></>
                      )}
                    </div>}
                <div className="nextLine socialLinks">
                  <p>
                    <i className="material-symbols-rounded mt-s grey">mail</i>
                    {email == "" ? (
                      <>
                        <Link to="">N/A</Link>
                      </>
                    ) : (
                      <>
                        <Link to="">{email}</Link>
                      </>
                    )}
                  </p>
                  <p>
                    <i className="material-symbols-rounded mt-s grey">call</i>
                    {phone == "" || phone == 0 ? (
                      <>
                        <Link to="">N/A</Link>
                      </>
                    ) : (
                      <>
                        <Link to="">{phone}</Link>
                      </>
                    )}
                  </p>
                </div>
              </div>
              <div className="xRow pt-24 pb-12 dashboard">
                <div className="boxT1">
                  <p>Total bookings</p>
                  <span>
                    {booking_info?.total_count
                      ? booking_info?.total_count
                      : "0"}
                  </span>
                </div>
                <div className="boxT1">
                  <p>Energy used till date</p>
                  <span>{energy_info?.total_energy_consummed} kWH</span>
                </div>
              </div>
              <div className="navTabs mt-24 mb-24">
                <ul className="level1">
                  <li
                    className={
                      showSubComponent.upComingBookings ? "selected" : ""
                    }
                  >
                    <Link id="upComingBookings" onClick={handler}>
                      Upcoming bookings
                    </Link>
                  </li>
                  <li
                    className={showSubComponent.pastBookings ? "selected" : ""}
                  >
                    <Link id="pastBookings" onClick={handler}>
                      Past bookings
                    </Link>
                  </li>
                  <li
                    className={
                      showSubComponent.vehicleDetails ? "selected" : ""
                    }
                  >
                    <Link id="vehicleDetails" onClick={handler}>
                      Vehicle details
                    </Link>
                  </li>
                  <li
                    className={
                      showSubComponent.personalDetails ? "selected" : ""
                    }
                  >
                    <Link id="personalDetails" onClick={handler}>
                      Personal details
                    </Link>
                  </li>
                </ul>
              </div>
         
              {showSubComponent.upComingBookings && (
                <Bookings
                  firstname={firstname}
                  lastname={lastname}
                  userImage={user_image}
                  Bookingtype="upComingBookings"
                />
              )}
              {showSubComponent.pastBookings && (
                <Bookings Bookingtype="pastBookings" />
              )}
              {showSubComponent.vehicleDetails && (
                <VehicleDetails firstname={firstname} lastname={lastname} />
              )}
              {showSubComponent.personalDetails && <PersonalDetails />}
            </>
          }
        </div>
      ) : (
        <>
          <DataNotFound/>
        </>
      )}
    </>
  );
};

export default CustomerDetails;
