import { useState, useEffect } from "react";

import usePaginate from "../../hooks/usePaginate";
import useHttp from "../../hooks/useHttp";
import CustomerListing from "./CustomerListing";
import NoData from "../UI/NoData";
import Loading from "../UI/Loading";

const perPageLimit = 10;

function CustomerInfoNew({
  searchValue,
  setSearchValue,
  pageNumber,
  setPageNumber,
  users,
  setUsers,
}) {
  const [searchText, setSearchText] = useState("");

  const [hasMore, setHasMore] = useState(false);
  const [showModal, setShowModal] = useState(false);
  const [selectedUser, setSelectedUser] = useState(null);
  const [filteredValue, setValue] = useState("");
  const [total_records, setTotalRecords] = useState(0);
  var search_by;
  let url = process.env.REACT_APP_USER_INFO_URL;

  if (searchValue === "") {
    url = url + `&page=${pageNumber}&limit=${perPageLimit}`;
  }

  if (searchValue !== "") {
    let pattern = /^[0-9]{8,10}$/;
    if (!pattern.test(searchValue.trim())) {
      search_by = "name";
    } else {
      search_by = "phone";
    }
    url =
      url +
      `&search_by=${search_by}&search_keyword=${searchValue.trim()}&limit=${perPageLimit}&page=${pageNumber}`;
  }

  const { isLoading, sendRequest: getusers } = useHttp();

  const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);

  useEffect(() => {
    const setSearchedusers = (searchedUsers) => {
      const { data } = searchedUsers?.data?.response;
      if (data?.user_info && data?.user_info.length > 0) {
        setUsers((prev) => {
          return [...new Set([...prev, ...data?.user_info])];
        });
        setTotalRecords(data?.total_records);
      } else {
        setUsers({});
      }

      if (data?.total_records == data?.user_info?.length) {
        setHasMore(false);
      } else {
        setHasMore(searchedUsers.data.response.data?.user_info.length > 0);
      }
    };
    if (
      pageNumber == 1 ||
      Math.ceil(parseInt(total_records) / perPageLimit) >= pageNumber
    ) {
      getusers(
        {
          url,
        },
        setSearchedusers
      );
    }
  }, [url, pageNumber, getusers]);

  const confirmUser = (user) => {
    setShowModal(true);
    setSelectedUser(user);
  };

  const updateUserStatus = (user) => {
    setTimeout(() => {
      const usersToUpdate = [...users];
      const userIndex = usersToUpdate.indexOf(selectedUser);
      usersToUpdate.splice(userIndex, 1);
      setUsers(usersToUpdate);
      setShowModal(false);
    }, 1000);
  };

  return (
    <div className="App">
      <CustomerListing
        users={users}
        lastElementRef={lastElementRef}
        setShowModal={setShowModal}
        showModal={showModal}
        updateUserStatus={updateUserStatus}
        confirmUser={confirmUser}
        selectedUser={selectedUser}
        attendantStatus={filteredValue}
      />

      <div>{isLoading && pageNumber != 1 && <Loading />}</div>
      {pageNumber != "1" && pageNumber > Math.ceil(total_records / perPageLimit) && (<NoData />)}
    </div>
  );
}

export default CustomerInfoNew;
