import React from "react";
import { useNavigate } from "react-router-dom";
import Image from "../UI/Image";
import { FormatDate } from "../../utils/FormatDate";
import { Text } from "../UI/Text";
import Spinner from "../UI/Spinner";
import Card from "../UI/Card";
import { DataF } from "@react-google-maps/api";
import DataNotFound from "../UI/DataNotFound";
const CustomerListing = ({ users, setSearchValue, lastElementRef }) => {
  const navigate = useNavigate();
  const style = {
    mainDivClass: "userInfo",
    subDivClass: "name",
  };

  return (
    <>
      {users == "" ? (
        <Spinner />
      ) : Object.keys(users).length !== 0 ? (
        <div className="customersList">
          {users.map((user, i) => {
            if (users.length === i + 1) {
              return (
                <div
                  ref={lastElementRef}
                  key={i}
                  className="infoEntry"
                  onClick={() => {
                    navigate(
                      `/customers/users/customerProfile/${user?.user_id}`
                    );
                  }}
                >
                  <Card
                    userImage={user.user_image}
                    userFirstName={user.firstname}
                    userLastName={user.lastname}
                    createdDate={user.created_at}
                    className={style}
                  />

                  {Text("Email", user?.email)}
                  {Text("Phone", user?.phone)}

                  <div className="userInfo">
                    <div className="vehiclesType">
                      <span>Vehicles</span>
                      <span>{user?.vehicle_count}</span>
                    </div>
                  </div>
                  <div className="moreInfoBtn">
                    <i
                      className="material-symbols-rounded arrowRight mt-l"
                      style={{ cursor: "pointer" }}
                    >
                      expand_more
                    </i>
                  </div>
                </div>
              );
            } else {
              return (
                <div
                  key={i}
                  className="infoEntry"
                  onClick={() => {
                    navigate(
                      `/customers/users/customerProfile/${user?.user_id}`
                    );
                  }}
                >
                  <Card
                    userImage={user.user_image}
                    userFirstName={user.firstname}
                    userLastName={user.lastname}
                    createdDate={user.created_at}
                    className={style}
                  />

                  {Text("Email", user?.email)}
                  {Text("Phone", user?.phone)}

                  <div className="userInfo">
                    <div className="vehiclesType">
                      <span>Vehicles</span>
                      <span>{user?.vehicle_count}</span>
                    </div>
                  </div>
                  <div className="moreInfoBtn">
                    <i
                      className="material-symbols-rounded arrowRight mt-l"
                      style={{ cursor: "pointer" }}
                    >
                      expand_more
                    </i>
                  </div>
                </div>
              );
            }
          })}
        </div>
      ) : (
        <DataNotFound/>
      )}
    </>
  );
};
export default CustomerListing;
