import React from "react";
import { useState } from "react";
import { FormatDate } from "../../utils/FormatDate";
import EditBookingPopUp from "./EditBookingPopUp";
import useAuth from "../../hooks/useAuth";

const CustomerPlanData = ({
  id,
  planData,
  isLoading,
  firstname,
  lastname,
  setSuccess,
  success,
  setUserVehicleDetails,
  userVehicleDetails,
}) => {
  const { auth } = useAuth();
  const [showEditPopUp, setShowEditPopUp] = useState(false);
  const [editPlanInfo, setEditPlanInfo] = useState({});
  const handelEdit = (info) => {
    setShowEditPopUp(true);
    setEditPlanInfo(info);
  };
  const onBackdropClick = (operation_status) => {
    // if (operation_status === true) {
    //   deletePuppyFromListing(serviceId);
    // }
    document.body.classList.remove("hidden");
    setShowEditPopUp(false);
    // setOpenAddPuppyForm(false);

    //setShowDeletePopUP(false);
  };

  return (
    <div className="yRow gap16">
      {planData[id].package_info &&
        planData[id].package_info.length > 0 &&
        planData[id].package_info.map((planinfo) => {
          return (
            <div className="boxT1 userActivePlan">
              {planinfo?.package_id != null ? (
                <>
                  <div className="headWrap">
                    <p>
                      {planinfo.package_group == "normal"
                        ? "Active plan"
                        : "Recovery insurance"}
                    </p>
                    {auth.priviliges.includes("write_bookings") && (
                      <div
                        href="javascript:void(0);"
                        class="actionNav wBorder ml-24"
                      >
                        <i class="material-symbols-rounded mt-m grey">
                          more_vert
                        </i>
                        <div class="dropMenuWrap">
                          <ul
                            class="dropMenu"
                            style={{ width: "180px" }}
                            onClick={() => handelEdit(planinfo)}
                          >
                            <li>
                              {" "}
                              <a
                                href="javascript:void(0);"
                                class="open_model"
                                data-target="editbookingP"
                              >
                                Edit bookings
                              </a>{" "}
                            </li>
                          </ul>
                        </div>
                      </div>
                    )}
                  </div>

                  <div className="xRow">
                    <span>{planinfo.package_name}</span>
                    <ul className="tabsList">
                      <li>{`${planinfo.booking_left}/${planinfo.maximum_booking_allowed} booking left`}</li>
                    </ul>
                  </div>

                  {planinfo.package_auto_renew == 1 ? (
                    planinfo.package_expire_on && (
                      <div className="xRow smallTxt">
                        Auto renew on {FormatDate(planinfo.package_expire_on)}
                      </div>
                    )
                  ) : (
                    <div className="xRow smallTxt">
                      Package expires on{" "}
                      {FormatDate(planinfo.package_expire_on)}
                    </div>
                  )}

                  {/* <a href="">View plan history</a> */}
                </>
              ) : (
                <>
                  {isLoading && planData[id].package_info ? (
                    <>
                      <p>Loading...</p>
                    </>
                  ) : (
                    <>
                      <p>No Active plan</p>
                    </>
                  )}
                </>
              )}

              {showEditPopUp && (
                <EditBookingPopUp
                  onBackdropClick={onBackdropClick}
                  id={id}
                  planData={planData}
                  firstname={firstname}
                  lastname={lastname}
                  success={success}
                  setSuccess={setSuccess}
                  userVehicleDetails={userVehicleDetails}
                  setUserVehicleDetails={setUserVehicleDetails}
                  editPlanInfo={editPlanInfo}
                />
              )}
            </div>
          );
        })}
    </div>
  );
};

export default CustomerPlanData;
