import React, { useState, useRef } from "react";
import Overlay from "../../utils/Overlay";
import useOutsideClick from "../../hooks/useOutsideClick";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import { ISO_8601 } from "moment";
import Error from "../UI/Error";
import Success from "../UI/Success";
const EditBookingPopUp = ({
  onBackdropClick,
  id,
  planData,
  firstname,
  lastname,
  success,
  setSuccess,
  userVehicleDetails,
  setUserVehicleDetails,
  editPlanInfo,
}) => {
  const [serviceHighlights, setServiceHighlights] = useState([]);
  const axiosPrivate = useAxiosIntercept();
  const [successMessage, setSuccessMessage] = useState("");
  const [bookingValue, setBookingValue] = useState("");
  const [showAllowedBookings, setShowAllowedBookings] = useState({
    editBookings: false,
  });
  const bookingleft = editPlanInfo.booking_left;
  const bookingAllowed = editPlanInfo.maximum_booking_allowed;
  var bookingArray = new Array(bookingAllowed);

  const bookingRef = useRef();
  const handelEditBookings = (e, id) => {
    setBookingValue(id);
    setShowAllowedBookings({
      editBookings: false,
    });
  };
  useOutsideClick(bookingRef, () => {
    setShowAllowedBookings({
      editBookings: false,
    });
  });

  const [errorMessage, setErrorMessage] = useState("");

  const submit = async (e) => {
    e.preventDefault();

    const editBookingLeftValueRequest = {
      customer_user_id: editPlanInfo.user_id,
      user_package_id: editPlanInfo.user_package_id,
      booking_left: bookingValue ? bookingValue : bookingleft,
    };
    if (bookingValue !== "" || bookingleft !== "") {
      const editBookingLeftValueUrl = process.env.REACT_APP_EDIT_BOOKINGS;
      const editBookingLeftValueResponse = await axiosPrivate.post(
        editBookingLeftValueUrl,
        editBookingLeftValueRequest
      );

      if (editBookingLeftValueResponse?.data?.status === 200) {
        setErrorMessage("");
        setSuccessMessage(editBookingLeftValueResponse?.data?.message);
        const temp = [...userVehicleDetails];
        const packageInfo = temp[id]["package_info"];
        packageInfo.map((packageinfo, index) => {
          packageinfo.package_group == editPlanInfo.package_group &&
            (packageInfo[index]["booking_left"] = bookingValue
              ? bookingValue
              : bookingleft);
        });

        setUserVehicleDetails(temp);
        setTimeout(() => {
          onBackdropClick(true);
          setSuccess(!success);
        }, 3000);
      } else {
        setSuccessMessage("");
        setSuccessMessage("");
        setErrorMessage(editBookingLeftValueResponse?.data?.message);
      }
    } else {
      setSuccessMessage("");
      setErrorMessage("");
      setErrorMessage("Please select booking value");
    }
  };
  const handelClose = () => {
    onBackdropClick();
  };
  const handeldropDown = (e) => {
    setShowAllowedBookings({
      [e.currentTarget.id]: !showAllowedBookings[e.currentTarget.id],
    });
  };
  return (
    <Overlay>
      <form>
        <div
          class="model_box_child editbookingP"
          id="editbookingP"
          style={{ width: "400px" }}
        >
          <div class="ap_heading">
            <h4>
              Edit booking
              <span
                class="material-symbols-rounded black close_model"
                onClick={handelClose}
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection">
            <section class="assignPromoP dForm">
              <div class="promoText customer">
                <div>
                  <p>Customer name</p>
                  <em>{firstname ? firstname + " " + lastname : "Guest"}</em>
                </div>
                <div>
                  <p>Active plan</p>
                  <em>
                    {editPlanInfo.package_name}
                    <ul class="tabsList pad-0">
                      <li>{`${editPlanInfo.booking_left}/${editPlanInfo.maximum_booking_allowed} booking left`}</li>
                    </ul>
                  </em>
                </div>
              </div>
              <div class="fieldGroup">
                <label>Add/remove booking</label>
                <div
                  ref={bookingRef}
                  class="multiOption"
                  id="editBookings"
                  onClick={(e) => handeldropDown(e)}
                >
                  <div
                    class={
                      showAllowedBookings.editBookings
                        ? "selectBox open fullWidth"
                        : "selectBox fullWidth"
                    }
                  >
                    <p>
                      {bookingValue ? bookingValue : bookingleft} bookings
                      <i class="material-symbols-rounded grey">expand_more</i>
                    </p>
                    <div class="selectDrop customScroll hFix">
                      <ul class="dropMenu">
                        {bookingAllowed &&
                          Array.apply(
                            null,
                            Array(parseInt(bookingAllowed))
                          ).map(function (x, i) {
                            return (
                              <li
                                class={bookingValue === i + 1 ? "selected" : ""}
                              >
                                <a
                                  href="javascript:void(0);"
                                  id={i + 1}
                                  onClick={(e) => handelEditBookings(e, i + 1)}
                                >
                                  {i + 1}
                                  {bookingValue === i + 1 ? (
                                    <i class="material-symbols-rounded">done</i>
                                  ) : (
                                    ""
                                  )}
                                </a>
                              </li>
                            );
                          })}
                      </ul>
                    </div>
                  </div>
                </div>
              </div>

              <div class="fieldGroup">
                <label>Remarks</label>
                <span>
                  <textarea
                    type="text"
                    placeholder="Enter any remarks"
                    name=""
                  ></textarea>
                </span>
              </div>
            </section>
            <div class="actionButtons mt-24">
              <span>
                <a
                  href="javascript:void(0);"
                  class="btn prim fullW"
                  onClick={submit}
                >
                  Update bookings
                </a>
              </span>
            </div>
            {successMessage && <Success success={successMessage} />}
            {errorMessage && <Error error={errorMessage} />}
          </div>
        </div>
      </form>
    </Overlay>
  );
};
export default EditBookingPopUp;
