import React, { useState } from 'react'
import SidePopUp from '../../utils/SidePopUp'
import { Time } from '../../utils/Time'
export default function FindingsPopUp({ closefindDatapopup, vehicle_registration_no, vehicle_brand, vehicle_model, package_name, findings, variant_image, openImage, setOpenImage, imageData, setimageData }) {
    return (
        <>
            <SidePopUp onBackdropClick={closefindDatapopup} >
                <div class="model_box_child cHistoryP aFindingsP" id="aFindingsP" style={{ "width": "392px" }}>
                    <div class="fixHead" style={{ borderBottom: "#eee solid 1px", display: "flex", zIndex: "2", padding: "8px 12px", height: "64px", width: "webkit-fill-available", marginRight: "8px", paddingLeft: "24px" }}>
                        <h4>
                            <span onClick={closefindDatapopup} style={{ marginRight: "8px", cursor: "pointer" }} class="material-symbols-rounded black close_model lPosition">close</span>
                            Findings in the car
                        </h4>
                    </div>
                    <div class="contentSection" style={{ paddingTop: "24px" }}>
                        <section>
                            <div class="cVehicleInfo">
                                <div class="vPackage">
                                    <p>
                                        {vehicle_registration_no}
                                        <span>{package_name}</span>
                                    </p>
                                    <p class="vName">{vehicle_brand}-{vehicle_model}</p>
                                </div>
                                <div class="vImg">
                                    <img src={variant_image} alt="" />
                                </div>
                            </div>
                        </section>
                        {findings && findings?.length > 0 ? (<></>) : ""}
                        <section>
                            <div class="aFnLists mt-16">
                                {findings && findings.length > 0 ? (<>
                                    {findings.map((finding, index) => {
                                        return (
                                            <div>

                                                <p>{finding?.note}</p>
                                                <em>{Time(finding.uploading_time)}</em>
                                                {finding.image && <div class="imgPick">
                                                    <img src={finding.image} alt="" onClick={() => {
                                                        const temp = findings.map((findingnew, index2) => {
                                                            return {
                                                                image: findingnew.image,
                                                                note: findingnew.note,
                                                                time: Time(finding.uploading_time)

                                                            }
                                                        })
                                                        setOpenImage(true);
                                                        closefindDatapopup();
                                                        setimageData({
                                                            heading: "Findings in the car",
                                                            subheading: finding?.note,
                                                            time: Time(finding.uploading_time),
                                                            image: finding.image,
                                                            outerClass: "model_box_child aFindingsPGalleryP",
                                                            total: findings.length,
                                                            index: index,
                                                            findingsdata: temp,
                                                            outerId: "aFindingsPGalleryP"

                                                        })
                                                    }} />

                                                </div>}

                                            </div>
                                        )


                                    })}
                                </>) : "Nothing Was Found"}


                            </div>
                        </section>
                    </div>
                </div>

            </SidePopUp>




        </>
    )
}
