import React from "react";
import SidePopUp from "../../utils/SidePopUp";
import JobDetailsDescription from "./JobDetailsDescription";
export default function JobDetails({
  closeJobDetails,
  jobData,
  vehicle_registration_no,
  package_name,
  vehicle_brand,
  vehicle_model,
  variant_image,
  jobHistory,
  openImage,
  setOpenImage,
  imageData,
  setimageData,
  booking_type,
}) {
  return (
    <>
      <SidePopUp onBackdropClick={closeJobDetails}>
        <div
          class="model_box_child cHistoryP servicesDetailsP"
          id="servicesDetailsP"
          style={{ width: "392px" }}
        >
          <div
            class="fixHead"
            style={{
              borderBottom: "#eee solid 1px",
              display: "flex",
              zIndex: "2",
              padding: "8px 12px",
              height: "64px",
              width: "webkit-fill-available",
              marginRight: "8px",
              paddingLeft: "24px",
            }}
          >
            <h4>
              <span
                class="material-symbols-rounded black close_model lPosition"
                style={{ marginRight: "8px" }}
                onClick={closeJobDetails}
              >
                close
              </span>{" "}
              View job details
            </h4>
          </div>
          <div class="contentSection" style={{ paddingTop: "24px" }}>
            <section>
              <div class="cVehicleInfo">
                <div class="vPackage">
                  <p>
                    {vehicle_registration_no}
                    <span>{package_name}</span>
                  </p>
                  <p class="vName">
                    {vehicle_brand}-{vehicle_model}
                  </p>
                </div>
                <div class="vImg">
                  <img src={variant_image} alt="" />
                </div>
              </div>
            </section>
            <section>
              <JobDetailsDescription
                closeJobDetails={closeJobDetails}
                jobData={jobData}
                jobHistory={jobHistory}
                openImage={openImage}
                setOpenImage={setOpenImage}
                imageData={imageData}
                setimageData={setimageData}
                booking_type={booking_type}
              />
            </section>
          </div>
        </div>
      </SidePopUp>
    </>
  );
}
