import React from "react";
import { useState } from "react";
import moment from "moment";
import { jobTabsLabel } from "../../configuration/TabsConfig";
export default function JobDetailsDescription({
  closeJobDetails,
  jobData,
  jobHistory,
  openImage,
  setOpenImage,
  imageData,
  setimageData,
  booking_type,
}) {
  const [toggle, setToggle] = useState({});
  let servicestartTime = "";
  let service_end_time = "";
  const handleExpand = (e) => {
    setToggle({ [e.target.id]: !toggle[e.target.id] });
  };
  return (
    <>
      <div class="listDetail mt-16">
        <ul>
          {jobData &&
            jobData.length > 0 &&
            jobData.map((data, i) => {
              return (
                <>
                  {!toggle[i] && (
                    <li>
                      <a>
                        <p>
                          {booking_type == "normal" && (
                            <>
                              <i class="material-symbols-rounded mt-m grey">
                                {data.icon_tag}
                              </i>
                            </>
                          )}
                          <span>
                            <span>{data.service_name}</span>{" "}
                            <span
                              class={
                                data?.service_status == "5"
                                  ? "statusU completed"
                                  : "stat"
                              }
                            >
                              {data?.service_status == "5" && (
                                <i class="material-symbols-rounded mt-s grey fill">
                                  check_circle
                                </i>
                              )}
                              {data.service_status == "2"
                                ? "Inprogress"
                                : data.service_status_description}
                            </span>
                          </span>

                          {toggle[i] ? (
                            <>
                              <i
                                id={i}
                                class="material-symbols-rounded grey arrowTop mt-m arrow"
                                onClick={handleExpand}
                              >
                                expand_more
                              </i>
                            </>
                          ) : (
                            <>
                              <i
                                id={i}
                                class="material-symbols-rounded grey arrowBottom mt-m arrow"
                                onClick={handleExpand}
                              >
                                expand_more
                              </i>
                            </>
                          )}
                        </p>
                      </a>
                    </li>
                  )}

                  {toggle[i] ? (
                    <>
                      <li class="active">
                        <a>
                          <p>
                            {booking_type == "nomal" && (
                              <i class="material-symbols-rounded mt-m grey">
                                {data.icon_tag}
                              </i>
                            )}
                            <span>
                              <span>{data.service_name}</span>
                              <span
                                class={
                                  data?.service_status_description === "Done"
                                    ? "statusU completed"
                                    : "stat"
                                }
                              >
                                {data.service_status_description == "Done" && (
                                  <i class="material-symbols-rounded mt-s grey fill">
                                    check_circle
                                  </i>
                                )}
                                <span>
                                  {data.service_status == "2"
                                    ? "Inprogress"
                                    : data.service_status_description}
                                </span>
                              </span>
                            </span>
                            {data?.service_status != "6" && (
                              <i
                                onClick={handleExpand}
                                class="material-symbols-rounded grey arrowTop mt-m arrow"
                              >
                                expand_more
                              </i>
                            )}
                          </p>
                        </a>
                        {data?.service_status != "6" && (
                          <div class="cHistory">
                            {jobHistory &&
                              jobHistory?.length > 0 &&
                              jobHistory.map((history, index) => {
                                servicestartTime = new Date(
                                  history?.activity_log[0]?.created_on
                                );
                                service_end_time = new Date(
                                  history?.activity_log[1]?.created_on
                                );
                                servicestartTime =
                                  moment(servicestartTime).format("HH:mm:A");
                                service_end_time =
                                  moment(service_end_time).format("HH:mm:A");
                                if (history?.service_id == data?.service_id) {
                                  return (
                                    <>
                                      <div
                                        class={
                                          data.service_status == "1"
                                            ? "disabled"
                                            : ""
                                        }
                                      >
                                        <i class="material-symbols-rounded mt-l grey fill play">
                                          play_circle
                                        </i>
                                        <p>
                                          <span>Started</span>
                                          <span>
                                            {data.service_status == "1"
                                              ? "--"
                                              : servicestartTime}
                                          </span>
                                        </p>
                                        {data.service_status == "1" ? (
                                          ""
                                        ) : history?.activity_log[0]
                                            ?.service_image ? (
                                          <>
                                            <div class="imgPick">
                                              <img
                                                src={
                                                  history?.activity_log[0]
                                                    ?.service_image
                                                }
                                                alt=""
                                                onClick={() => {
                                                  const temp =
                                                    history?.activity_log.map(
                                                      (activitylog, index2) => {
                                                        return {
                                                          label:
                                                            jobTabsLabel[
                                                              activitylog
                                                                ?.service_status
                                                            ],
                                                          id: jobTabsLabel[
                                                            activitylog
                                                              ?.service_status
                                                          ],
                                                          image:
                                                            activitylog?.service_image,
                                                        };
                                                      }
                                                    );

                                                  setOpenImage(true);
                                                  closeJobDetails();
                                                  setimageData({
                                                    heading:
                                                      data.service_name +
                                                      " " +
                                                      "photos",
                                                    subheading: "",
                                                    time: "",
                                                    outerClass:
                                                      "model_box_child servicesDetailsGalleryP",
                                                    image:
                                                      history?.activity_log[0]
                                                        ?.service_image,
                                                    tabs: temp,
                                                    currentTab:
                                                      jobTabsLabel[
                                                        history?.activity_log[0]
                                                          ?.service_status
                                                      ],
                                                    index: 0,
                                                    total:
                                                      history?.activity_log
                                                        ?.length,
                                                  });
                                                }}
                                              />
                                            </div>
                                          </>
                                        ) : (
                                          ""
                                        )}
                                      </div>
                                      <div
                                        className={
                                          data.service_status == "1" ||
                                          data.service_status == "2"
                                            ? "disabled"
                                            : ""
                                        }
                                      >
                                        <i class="material-symbols-rounded mt-l grey fill pause">
                                          check_circle
                                        </i>
                                        <p>
                                          <span>Done</span>
                                          <span>
                                            {data.service_status == "1" ||
                                            data.service_status == "2"
                                              ? "--"
                                              : service_end_time}
                                          </span>
                                        </p>
                                        {data.service_status == "1" ||
                                        data.service_status == "2" ? (
                                          ""
                                        ) : history?.activity_log[1]
                                            ?.service_image ? (
                                          <div class="imgPick">
                                            <img
                                              src={
                                                history?.activity_log[1]
                                                  ?.service_image
                                              }
                                              alt=""
                                              onClick={() => {
                                                const temp =
                                                  history?.activity_log.map(
                                                    (activitylog, index3) => {
                                                      return {
                                                        label:
                                                          jobTabsLabel[
                                                            activitylog
                                                              ?.service_status
                                                          ],
                                                        id: jobTabsLabel[
                                                          activitylog
                                                            ?.service_status
                                                        ],
                                                        image:
                                                          activitylog?.service_image,
                                                      };
                                                    }
                                                  );

                                                setOpenImage(true);
                                                closeJobDetails();
                                                setimageData({
                                                  heading:
                                                    data.service_name +
                                                    " " +
                                                    "photos",
                                                  subheading: "",
                                                  time: "",
                                                  outerClass:
                                                    "model_box_child servicesDetailsGalleryP",
                                                  image:
                                                    history?.activity_log[1]
                                                      ?.service_image,
                                                  tabs: temp,
                                                  currentTab:
                                                    jobTabsLabel[
                                                      history?.activity_log[1]
                                                        ?.service_status
                                                    ],
                                                  index: 1,
                                                  total:
                                                    history?.activity_log
                                                      ?.length,
                                                  outerId:
                                                    "servicesDetailsGalleryP",
                                                });
                                              }}
                                            />
                                          </div>
                                        ) : (
                                          ""
                                        )}
                                      </div>
                                    </>
                                  );
                                }
                              })}
                            {data?.service_status == "1" && (
                              <>
                                <div
                                  class={
                                    data.service_status == "1" ? "disabled" : ""
                                  }
                                >
                                  <i class="material-symbols-rounded mt-l grey fill play">
                                    play_circle
                                  </i>
                                  <p>
                                    <span>Started</span>
                                    <span>
                                      {data.service_status == "1"
                                        ? "--"
                                        : servicestartTime}
                                    </span>
                                  </p>
                                  {data.service_status == "1" ? (
                                    ""
                                  ) : (
                                    <div class="imgPick">
                                      <img src="" alt="" />
                                    </div>
                                  )}
                                </div>
                                <div
                                  className={
                                    data.service_status == "1" ||
                                    data.service_status == "2"
                                      ? "disabled"
                                      : ""
                                  }
                                >
                                  <i class="material-symbols-rounded mt-l grey fill pause">
                                    check_circle
                                  </i>
                                  <p>
                                    <span>Done</span>
                                    <span>
                                      {data.service_status == "1" ||
                                      data.service_status == "2"
                                        ? "--"
                                        : service_end_time}
                                    </span>
                                  </p>
                                  {data.service_status == "1" ||
                                  data.service_status == "2" ? (
                                    ""
                                  ) : (
                                    <div class="imgPick">
                                      <img src="" alt="" />
                                    </div>
                                  )}
                                </div>
                              </>
                            )}
                          </div>
                        )}
                      </li>
                    </>
                  ) : (
                    <></>
                  )}
                </>
              );
            })}
        </ul>
      </div>
    </>
  );
}
