import React from 'react'
import { useState } from 'react'
import useAxiosIntercept from '../../hooks/useAxiosIntercept'
import Overlay from '../../utils/Overlay'
import { Time } from "../../utils/Time"
import { FormatDate } from '../../utils/FormatDate'
import Error from '../UI/Error'
import Success from '../UI/Success'
export default function MarkPaymentDone({ setpaymentDonepopUp, booking_id, booking_slot, user_firstname, user_lastname, user_vehicle_no, driver_firstname, driver_lastname, driver_vehicle_no, isPaymentDone, setisPaymentDone, index, pastBookingData, setBookingsDetails }) {

    const axiosPrivate = useAxiosIntercept();
    const [utrNumber, setutrNumber] = useState("");
    const [errors, setErrors] = useState("");
    const [successMessage, setsuccessMessage] = useState("");
    const close = () => {
        setpaymentDonepopUp(false);
        document.body.classList.remove("hidden");

    }
    let isValidate = false;
    const validations = () => {
        const regex = /^[A-Za-z0-9]*$/;
        if (utrNumber == "" || !regex.test(utrNumber)) {
            setErrors("Enter a valid UTR number");
            isValidate = false;

        }
        else {
            isValidate = true

        }


    }
    const submit = async () => {
        validations();
        if (isValidate) {
            const request = {
                booking_id: booking_id,
                extra_data: {
                    utr: utrNumber

                }
            }
            const URL = process.env.REACT_APP_MARK_PAYMENT_DONE;
            const response = await axiosPrivate.post(URL, request);

            if (response?.data?.status == "200") {
                //  setisPaymentDone(!isPaymentDone)

                setsuccessMessage(response?.data?.message);
                setTimeout(() => {
                    const temp_data = pastBookingData;

                    temp_data[index].booking_info.order_status = "P";
                    setBookingsDetails(temp_data);

                    close();

                }, 3000);

                // setisPaymentDone(!isPaymentDone)
            }
            else {
                setErrors(response?.data?.message)
            }


        }


    }
    let userName = ""
    userName = user_firstname ? userName + " " + user_firstname : "";
    userName = user_lastname ? userName + " " + user_lastname : userName;
    const date = booking_slot
        ? FormatDate(booking_slot).split(",")
        : "";
    const time =
        booking_slot &&
        Time(booking_slot);
    let driverName = ""
    driverName = driver_firstname ? driverName + " " + driver_firstname : "";
    driverName = driver_lastname ? driverName + " " + driver_lastname : driverName;
    return (
        <>

            <Overlay>
                <div class="model_box_child cancelBookingP paymentDoneP" id="paymentDoneP" style={{ width: "400px" }}>
                    <div class="ap_heading">
                        <h4>Mark payment as done<span class="material-symbols-rounded black close_model" onClick={close}>close</span></h4>
                    </div>
                    <div class="contentSection">
                        <section class="assignPromoP dForm">
                            <div class="boxT1 fill">
                                <h4><span>{date[0]}</span><i class="elip"></i><span>{time}</span></h4>
                                <p>
                                    <i class="material-symbols-rounded mt-m grey">person</i>
                                    <span>{userName}</span>
                                    <i class="elip"></i>
                                    <em>{user_vehicle_no}</em>
                                </p>
                                <p class="assignName">
                                    <i class="material-symbols-rounded mt-m">airport_shuttle</i>
                                    <span>{driverName}</span>
                                    <i class="elip"></i>
                                    <em>{driver_vehicle_no}</em>
                                </p>
                            </div>
                            <div class="fieldGroup">
                                <label>UTR number</label>
                                <span>
                                    <input type="text" placeholder="Enter UTR number" name="" value={utrNumber} onChange={(e) => { setutrNumber(e.target.value); setErrors("") }} />
                                </span>
                            </div>
                        </section>
                        <div class="actionButtons mt-24">
                            <span>
                                <a class="btn prim" onClick={submit}>Payment done</a>
                            </span>
                            <Error error={errors} />
                            <Success success={successMessage} />
                        </div>
                    </div>
                </div>

            </Overlay>

        </>
    )
}
