import React from "react";
import { useEffect } from "react";
import { useState } from "react";
export default function Pagination({
  paginate,
  currentPage,
  usersPerPage,
  total_records,
  setCurrentPage,
  eventInitiated,
}) {
  const [maxPageNumberLimit, setmaxPageNumberLimit] = useState(5);
  const [minPageNumberLimit, setminPageNumberLimit] = useState(0);
  const pageNumberLimit = 5;
  const pageNumbers = [];

  useEffect(() => {
    if (eventInitiated) {
      setmaxPageNumberLimit(5);
      setminPageNumberLimit(0);
    }

    return () => {
      eventInitiated = false;
    };
  }, [eventInitiated]);

  let num = pageNumbers.length;
  for (let i = 1; i <= Math.ceil(total_records / usersPerPage); i++) {
    pageNumbers.push(i);
  }
  const paginateNext = (event, number) => {
    event.preventDefault();
    paginate(number);
  };
  const handlePrevbtn = () => {
    setCurrentPage(currentPage - 1);
    if ((currentPage - 1) % pageNumberLimit == 0) {
      setmaxPageNumberLimit(maxPageNumberLimit - pageNumberLimit);
      setminPageNumberLimit(minPageNumberLimit - pageNumberLimit);
    }
  };

  const handleNextbtn = () => {
    setCurrentPage(currentPage + 1);
    if (currentPage + 1 > maxPageNumberLimit) {
      setmaxPageNumberLimit(maxPageNumberLimit + pageNumberLimit);
      setminPageNumberLimit(minPageNumberLimit + pageNumberLimit);
    }
  };

  // console.log(`page numbers: `, pageNumbers);

  return pageNumbers.length != 0 ? (
    <nav>
      <ul>
        <button disabled={currentPage == 1} onClick={handlePrevbtn}>
          {" "}
          Prev
        </button>

        {pageNumbers.map((number, i) => {
          // console.log(`number`, number);
          return (
            <React.Fragment key={i}>
              {number < maxPageNumberLimit + 1 &&
              number > minPageNumberLimit ? (
                <>
                  <li
                    key={number}
                    style={{
                      display: "inline-block",
                      padding: "10px",
                      textAlign: "center",
                      backgroundColor:
                        currentPage === number ? "grey" : "white",
                    }}
                  >
                    <a
                      onClick={(event) => {
                        paginateNext(event, number);
                      }}
                      className="page-link"
                      href=""
                    >
                      {number}
                    </a>
                  </li>
                </>
              ) : null}
            </React.Fragment>
          );
        })}
        <button
          disabled={currentPage >= pageNumbers.length}
          style={{ padding: "15px" }}
          onClick={handleNextbtn}
        >
          Next
        </button>
      </ul>
    </nav>
  ) : (
    <></>
  );
}
