import React, { useEffect } from "react";
import { useState } from "react";
import useAxiosIntercept from "../../../../hooks/useAxiosIntercept";
import VehicleBrandDetails from "./VehicleBrandDetails";
import { useFormInputValidation } from "react-form-input-validation";
import { Link } from "react-router-dom";
import Error from "../../../UI/Error";
import { verifyOtpInAddPartner } from "../../../../configuration/GlobalConfig";

const CompanyDetails = ({
  formDataValue,
  setformDataValue,
  page,
  setPage,
  getDetails,
}) => {
  const axiosPrivate = useAxiosIntercept();
  //const check = true;
  const [counter, setCounter] = useState(0);
  const [phone, setPhone] = useState("");
  const [totalRecords, setTotalRecords] = useState("");
  const [successMsg, setSuccessMsg] = useState("");
  const [otpErrorMsg, setOtpErrorMsg] = useState("");
  const [otpSuccessMsg, setOtpSuccessMsg] = useState("");
  const [showImage, setShowImage] = useState(false);
  const [error, setError] = useState("");
  const [imageError, setImageError] = useState("");
  const [image, setImage] = useState({});
  const [thumbnail, setThumbnail] = useState("");
  const [verified, setVerified] = useState(false);
  const [checkOtp, setcheckOtp] = useState(true);
  const [otp, setOtp] = useState("");
  const [texterrors, setTextErrors] = useState({
    nameError: "",
    employeeNameError: "",
    designationError: "",
  });

  const controller = new AbortController();

  useEffect(() => {
    if (counter > 0) {
      setTimeout(() => {
        setCounter((prev) => prev - 1);
      }, 1000);
    } else {
      setcheckOtp(true);
    }
  }, [counter]);

  const sendOtp = () => {
    if (fields.phone && checkOtp&&verifyOtpInAddPartner) {
      errors.phone = "";
      setcheckOtp(false);
      setError("");
      setOtpErrorMsg("");
      setSuccessMsg("");

      let userListSearchUrl =
        process.env.REACT_APP_GET_USER_LIST_SEARCH_BY_PHONE_FOR_TYPE_P;
      try {
       
        const checkUser = async () =>
        {
          const response = await axiosPrivate.get(
            userListSearchUrl + `&search_keyword=${fields.phone}`,
            {
              signal: controller.signal,
            }
          );
          if (response?.data.status === 200) {
            const records = response?.data?.response?.data?.total_records;

            const sendOtpRequest = {
              comm_value: `${fields.phone}`,
              object_type: "add_partner",
            };
            if (records == 0 && checkOtp) {
              //checkOtp
              //setcheckOtp(false);

              let sendOtpUrl = process.env.REACT_APP_SEND_OTP;
              const sendOtpResponse = await axiosPrivate.post(
                sendOtpUrl,
                sendOtpRequest
              );
              if (sendOtpResponse?.data?.status === 200) {
                setCounter(30);
                setSuccessMsg(sendOtpResponse?.data?.message);
              } else {
                setError(sendOtpResponse?.data?.message);
                setcheckOtp(true);
              }
            } else {
              setError("user already exists");
              setcheckOtp(true);
            }
          } else {
            setError("Please fill valid phone number");
            setcheckOtp(true);
          }
        
        }
       

        verifyOtpInAddPartner&&checkUser();
      } catch (err) {
        console.log(err);
        setcheckOtp(true);
      }
    } else if (!fields.phone) {
      setError("Please enter Phone number");
    }
    // let userListSearchUrl =
    //   process.env.REACT_APP_GET_USER_LIST_SEARCH_BY_PHONE_FOR_TYPE_P;
  };

  const [fields, errors, form] = useFormInputValidation(
    {
      name: "",
      employee_name: "",
      designation: "",
      phone: "",
      email: "",
      otp: "",
    },
    {
      name: "required|string",
      employee_name: "required|string",
      designation: "required|string",
      phone: "required|numeric|digits_between:8,10",
      email: "required|email",
      otp:verifyOtpInAddPartner?"required|numeric|digits:4":"numeric|digits:4"
     
    }
  );

  const handelPage = async (e) => {
    console.log(errors, "errors");
     Object.keys(errors).forEach((i) => (errors[i] = null));
    setError("");
    setOtpErrorMsg("");

    const isValid = await form.validate(e);

    if (showImage === false) {
      setImageError("Please upload image");
    }

    if (isValid && showImage === true) {
      Object.keys(errors).forEach((i) => (errors[i] = null));
      const verifyOtpRequest = {
        comm_value: `${fields.phone}`,
        object_type: "add_partner",
        otp: `${fields.otp}`,
      };
    
      if (verifyOtpInAddPartner&&fields.otp) {
        setError("");
        setOtpErrorMsg("");
        let verifyOty = process.env.REACT_APP_VERIFY_OTP;
        const verifyOtpResponse = await axiosPrivate.post(
          verifyOty,
          verifyOtpRequest
        );
        if (verifyOtpResponse?.data?.status === 200) {
          setOtpSuccessMsg(verifyOtpResponse?.data?.message);
          getDetails(
            {
              name: fields.name,
              employee_name: fields.employee_name,
              designation: fields.designation,
              phone: fields.phone,
              email: fields.email,
              partner_logo: image,
            },
            "COMPANY"
          );
          setTimeout(() => {
            setPage(1);
          }, 1000);
        } else {
          setOtpErrorMsg(verifyOtpResponse?.data?.message);
        }
      } else
      {
        verifyOtpInAddPartner && setOtpErrorMsg("Please click on send otp");
        if (!verifyOtpInAddPartner&&fields.phone)
        {
           let userListSearchUrl =
             process.env.REACT_APP_GET_USER_LIST_SEARCH_BY_PHONE_FOR_TYPE_P;
          const response = await axiosPrivate.get(
            userListSearchUrl + `&search_keyword=${fields.phone}`,
            {
              signal: controller.signal,
            }
          );
         
          
          if (response?.data.status === 200) {
            const records = response?.data?.response?.data?.total_records;

            if (records == 0)
            {
               getDetails(
            {
              name: fields.name,
              employee_name: fields.employee_name,
              designation: fields.designation,
              phone: fields.phone,
              email: fields.email,
              partner_logo: image,
            },
            "COMPANY"
          );
          setTimeout(() => {
            setPage(1);
          }, 1000);
            }
             else {
       setError("user already exists");
      }
          
          }
        }   
      }
    }
  };

  function handleImage(e) {
    setImage(e.target.files[0]);
    setShowImage(true);

    setThumbnail(URL.createObjectURL(e.target.files[0]));
  }

  const removeImage = () => {
    setThumbnail();
    setImage();
    setShowImage(false);
  };

  return (
    <form onSubmit={handelPage}>
      <div className="subContent pad-24">
        <div className="pacakgeDetails mt-16 mb-24"></div>
        <div className="dForm w300">
          <div className="fieldGroup mt-0">
            <label>Company name</label>
            <span className={errors.name ? "error" : " "}>
              <input
                type="text"
                placeholder="Enter company name"
                name="name"
                onChange={form.handleChangeEvent}

                value={fields.name}
                autoComplete="off"
              />
            </span>
            {errors.name && <Error error={errors.name} />}
          </div>
          <div className="fieldGroup ">
            <label>Employee name</label>
            <span className={errors.employee_name ? "error" : ""}>
              <input
                type="text"
                placeholder="Enter employee name"
                name="employee_name"
                onChange={form.handleChangeEvent}

                value={fields.employee_name}
                autoComplete="off"
              />
            </span>
            {errors.employee_name && <Error error={errors.employee_name} />}
          </div>
          <div className="fieldGroup">
            <label>Employee designation</label>
            <span className={errors.designation ? "error" : ""}>
              <input
                type="text"
                placeholder="Enter employee designation"
                name="designation"
                onChange={form.handleChangeEvent}

                value={fields.designation}
                autoComplete="off"
              />
            </span>
            {errors.designation && <Error error={errors.designation} />}
          </div>
          <div className="fieldGroup mobileVerfiy">
            <label>Mobile number</label>
            <span className={errors.phone ? "error" : ""}>
              <input
                type="text"
                placeholder="Enter mobile number"
                name="phone"
                onChange={form.handleChangeEvent}

                value={fields.phone}
                autoComplete="off"
                maxLength="10"
              />
              <em>
                {verifyOtpInAddPartner &&
                  <Link
                  onClick={sendOtp}
                  style={{ pointerEvents: fields.phone ? "" : "none" }}
                >
                  {successMsg
                    ? counter === 0
                      ? "Resend OTP"
                      : `Resend OTP in ${counter}`
                    : "Send OTP"}
                </Link>
                }
                
              </em>
            </span>
            {errors.phone && <Error error={errors.phone} />}

            {successMsg !== "" ? (
              <span className="success">
                <span className="material-symbols-rounded success mt-xs fill">
                  check_circle
                </span>
                {successMsg}
              </span>
            ) : (
              <>
                {error !== "" ? (
                  <span className="error">
                    <span className="material-symbols-rounded error mt-xs fill">
                      info
                    </span>
                    {error}
                  </span>
                ) : (
                  <></>
                )}
              </>
            )}

            {successMsg ? (
              <>
                <br />
                <span className={errors.otp ? "error" : ""}>
                  <input
                    type="text"
                    placeholder="Enter OTP"
                    name="otp"
                    onChange={form.handleChangeEvent}

                    value={fields.otp}
                    maxLength="4"
                  />
                </span>
                {errors.otp && <Error error={errors.otp} />}
              </>
            ) : (
              <></>
            )}
            <div className="">
              {otpErrorMsg !== "" ? (
                <span className="error">
                  <span className="material-symbols-rounded error mt-xs fill">
                    info
                  </span>
                  {otpErrorMsg}
                </span>
              ) : (
                <>
                  {otpSuccessMsg != "" ? (
                    <span className="success">
                      <span className="material-symbols-rounded success mt-xs fill">
                        check_circle
                      </span>
                      {otpSuccessMsg}
                    </span>
                  ) : (
                    <></>
                  )}
                </>
              )}
            </div>
          </div>
          <div className="fieldGroup ">
            <label>Email</label>
            <span className={errors.email ? "error" : ""}>
              <input
                type="text"
                placeholder="Enter email"
                name="email"
                onChange={form.handleChangeEvent}

                value={fields.email}
                autoComplete="off"
              />
            </span>

            {errors.email && <Error error={errors.email} />}

            {/* {errors.email && (fields.email == "" || fields.email !== "") && (
              <Error error={errors.email} />
            )} */}
          </div>
          <div className="fieldGroup wAuto">
            <label>
              Upload company logo
              <em>
                Upload guidelines: JPG or PNG format of minimum 200x200 with
                white background
              </em>
            </label>
            <div className="customFileUploader">
              {showImage ? (
                <>
                  <div className="csutomImgUploads">
                    <span onClick={removeImage}>
                      <i className="material-symbols-rounded white arrowBottom mt-m arrow">
                        delete
                      </i>
                      <img src={thumbnail} alt="" />
                    </span>
                  </div>
                </>
              ) : (
                <>
                  <input
                    type="file"
                    id="actual-btn"
                    name="partner_logo"
                    onChange={handleImage}
                    onKeyUp={form.handleBlurEvent}

                  // onChange={(e) => setImage(e.target.files[0])}
                  // onChange={form.handleChangeEvent}
                  />
                  <label htmlFor="actual-btn">
                    <i className="material-symbols-rounded grey arrowBottom mt-l arrow">
                      add_a_photo
                    </i>
                  </label>
                </>
              )}
            </div>
            {showImage === false && imageError != "" ? (
              <>{imageError && <Error error={imageError} />}</>
            ) : (
              <></>
            )}
          </div>
          <div className="actionButtons mt-24">
            <span className="">
              <button type="submit" className="btn prim">
                {page === 0 ? "Next" : "Submit"}
              </button>
            </span>
          </div>
        </div>
      </div>
    </form>
  );
};

export default CompanyDetails;
