import React from "react";
import useAxiosIntercept from "../../../../hooks/useAxiosIntercept";
import { useState, useEffect, useRef } from "react";
import { useNavigate, useLocation, Link } from "react-router-dom";
import Message from "../../../../utils/Message";

const VehicleBrandDetails = ({
  getDetails,
  formDataValue,
  setformDataValue,
  page,
  setPage,
}) => {
  const [brands, setBrands] = useState([]);
  const [selected, setSelected] = useState({});
  const [isSuccess, setIsSuccess] = useState(false);
  const [showMessage, setShowMessage] = useState(false);
  const [enableSubmit,setEnableSubmit]=useState(true)
  const [message, setMessage] = useState({});

  const addPartner = async () => {
    let formData = new FormData();
    Object.keys(formDataValue).map((item) => {
      if (item === "selectBrand" ) {
        formDataValue[item].map((dataItem, dataIndex) => {
          formData.append(`brand_id[${dataIndex}]`, dataItem);
        });
      } else {
        formData.append(item, formDataValue[item]);
      }
    });

    //getDetails(formDataValue, "VEHICLE");

    try {
      if (enableSubmit == true) {
        setEnableSubmit(false);
        const config = { headers: { "content-type": "multipart/form-data" } };
      const response = await axiosPrivate.post(
        process.env.REACT_APP_CREATE_PARTNER,
        formData,
        config
      );
      if (response?.data?.status === 200) {
        setIsSuccess(true);
        setShowMessage(true);
        setMessage({
          id: 1,
          text: `"${formDataValue.name}" \nadded successfully`,
        });

        //setuserdata({ name: "", email: "", user_type: "", phone: "" });
      } else {
        setIsSuccess(false);
        setShowMessage(true);

        setMessage({
          id: 2,
          text: response?.data?.response?.errors
            ? response?.data?.response?.errors[0].message
            : response?.data?.message,
        });
      }
      setformDataValue({});
      }
      

      //   document.getElementById("myForm").reset();
      //   if (response?.data?.message === "success") {
      //     //setMsg("data added successfully");
      //   } else if (response?.data?.response?.errors.length != 0) {
      //     //setMsg(response?.data?.response?.errors[0]?.message);
      //   }
    } catch (err) {
      // return responseHandler(err, "NETWORK_ERROR");
    }
  };

  const location = useLocation();
  const axiosPrivate = useAxiosIntercept();
  const [error, seterror] = useState("");
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getbrands = async () => {
      let URL = process.env.REACT_APP_GET_VEHICLE_BRAND_LIST;

      try {
        const response = await axiosPrivate.get(URL, {
          signal: controller.signal,
        });
        isMounted && setBrands(response?.data?.response?.data?.brand_details);
      } catch (err) {
        seterror(err);
      }
    };
    getbrands();
    // }

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, []);
  const handelSelect = (id) => {
    let brandsData = formDataValue.selectBrand;

    if (brandsData.includes(id)) {
      let idIndex = brandsData.indexOf(id);
      let data = brandsData.splice(idIndex, 1);
      return getDetails(brandsData, "VEHICLE");
    }
    brandsData.push(id);
    return getDetails(brandsData, "VEHICLE");
    // });
  };
  const onBackdropClick = () => {
    setShowMessage(false);
  };
  const navigate = useNavigate();
  const goBack = () => {
    navigate(-1);
  };
  const handelPage = () => {
    if (page == 1) {
      setPage(0);
    }
    if (page == 0) {
      goBack();
    }
  };

  return brands ? (
    <>
      {showMessage && (
        <Message
          message={message}
          onBackdropClick={onBackdropClick}
          errorLink="/customers/CreateNewPartner"
          successLink="/customers/partner"
          errorValue="Try again"
          successValue="Go Back To Partners"
          isSuccess={isSuccess}
        />
      )}

      <div className="subContent pad-24">
        <div
          class="heading mb-24"
          onClick={handelPage}
          style={{ cursor: "pointer" }}
        >
          <i class="material-symbols-rounded grey mt-s">arrow_back_ios_new</i>
          <a>Back to company details</a>
        </div>
        <div className="dForm w300">
          <div className="fieldGroup mt-0 wAuto">
            <label>Select dealing vehicle brands</label>
            <div className="brandLists mt-16">
              <ul>
                {brands.map((brandList) => {
                  return (
                    <li
                      onClick={(e) => handelSelect(brandList.id)}
                      id={brandList.id}
                    >
                      <a href="javascript:void(0);">
                        <img src={brandList.image} alt="" />
                        <em>{brandList.name}</em>
                        {formDataValue.selectBrand.includes(brandList.id) ? (
                          <p className="selected">
                            <i className="material-symbols-rounded mt-m arrow">
                              done
                            </i>
                            <b>Selected</b>
                          </p>
                        ) : (
                          <p>
                            <b>Select</b>
                          </p>
                        )}
                      </a>
                    </li>
                  );
                })}
              </ul>
            </div>
          </div>
          <div className="actionButtons mt-24">
            <span className="">
              <a
                onClick={addPartner}
                className="btn prim open_model"
                data-target="thanksPopup"
              >
                Add customer
              </a>
            </span>
          </div>
        </div>
      </div>
    </>
  ) : (
    <></>
  );
};

export default VehicleBrandDetails;
