import React from "react";
import { useState, useEffect } from "react";
import { useLocation } from "react-router-dom";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Spinner from "../../UI/Spinner";
import Pagination from "../../Customer/Pagination";
import PartnerEmployeesListing from "./PartnerEmployeeListing";
import useHttp from "../../../hooks/useHttp";
import usePaginate from "../../../hooks/usePaginate";
import Loading from "../../UI/Loading";
import NoData from "../../UI/NoData";
export default function PartnerEmployee({ }) {
  const axiosPrivate = useAxiosIntercept();
  const perPageLimit = 2;
  const dataValues = useLocation().state;

  const partner_name = dataValues.partner_name;
  const partner_id = dataValues.partner_id;
  const created_at = dataValues.created_at;

  const partner_logo = dataValues.partner_logo;
  //selectBrand= dataValues.brand_id,

  const [isSuccess, setisSuccess] = useState(false);
  const [users, setUsers] = useState("");
  const [currentPage, setCurrentPage] = useState(1);
  const [usersPerPage, setUsersPerPage] = useState(5);
  const [total_records, setTotalRecords] = useState(0);
  const [eventInitiated, setEventInitiated] = useState(false);
  const [pageNumber, setPageNumber] = useState(1);
  const [hasMore, setHasMore] = useState(false);
  let url =
    process.env.REACT_APP_GET_ADMIN_LIST +
    `&user_type=P&page=${pageNumber}&limit=${perPageLimit}&partner_id=${partner_id}`;
  const { isLoading, sendRequest: getusers } = useHttp();

  const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);
  useEffect(() => {
    const setSearchedusers = (searchedUsers) => {
      const { data } = searchedUsers?.data?.response;
      if (data?.user_info && data?.user_info.length > 0) {
        setUsers((prev) => {
          return [...new Set([...prev, ...data?.user_info])];
        });
        setTotalRecords(data?.total_records);
      } else {
        setUsers({});
      }

      if (data?.total_records == data?.user_info?.length) {
        setHasMore(false);
      } else {
        setHasMore(searchedUsers.data.response.data?.user_info.length > 0);
      }
    };
    if (
      pageNumber == 1 ||
      Math.ceil(parseInt(total_records) / perPageLimit) >= pageNumber
    ) {
      getusers(
        {
          url,
        },
        setSearchedusers
      );
    }
  }, [url, pageNumber, getusers]);
  // const getList = async (isMounted, controller) => {
  //   let URL =
  //     process.env.REACT_APP_GET_ADMIN_LIST +
  //     `&user_type=P&page=${currentPage}&limit=${usersPerPage}&partner_id=${partner_id}`;
  //   try {
  //     const response = await axiosPrivate.get(URL, {
  //       signal: controller.signal,
  //     });
  //     console.log(response);
  //     isMounted && setUsers(response?.data?.response?.data?.user_info);
  //     setTotalRecords(response?.data?.response?.data?.total_records);
  //   } catch (err) {
  //     console.log(err);
  //   }
  // };
  // useEffect(() => {
  //   let isMounted = true;
  //   const controller = new AbortController();
  //   getList(isMounted, controller);
  //   return () => {
  //     isMounted = false;
  //     controller.abort();
  //     // effectRun.current = true; // update the value of effectRun to true
  //   };
  // }, [isSuccess, currentPage, eventInitiated]);
  const paginate = (number) => {
    setCurrentPage((prev) => {
      return number;
    });
    // setCurrentPage(number);
    // setEventInitiated(true);
  };
  return (
    <>
      <PartnerEmployeesListing
        users={users}
        setUsers={setUsers}
        isSuccess={isSuccess}
        setisSuccess={setisSuccess}
        partner_logo={partner_logo}
        partner_name={partner_name}
        created_at={created_at}
        lastElementRef={lastElementRef}
      />
      {/* <Pagination
        paginate={paginate}
        currentPage={currentPage}
        usersPerPage={usersPerPage}
        total_records={total_records}
        setUsersPerPage={setUsersPerPage}
        setCurrentPage={setCurrentPage}
        eventInitiated={eventInitiated}
      /> */}

      <div>{isLoading && pageNumber != 1 && <Loading />}</div>
      {pageNumber != "1" && pageNumber > Math.ceil(total_records / perPageLimit) && (<NoData />)}
    </>
  );
}
