import React from "react";
import useAuth from "../../../hooks/useAuth";
import { useState } from "react";
import { Link } from "react-router-dom";

import Spinner from "../../UI/Spinner";
import { FormatDate } from "../../../utils/FormatDate";
import DataNotFound from "../../UI/DataNotFound";
export default function PartnerEmployeesListing({
  users,
  setUsers,
  isSuccess,
  setisSuccess,
  partner_logo,
  partner_name,
  created_at,
  lastElementRef,
}) {
  const { auth } = useAuth();
  const [editpopup, seteditpopup] = useState(false);
  const [deletepopUp, setdeletepopup] = useState(false);
  const [addpopup, setaddpopup] = useState(false);
  const [userDetails, setuserDetails] = useState({
    name: "",
    designation: "",
    email: "",
    phone: "",
    role: "",
  });
  //const isRoot = auth?.userIsRoot.toLowerCase();
  const [notifyData, setNotifyData] = useState();

  return (
    <>
      <div class="userInfo big mr-0">
        <div class="name">
          <span>{partner_name}</span>
          <span>Onboarded on {FormatDate(created_at)}</span>
        </div>
      </div>
      <div class="mt-24">
        <div class="searchPanel ">
          <h3>Employees</h3>
          {/* {isRoot == "y" && (
            <a class="btn prim open_model" data-target="addEmployee">
              Add new employee
            </a>
          )} */}
        </div>
        {users == "" ? (
          <Spinner />
        ) : Object.keys(users).length != "0" ? (
          <>
            <div class="dataTableDynamic">
              <table>
                <tbody>
                  <tr>
                    <th>Name</th>
                    <th>Designation</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Role</th>
                  </tr>
                  {users && users?.length > 0
                    ? users.map((user, index) => {
                        let fullName = "";
                        fullName = user.firstname
                          ? fullName + " " + user.firstname
                          : "";
                        fullName = user.lastname
                          ? fullName + " " + user.lastname
                          : fullName;
                        if (users.length == index + 1) {
                          return (
                            <>
                              <tr ref={lastElementRef}>
                                <td class="vName">
                                  <span>
                                    {user.firstname ? fullName : "Guest"}
                                  </span>
                                </td>
                                <td>
                                  {user.designation ? user.designation : "N/A"}
                                </td>
                                <td>{user.email ? user.email : "N/A"}</td>
                                <td>{user.phone}</td>
                                <td class="status">
                                  {user.is_root == "Y" ? "Superadmin" : "Admin"}
                                </td>
                              </tr>
                            </>
                          );
                        } else {
                          return (
                            <>
                              <tr>
                                <td class="vName">
                                  <span>
                                    {user.firstname ? fullName : "Guest"}
                                  </span>
                                </td>
                                <td>{user.designation}</td>
                                <td>{user.email ? user.email : "N/A"}</td>
                                <td>{user.phone}</td>
                                <td class="status">
                                  {user.is_root == "Y" ? "Superadmin" : "Admin"}
                                </td>
                              </tr>
                            </>
                          );
                        }
                      })
                    : ""}
                </tbody>
              </table>
            </div>
          </>
        ) : (
          <>
            <DataNotFound/>
          </>
        )}
      </div>
    </>
  );
}
