import React, { useState, useEffect } from "react";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import { useLocation, useParams, Link, useNavigate } from "react-router-dom";
import { FormatDate } from "../../utils/FormatDate";
import BookingCard from "../UI/BookingCard";
import { HourMapping } from "../../configuration/createPackageFormConfigs";
import { unavailable } from "../../configuration/GlobalConfig";
import { Time } from "../../utils/Time";
import MarkPaymentDone from "./MarkPaymentDone";
import JobDetails from "./JobDetails";
import ViewChargeHistory from "../../utils/ViewChargeHistory";
import Pagination from "./Pagination";
import FindingsPopUp from "./FindingsPopUp";
import ImagePopUp from "../../utils/ImagePopUp";
import Spinner from "../UI/Spinner";
import DataNotFound from "../UI/DataNotFound";
import useAuth from "../../hooks/useAuth";
const PastBookings = ({
  pastBookingData,
  total_records,
  currentPage,
  setCurrentPage,
  usersPerPage,
  setUsersPerPage,
  paginate,
  isPaymentDone,
  setisPaymentDone,
  setBookingsDetails,
  lastElementRef,
}) => {
  const axiosPrivate = useAxiosIntercept();
  const { auth, setAuth } = useAuth();
  const [toggle, setToggle] = useState({});
  const [findings, setfindings] = useState();
  const [jobHistory, setjobHistory] = useState("");
  const [activityLog, setactivityLog] = useState();
  const [showJobDetails, setShowJobDetails] = useState(false);
  const [showchargeHistory, setShowChargeHistory] = useState(false);
  const [findingpopup, setfindingpopup] = useState(false);
  const handleExpand = (e, booking_id) => {
    setToggle({ [e.currentTarget.id]: !toggle[e.currentTarget.id] });
    findingsData(booking_id);
  };
  const [imageData, setimageData] = useState({
    heading: "",
    tabs: "",
    time: "",
    image: "",
    subheading: "",
  });
  const [paymentDonePopUp, setpaymentDonepopUp] = useState(false);
  const [openImage, setOpenImage] = useState(false);

  const [bookingDetails, setbookingDetails] = useState({
    index: "",
    booking_id: "",
    booking_slot: "",
    user_firstname: "",
    user_lastname: "",
    user_vehicle_no: "",
    driver_firstname: "",
    driver_lastname: "",
    driver_vehicle_no: "",
  });
  var addOns = "";
  const getJobDetails = async (booking_id) => {
    const body = {
      booking_id: booking_id,
    };
    const response = await axiosPrivate.post(
      process.env.REACT_APP_GET_SERVICE_HISTORY,
      body
    );
    if (response?.data?.status == "200") {
      setjobHistory(response?.data?.response?.data?.service_log);
    }
    setShowJobDetails(true);
  };
  const closeJobDetails = () => {
    document.body.classList.remove("hidden");
    setShowJobDetails(false);
  };
  const onBackdropClick = () => {
    document.body.classList.remove("hidden");
    setShowChargeHistory(false);
  };
  const getChargingHistory = async (booking_id) => {
    const request = {
      booking_id: booking_id,
      service_id: "1",
    };
    const response = await axiosPrivate.post(
      process.env.REACT_APP_GET_SERVICE_HISTORY,
      request
    );

    if (response?.status == "200") {
      if (response?.data?.response?.data?.service_log) {
        setactivityLog(
          response?.data?.response?.data?.service_log[0]?.activity_log
        );
      }
    }
    setShowChargeHistory(true);
  };
  const handleClick = (
    e,
    index,
    booking_id,
    booking_slot,
    user_firstname,
    user_lastname,
    user_vehicle_no,
    driver_firstname,
    driver_lastname,
    driver_vehicle_no
  ) => {
    const booking = pastBookingData[index];
    setbookingDetails({
      index: index,
      booking_id: booking_id,
      booking_slot: booking_slot,
      user_firstname: user_firstname,
      user_lastname: user_lastname,
      user_vehicle_no: user_vehicle_no,
      driver_firstname: driver_firstname,
      driver_lastname: driver_lastname,
      driver_vehicle_no: driver_vehicle_no,
    });
    setpaymentDonepopUp(true);
  };
  const findingsData = async (id) => {
    const body = {
      booking_id: id,
    };
    const response = await axiosPrivate.post(
      process.env.REACT_APP_GET_FINDINGS_IN_CAR,
      body
    );
    setfindings(response?.data?.response?.data?.findings);

    // setfindingpopup(true);
  };
  const viewFindingsinCar = () => {
    setfindingpopup(true);
  };
  const closefindDatapopup = () => {
    document.body.classList.remove("hidden");
    setfindingpopup(false);
  };

  const downloadInvoice = async (e, id) => {
    const invoiceURL = process.env.REACT_APP_DOWNLOAD_INVOICE;
    const invoicerequest = {
      order_id: id,
    };
    const invoiceresponse = await axiosPrivate.post(invoiceURL, invoicerequest);

    if (invoiceresponse?.data?.status === 200) {
      const downloadInvoiceLink = invoiceresponse?.data?.response?.data?.file;
      window.open(downloadInvoiceLink, "_blank");
    }
  };
  const viewParkingPhoto = async (booking_id) => {
    const url = process.env.REACT_APP_GET_SERVICE_HISTORY;
    const body = {
      booking_id: booking_id,
      parking_log: "1",
    };
    const response = await axiosPrivate.post(url, body);

    if (response?.data?.status == "200") {
      setimageData({
        heading: "Parking fee photo",
        image:
          response?.data?.response?.data?.service_log[0]?.activity_log[0]
            ?.service_image,
        total: response?.data?.response?.data?.service_log?.length,
        index: "0",
        outerClass: "model_box_child aFindingsPGalleryP",
        outerId: "aFindingsPGalleryP",
      });
      setOpenImage(true);
    }
  };
  return pastBookingData == "" ? (
    <Spinner />
  ) : Object.keys(pastBookingData).length !== 0 ? (
    <>
      {openImage && (
        <ImagePopUp
          imageData={imageData}
          setOpenImage={setOpenImage}
          setimageData={setimageData}
        />
      )}
      {paymentDonePopUp && (
        <MarkPaymentDone
          setpaymentDonepopUp={setpaymentDonepopUp}
          booking_id={bookingDetails.booking_id}
          booking_slot={bookingDetails?.booking_slot}
          user_firstname={bookingDetails?.user_firstname}
          user_lastname={bookingDetails?.user_lastname}
          user_vehicle_no={bookingDetails?.user_vehicle_no}
          driver_firstname={bookingDetails.driver_firstname}
          driver_lastname={bookingDetails.driver_lastname}
          driver_vehicle_no={bookingDetails.driver_vehicle_no}
          isPaymentDone={isPaymentDone}
          setisPaymentDone={setisPaymentDone}
          index={bookingDetails.index}
          pastBookingData={pastBookingData}
          setBookingsDetails={setBookingsDetails}
        />
      )}
      {auth.priviliges.includes("read_bookings") ? (
        <div className="dataTableDynamic">
          <table>
            <thead>
              <tr>
                <th>Car details</th>
                <th>Booking date</th>
                <th>Booked by</th>
                <th>Address</th>
                <th>Add-ons</th>
                <th>Job by</th>
                <th>Total bill</th>
                <th>&nbsp;</th>
              </tr>
            </thead>
            <tbody>
              {pastBookingData.length != 0 ? (
                <>
                  {pastBookingData.map((bookingsData, i) => {
                    const bookingType =
                      bookingsData?.booking_info?.booking_type;
                    const order_id = bookingsData?.booking_info?.order_id
                      ? bookingsData?.booking_info?.order_id
                      : "";
                    const order_status = bookingsData?.booking_info
                      ?.order_status
                      ? bookingsData?.booking_info?.order_status
                      : "";
                    const booking_id = bookingsData?.booking_info?.booking_id
                      ? bookingsData?.booking_info?.booking_id
                      : "";
                    const booking_slot = bookingsData?.booking_info
                      ?.booking_slot
                      ? bookingsData?.booking_info?.booking_slot
                      : "";
                    const user_firstname = bookingsData?.user_profile_data
                      ?.firstname
                      ? bookingsData?.user_profile_data?.firstname
                      : "";
                    const user_lastname = bookingsData?.user_profile_data
                      ?.lastname
                      ? bookingsData?.user_profile_data?.lastname
                      : "";
                    const user_vehicle_no = bookingsData?.vehicle_info
                      ?.registration_no
                      ? bookingsData?.vehicle_info?.registration_no
                      : "";
                    const driver_firstname = bookingsData?.driver_details
                      ?.firstname
                      ? bookingsData?.driver_details?.firstname
                      : "";
                    const driver_lastname = bookingsData?.driver_details
                      ?.lastname
                      ? bookingsData?.driver_details?.lastname
                      : "";
                    const driver_vehicle_no = bookingsData?.puppy_info
                      ?.registration_no
                      ? bookingsData?.puppy_info?.registration_no
                      : "";
                    const vehicle_registration_no = bookingsData?.vehicle_info
                      ?.registration_no
                      ? bookingsData?.vehicle_info?.registration_no
                      : "";
                    const package_name = bookingsData?.package_info
                      ?.package_name
                      ? bookingsData?.package_info?.package_name
                      : "";
                    const vehicle_brand = bookingsData?.vehicle_info?.brand_name
                      ? bookingsData?.vehicle_info?.brand_name
                      : "";
                    const vehicle_model = bookingsData?.vehicle_info?.model_name
                      ? bookingsData?.vehicle_info?.model_name
                      : "";
                    const variant_image = bookingsData?.vehicle_info
                      ?.variant_name
                      ? bookingsData?.vehicle_info?.variant_image
                      : "";
                    addOns = "";
                    const planInfo = () => {
                      var packageTypeId =
                        bookingsData?.package_info?.package_type_id;
                      var info = "";

                      const packageName =
                        bookingsData?.package_info?.package_name;
                      const packagePrice =
                        bookingsData?.package_info.package_price;
                      const packageDuration =
                        bookingsData.package_info.package_duration;
                      const packageDurationUnit =
                        bookingsData?.package_info?.package_duration_unit;
                      info = packageName ? info + packageName : info;
                      info =
                        parseInt(packagePrice) != 0
                          ? info + " @$" + packagePrice
                          : info;
                      info =
                        packageTypeId != 1 && packageDuration != 0
                          ? info + " (" + packageDuration
                          : info;
                      info =
                        packageTypeId != 1 &&
                        packageDuration != 0 &&
                        packageDurationUnit
                          ? info + HourMapping?.[packageDurationUnit] + ")"
                          : info;
                      return info;
                    };
                    if (pastBookingData.length == i + 1) {
                      return (
                        <React.Fragment key={i}>
                          <tr
                            ref={lastElementRef}
                            onClick={(e) => handleExpand(e, booking_id)}
                            id={i}
                            style={{ cursor: "pointer" }}
                          >
                            <td className="vName">
                              <span>
                                {bookingsData?.vehicle_info?.brand_name
                                  ? bookingsData?.vehicle_info?.brand_name
                                  : unavailable}
                              </span>
                              <span>
                                {bookingsData?.vehicle_info?.registration_no
                                  ? bookingsData?.vehicle_info?.registration_no
                                  : unavailable}
                              </span>
                            </td>
                            <td>
                              {FormatDate(
                                bookingsData.booking_info.booking_slot
                              )}
                            </td>
                            {bookingsData?.user_profile_data ? (
                              <>
                                <td>{`${
                                  bookingsData?.user_profile_data?.firstname
                                    ? bookingsData?.user_profile_data
                                        ?.firstname +
                                      " " +
                                      bookingsData?.user_profile_data?.lastname
                                    : unavailable
                                }`}</td>
                                <td>
                                  {bookingsData?.user_profile_data?.address
                                    ? bookingsData?.user_profile_data?.address
                                    : unavailable}
                                </td>
                              </>
                            ) : (
                              <>
                                <td>{unavailable}</td>
                                <td>{unavailable}</td>
                              </>
                            )}
                            {bookingsData?.booking_add_ons ? (
                              bookingsData?.booking_add_ons.map(
                                (bookingAddOnsData, index) => {
                                  bookingAddOnsData?.service_name &&
                                  bookingAddOnsData.service_status !== "6" ? (
                                    <>
                                      {
                                        (addOns =
                                          addOns +
                                          bookingAddOnsData?.service_name +
                                          ",")
                                        // bookingAddOnsData?.service_name
                                      }
                                    </>
                                  ) : (
                                    <>{unavailable}</>
                                  );
                                }
                              )
                            ) : (
                              <></>
                            )}

                            <td>
                              {addOns
                                ? addOns.substring(0, addOns.length - 1)
                                : unavailable}
                            </td>
                            {bookingsData?.driver_details ? (
                              <td>
                                <Link to="">{`${
                                  bookingsData?.driver_details?.firstname
                                    ? bookingsData?.driver_details?.firstname +
                                      " " +
                                      bookingsData?.driver_details?.lastname
                                    : unavailable
                                }`}</Link>
                              </td>
                            ) : (
                              <td>
                                <Link to="">{unavailable}</Link>
                              </td>
                            )}

                            <td>
                              {`$${bookingsData?.booking_info?.total}`}
                              {order_id > 0 && order_status == "F" && (
                                <div>
                                  <a
                                    class="error open_model"
                                    data-target="paymentDoneP"
                                    onClick={(e) => {
                                      handleClick(
                                        e,
                                        i,
                                        booking_id,
                                        booking_slot,
                                        user_firstname,
                                        user_lastname,
                                        user_vehicle_no,
                                        driver_firstname,
                                        driver_lastname,
                                        driver_vehicle_no
                                      );
                                    }}
                                  >
                                    Pending
                                  </a>
                                </div>
                              )}
                            </td>
                            {toggle[i] ? (
                              <td
                                style={{ cursor: "pointer" }}
                                className="right"
                              >
                                <i
                                  id={i}
                                  className="material-symbols-rounded arrowTop mt-l"
                                >
                                  expand_more
                                </i>
                                {/* {order_id != "0" && order_status == "F" && <a onClick={(e) => { handleClick(e, i, booking_id, booking_slot, user_firstname, user_lastname, user_vehicle_no, driver_firstname, driver_lastname, driver_vehicle_no) }}>Mark payment done</a>} */}
                              </td>
                            ) : (
                              <td
                                style={{ cursor: "pointer" }}
                                className="right"
                              >
                                <i
                                  id={i}
                                  className="material-symbols-rounded arrowBottom mt-l"
                                >
                                  expand_more
                                </i>
                              </td>
                            )}
                          </tr>
                          {toggle[i] ? (
                            <>
                              {findingpopup && (
                                <FindingsPopUp
                                  closefindDatapopup={closefindDatapopup}
                                  vehicle_registration_no={
                                    vehicle_registration_no
                                  }
                                  vehicle_brand={vehicle_brand}
                                  vehicle_model={vehicle_model}
                                  package_name={package_name}
                                  findings={findings}
                                  variant_image={variant_image}
                                  setOpenImage={setOpenImage}
                                  openImage={openImage}
                                  imageData={imageData}
                                  setimageData={setimageData}
                                />
                              )}
                              {console.log(bookingType, "typeeee8888")}
                              {showJobDetails && (
                                <JobDetails
                                  jobData={bookingsData?.booking_add_ons}
                                  vehicle_registration_no={
                                    vehicle_registration_no
                                  }
                                  package_name={package_name}
                                  vehicle_brand={vehicle_brand}
                                  vehicle_model={vehicle_model}
                                  variant_image={variant_image}
                                  jobHistory={jobHistory}
                                  closeJobDetails={closeJobDetails}
                                  setOpenImage={setOpenImage}
                                  openImage={openImage}
                                  imageData={imageData}
                                  setimageData={setimageData}
                                  booking_type={bookingType}
                                />
                              )}

                              {showchargeHistory && (
                                <ViewChargeHistory
                                  vehicle_registration_no={
                                    vehicle_registration_no
                                  }
                                  package_name={package_name}
                                  vehicle_brand={vehicle_brand}
                                  vehicle_model={vehicle_model}
                                  variant_image={variant_image}
                                  activityLog={activityLog}
                                  onBackdropClick={onBackdropClick}
                                  setOpenImage={setOpenImage}
                                  openImage={openImage}
                                  imageData={imageData}
                                  setimageData={setimageData}
                                />
                              )}
                              <tr className="expanded">
                                <td colspan="8">
                                  <div className="vehicleBill">
                                    <div className="time">
                                      <div className="YRow pt-8 pb-8">
                                        <BookingCard
                                          className="boxT1"
                                          heading="Plan"
                                          headingValue={
                                            planInfo()
                                            // bookingsData?.package_info
                                            //   ?.package_type_id !== "1"
                                            //   ? planInfo()
                                            //     ? planInfo()
                                            //     : unavailable
                                            //   : "Pay-As-You-Go"
                                          }
                                          subValue=""
                                        />
                                        <BookingCard
                                          className="boxT1"
                                          heading="Driver Time"
                                          headingValue={""}
                                          subValue={
                                            bookingsData?.booking_info
                                              ?.driver_assigned_on
                                              ? `${Time(
                                                  bookingsData?.booking_info
                                                    ?.driver_assigned_on
                                                )} - ${Time(
                                                  bookingsData?.booking_info
                                                    ?.driver_reached_on
                                                )}`
                                              : "N/A"
                                          }
                                        />
                                        <BookingCard
                                          className="boxT1"
                                          heading="Job Time"
                                          headingValue={""}
                                          link_val="View job photos"
                                          getData={getJobDetails}
                                          booking_id={booking_id}
                                          subValue={
                                            bookingsData?.booking_info
                                              ?.job_started
                                              ? `
                                    ${Time(
                                      bookingsData?.booking_info?.job_started
                                    )} - ${Time(
                                                  bookingsData?.booking_info
                                                    ?.job_done
                                                )}`
                                              : "N/A"
                                          }
                                        />

                                        {bookingsData.charging_data ? (
                                          <>
                                            <BookingCard
                                              className="boxT1"
                                              heading="Charge done"
                                              headingValue={`${bookingsData?.charging_data?.charging_done} kWH`}
                                              subValue={`@$${bookingsData?.charging_data.service_charge}`}
                                              link_val="View charge history"
                                              getData={getChargingHistory}
                                              booking_id={booking_id}
                                            />
                                          </>
                                        ) : (
                                          <>
                                            <BookingCard
                                              className="boxT1"
                                              heading="Charge done"
                                              headingValue={unavailable}
                                              subValue={unavailable}
                                            />
                                          </>
                                        )}
                                        <BookingCard
                                          className="boxT1"
                                          heading="Findings in the car"
                                          headingValue={
                                            findings && findings?.length > 0
                                              ? findings?.length
                                              : "0"
                                          }
                                          link_val="View findings"
                                          getData={viewFindingsinCar}
                                        />
                                      </div>
                                    </div>

                                    <div className="summary">
                                      <div className="YRow pt-8 pb-8 ml-24">
                                        <div className="boxT1">
                                          <h4>
                                            Bill summary
                                            <span
                                              style={{ cursor: "pointer" }}
                                              onClick={(e) =>
                                                downloadInvoice(
                                                  e,
                                                  bookingsData?.booking_info
                                                    ?.order_id
                                                )
                                              }
                                              class="sds"
                                            >
                                              <a>
                                                <i class="material-symbols-rounded mt-m">
                                                  download
                                                </i>
                                                Download invoice
                                              </a>
                                            </span>
                                          </h4>
                                          <div className="listRow">
                                            <p>
                                              <span>Total charge</span>

                                              <span>
                                                {bookingsData?.charging_data
                                                  ?.charging_cost ? (
                                                  bookingsData?.charging_data
                                                    ?.charging_cost
                                                ) : (
                                                  <>{unavailable}</>
                                                )}
                                              </span>
                                            </p>
                                          </div>
                                          <div className="listRow">
                                            <h5>Add-ons</h5>

                                            {bookingsData?.booking_add_ons ? (
                                              bookingsData?.booking_add_ons.map(
                                                (bookingAddOnsData) => {
                                                  const {
                                                    service_charge,
                                                    service_name,
                                                    service_status,
                                                  } = bookingAddOnsData;
                                                  return service_status !==
                                                    "6" ? (
                                                    <>
                                                      <p>
                                                        <span>
                                                          {service_name !== null
                                                            ? service_name
                                                            : unavailable}
                                                        </span>
                                                        <span>
                                                          {service_charge !==
                                                          null ? (
                                                            service_charge !=
                                                            "0.00" ? (
                                                              "$" +
                                                              service_charge
                                                            ) : (
                                                              "Free"
                                                            )
                                                          ) : (
                                                            <>{unavailable}</>
                                                          )}
                                                        </span>
                                                      </p>
                                                    </>
                                                  ) : (
                                                    <></>
                                                  );
                                                }
                                              )
                                            ) : (
                                              <>{unavailable}</>
                                            )}
                                          </div>
                                          <div className="listRow">
                                            <h5>Surcharge</h5>
                                            <p>
                                              <span>Service charge</span>

                                              <span>
                                                {bookingsData?.booking_info
                                                  ?.service_cost != "0.00"
                                                  ? "$" +
                                                    bookingsData?.booking_info
                                                      ?.service_cost
                                                  : "Free"}
                                              </span>
                                            </p>
                                            <p>
                                              <span>Parking charge</span>
                                              <span>
                                                {bookingsData?.booking_info
                                                  ?.parking_fee != "0.00"
                                                  ? "$" +
                                                    bookingsData?.booking_info
                                                      ?.parking_fee
                                                  : "Free"}
                                              </span>
                                            </p>
                                          </div>
                                          <div className="listRow">
                                            <h5>Expense</h5>
                                            <p>
                                              <span>
                                                Parking paid by driver
                                                {bookingsData?.booking_info
                                                  ?.parking_paid_by_driver !==
                                                  undefined &&
                                                  parseInt(
                                                    bookingsData?.booking_info
                                                      ?.parking_paid_by_driver
                                                  ) > 0 && (
                                                    <a
                                                      style={{
                                                        cursor: "pointer",
                                                      }}
                                                      class="ml-4 open_model"
                                                      data-target="aFindingsPGalleryP"
                                                      onClick={() => {
                                                        viewParkingPhoto(
                                                          booking_id
                                                        );
                                                      }}
                                                    >
                                                      View photo
                                                    </a>
                                                  )}
                                              </span>

                                              <span>
                                                {bookingsData?.booking_info
                                                  ?.parking_paid_by_driver !==
                                                  undefined &&
                                                parseInt(
                                                  bookingsData?.booking_info
                                                    ?.parking_paid_by_driver
                                                ) > 0
                                                  ? "$" +
                                                    bookingsData?.booking_info
                                                      ?.parking_paid_by_driver
                                                  : "Free"}
                                              </span>
                                            </p>
                                          </div>
                                          <div className="listRow">
                                            <p>
                                              <span>
                                                <b>GST</b>
                                              </span>
                                              <span>
                                                <a>{`$${bookingsData?.booking_info?.gst_cost}`}</a>
                                              </span>
                                            </p>
                                          </div>
                                          <div className="listRow">
                                            <p>
                                              <span>
                                                <b>Credits used</b>
                                              </span>
                                              <span>
                                                <a>{`$${bookingsData?.booking_info?.cb_used}`}</a>
                                              </span>
                                            </p>
                                          </div>
                                          <div className="listRow gTotal pad-0 mar-0">
                                            <p>
                                              <span>Total bill paid</span>
                                              <span>
                                                $
                                                {
                                                  bookingsData?.booking_info
                                                    ?.total
                                                }
                                              </span>
                                            </p>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </td>
                              </tr>
                            </>
                          ) : (
                            <></>
                          )}
                        </React.Fragment>
                      );
                    } else {
                      return (
                        <React.Fragment key={i}>
                          <tr
                            onClick={(e) => handleExpand(e, booking_id)}
                            id={i}
                            style={{ cursor: "pointer" }}
                          >
                            <td className="vName">
                              <span>
                                {bookingsData?.vehicle_info?.brand_name
                                  ? bookingsData?.vehicle_info?.brand_name
                                  : unavailable}
                              </span>
                              <span>
                                {bookingsData?.vehicle_info?.registration_no
                                  ? bookingsData?.vehicle_info?.registration_no
                                  : unavailable}
                              </span>
                            </td>
                            <td>
                              {FormatDate(
                                bookingsData.booking_info.booking_slot
                              )}
                            </td>
                            {bookingsData?.user_profile_data ? (
                              <>
                                <td>{`${
                                  bookingsData?.user_profile_data?.firstname
                                    ? bookingsData?.user_profile_data
                                        ?.firstname +
                                      " " +
                                      bookingsData?.user_profile_data?.lastname
                                    : unavailable
                                }`}</td>
                                <td>
                                  {bookingsData?.user_profile_data?.address
                                    ? bookingsData?.user_profile_data?.address
                                    : unavailable}
                                </td>
                              </>
                            ) : (
                              <>
                                <td>{unavailable}</td>
                                <td>{unavailable}</td>
                              </>
                            )}
                            {bookingsData?.booking_add_ons ? (
                              bookingsData?.booking_add_ons.map(
                                (bookingAddOnsData, index) => {
                                  bookingAddOnsData?.service_name &&
                                  bookingAddOnsData.service_status !== "6" ? (
                                    <>
                                      {
                                        (addOns =
                                          addOns +
                                          bookingAddOnsData?.service_name +
                                          ",")
                                        // bookingAddOnsData?.service_name
                                      }
                                    </>
                                  ) : (
                                    <>{unavailable}</>
                                  );
                                }
                              )
                            ) : (
                              <></>
                            )}

                            <td>
                              {addOns
                                ? addOns.substring(0, addOns.length - 1)
                                : unavailable}
                            </td>
                            {bookingsData?.driver_details ? (
                              <td>
                                <Link to="">{`${
                                  bookingsData?.driver_details?.firstname
                                    ? bookingsData?.driver_details?.firstname +
                                      " " +
                                      bookingsData?.driver_details?.lastname
                                    : unavailable
                                }`}</Link>
                              </td>
                            ) : (
                              <td>
                                <Link to="">{unavailable}</Link>
                              </td>
                            )}

                            <td>
                              {`$${bookingsData?.booking_info?.total}`}
                              {order_id > 0 && order_status == "F" && (
                                <div>
                                  <a
                                    class="error open_model"
                                    data-target="paymentDoneP"
                                    onClick={(e) => {
                                      handleClick(
                                        e,
                                        i,
                                        booking_id,
                                        booking_slot,
                                        user_firstname,
                                        user_lastname,
                                        user_vehicle_no,
                                        driver_firstname,
                                        driver_lastname,
                                        driver_vehicle_no
                                      );
                                    }}
                                  >
                                    Pending
                                  </a>
                                </div>
                              )}
                            </td>
                            {toggle[i] ? (
                              <td
                                style={{ cursor: "pointer" }}
                                className="right"
                              >
                                <i
                                  id={i}
                                  className="material-symbols-rounded arrowTop mt-l"
                                >
                                  expand_more
                                </i>
                                {/* {order_id != "0" && order_status == "F" && <a onClick={(e) => { handleClick(e, i, booking_id, booking_slot, user_firstname, user_lastname, user_vehicle_no, driver_firstname, driver_lastname, driver_vehicle_no) }}>Mark payment done</a>} */}
                              </td>
                            ) : (
                              <td
                                style={{ cursor: "pointer" }}
                                className="right"
                              >
                                <i
                                  id={i}
                                  className="material-symbols-rounded arrowBottom mt-l"
                                >
                                  expand_more
                                </i>
                              </td>
                            )}
                          </tr>
                          {toggle[i] ? (
                            <>
                              {findingpopup && (
                                <FindingsPopUp
                                  closefindDatapopup={closefindDatapopup}
                                  vehicle_registration_no={
                                    vehicle_registration_no
                                  }
                                  vehicle_brand={vehicle_brand}
                                  vehicle_model={vehicle_model}
                                  package_name={package_name}
                                  findings={findings}
                                  variant_image={variant_image}
                                  setOpenImage={setOpenImage}
                                  openImage={openImage}
                                  imageData={imageData}
                                  setimageData={setimageData}
                                />
                              )}

                              {showJobDetails && (
                                <JobDetails
                                  jobData={bookingsData?.booking_add_ons}
                                  vehicle_registration_no={
                                    vehicle_registration_no
                                  }
                                  package_name={package_name}
                                  vehicle_brand={vehicle_brand}
                                  vehicle_model={vehicle_model}
                                  variant_image={variant_image}
                                  jobHistory={jobHistory}
                                  closeJobDetails={closeJobDetails}
                                  setOpenImage={setOpenImage}
                                  openImage={openImage}
                                  imageData={imageData}
                                  setimageData={setimageData}
                                  booking_type={bookingType}
                                />
                              )}

                              {showchargeHistory && (
                                <ViewChargeHistory
                                  vehicle_registration_no={
                                    vehicle_registration_no
                                  }
                                  package_name={package_name}
                                  vehicle_brand={vehicle_brand}
                                  vehicle_model={vehicle_model}
                                  variant_image={variant_image}
                                  activityLog={activityLog}
                                  onBackdropClick={onBackdropClick}
                                  setOpenImage={setOpenImage}
                                  openImage={openImage}
                                  imageData={imageData}
                                  setimageData={setimageData}
                                />
                              )}
                              <tr className="expanded">
                                <td colspan="8">
                                  <div className="vehicleBill">
                                    <div className="time">
                                      <div className="YRow pt-8 pb-8">
                                        <BookingCard
                                          className="boxT1"
                                          heading="Plan"
                                          headingValue={
                                            planInfo()
                                            // bookingsData?.package_info
                                            //   ?.package_type_id !== "1"
                                            //   ? planInfo()
                                            //     ? planInfo()
                                            //     : unavailable
                                            //   : "Pay-As-You-Go"
                                          }
                                          subValue=""
                                        />
                                        <BookingCard
                                          className="boxT1"
                                          heading="Driver Time"
                                          headingValue={""}
                                          subValue={
                                            bookingsData?.booking_info
                                              ?.driver_assigned_on
                                              ? `${Time(
                                                  bookingsData?.booking_info
                                                    ?.driver_assigned_on
                                                )} - ${Time(
                                                  bookingsData?.booking_info
                                                    ?.driver_reached_on
                                                )}`
                                              : "N/A"
                                          }
                                        />
                                        <BookingCard
                                          className="boxT1"
                                          heading="Job Time"
                                          headingValue={""}
                                          link_val="View job photos"
                                          getData={getJobDetails}
                                          booking_id={booking_id}
                                          subValue={
                                            bookingsData?.booking_info
                                              ?.job_started
                                              ? `
                                    ${Time(
                                      bookingsData?.booking_info?.job_started
                                    )} - ${Time(
                                                  bookingsData?.booking_info
                                                    ?.job_done
                                                )}`
                                              : "N/A"
                                          }
                                        />

                                        {bookingsData.charging_data ? (
                                          <>
                                            <BookingCard
                                              className="boxT1"
                                              heading="Charge done"
                                              headingValue={`${bookingsData?.charging_data?.charging_done} kWH`}
                                              subValue={`@$${bookingsData?.charging_data.service_charge}`}
                                              link_val="View charge history"
                                              getData={getChargingHistory}
                                              booking_id={booking_id}
                                            />
                                          </>
                                        ) : (
                                          <>
                                            <BookingCard
                                              className="boxT1"
                                              heading="Charge done"
                                              headingValue={unavailable}
                                              subValue={unavailable}
                                            />
                                          </>
                                        )}
                                        <BookingCard
                                          className="boxT1"
                                          heading="Findings in the car"
                                          headingValue={
                                            findings && findings?.length > 0
                                              ? findings?.length
                                              : "0"
                                          }
                                          link_val="View findings"
                                          getData={viewFindingsinCar}
                                        />
                                      </div>
                                    </div>

                                    <div className="summary">
                                      <div className="YRow pt-8 pb-8 ml-24">
                                        <div className="boxT1">
                                          <h4>
                                            Bill summary
                                            <span
                                              style={{ cursor: "pointer" }}
                                              onClick={(e) =>
                                                downloadInvoice(
                                                  e,
                                                  bookingsData?.booking_info
                                                    ?.order_id
                                                )
                                              }
                                              class="sds"
                                            >
                                              <a>
                                                <i class="material-symbols-rounded mt-m">
                                                  download
                                                </i>
                                                Download invoice
                                              </a>
                                            </span>
                                          </h4>
                                          <div className="listRow">
                                            <p>
                                              <span>Total charge</span>

                                              <span>
                                                {bookingsData?.charging_data
                                                  ?.charging_cost ? (
                                                  bookingsData?.charging_data
                                                    ?.charging_cost
                                                ) : (
                                                  <>{unavailable}</>
                                                )}
                                              </span>
                                            </p>
                                          </div>
                                          <div className="listRow">
                                            <h5>Add-ons</h5>

                                            {bookingsData?.booking_add_ons ? (
                                              bookingsData?.booking_add_ons.map(
                                                (bookingAddOnsData) => {
                                                  const {
                                                    service_charge,
                                                    service_name,
                                                    service_status,
                                                  } = bookingAddOnsData;
                                                  return service_status !==
                                                    "6" ? (
                                                    <>
                                                      <p>
                                                        <span>
                                                          {service_name !== null
                                                            ? service_name
                                                            : unavailable}
                                                        </span>
                                                        <span>
                                                          {service_charge !==
                                                          null ? (
                                                            service_charge !=
                                                            "0.00" ? (
                                                              "$" +
                                                              service_charge
                                                            ) : (
                                                              "Free"
                                                            )
                                                          ) : (
                                                            <>{unavailable}</>
                                                          )}
                                                        </span>
                                                      </p>
                                                    </>
                                                  ) : (
                                                    <></>
                                                  );
                                                }
                                              )
                                            ) : (
                                              <>{unavailable}</>
                                            )}
                                          </div>
                                          <div className="listRow">
                                            <h5>Surcharge</h5>
                                            <p>
                                              <span>Service charge</span>

                                              <span>
                                                {bookingsData?.booking_info
                                                  ?.service_cost != "0.00"
                                                  ? "$" +
                                                    bookingsData?.booking_info
                                                      ?.service_cost
                                                  : "Free"}
                                              </span>
                                            </p>
                                            <p>
                                              <span>Parking charge</span>
                                              <span>
                                                {bookingsData?.booking_info
                                                  ?.parking_fee != "0.00"
                                                  ? "$" +
                                                    bookingsData?.booking_info
                                                      ?.parking_fee
                                                  : "Free"}
                                              </span>
                                            </p>
                                          </div>
                                          <div className="listRow">
                                            <h5>Expense</h5>
                                            <p>
                                              <span>
                                                Parking paid by driver
                                                {bookingsData?.booking_info
                                                  ?.parking_paid_by_driver !==
                                                  undefined &&
                                                  parseInt(
                                                    bookingsData?.booking_info
                                                      ?.parking_paid_by_driver
                                                  ) > 0 && (
                                                    <a
                                                      style={{
                                                        cursor: "pointer",
                                                      }}
                                                      class="ml-4 open_model"
                                                      data-target="aFindingsPGalleryP"
                                                      onClick={() => {
                                                        viewParkingPhoto(
                                                          booking_id
                                                        );
                                                      }}
                                                    >
                                                      View photo
                                                    </a>
                                                  )}
                                              </span>

                                              <span>
                                                {bookingsData?.booking_info
                                                  ?.parking_paid_by_driver !==
                                                  undefined &&
                                                parseInt(
                                                  bookingsData?.booking_info
                                                    ?.parking_paid_by_driver
                                                ) > 0
                                                  ? "$" +
                                                    bookingsData?.booking_info
                                                      ?.parking_paid_by_driver
                                                  : "Free"}
                                              </span>
                                            </p>
                                          </div>
                                          <div className="listRow">
                                            <p>
                                              <span>
                                                <b>GST</b>
                                              </span>
                                              <span>
                                                <a>{`$${bookingsData?.booking_info?.gst_cost}`}</a>
                                              </span>
                                            </p>
                                          </div>
                                          <div className="listRow">
                                            <p>
                                              <span>
                                                <b>Credits used</b>
                                              </span>
                                              <span>
                                                <a>{`$${bookingsData?.booking_info?.cb_used}`}</a>
                                              </span>
                                            </p>
                                          </div>
                                          <div className="listRow gTotal pad-0 mar-0">
                                            <p>
                                              <span>Total bill paid</span>
                                              <span>
                                                $
                                                {
                                                  bookingsData?.booking_info
                                                    ?.total
                                                }
                                              </span>
                                            </p>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </td>
                              </tr>
                            </>
                          ) : (
                            <></>
                          )}
                        </React.Fragment>
                      );
                    }
                  })}
                </>
              ) : (
                <></>
              )}
            </tbody>
          </table>
        </div>
      ) : (
        <DataNotFound message="no priviliges" />
      )}
      <Pagination
        currentPage={currentPage}
        usersPerPage={usersPerPage}
        setUsersPerPage={setUsersPerPage}
        setCurrentPage={setCurrentPage}
        total_records={total_records}
        paginate={paginate}
      />
    </>
  ) : (
    <DataNotFound />
  );
};

export default PastBookings;
