import React, { useState, useEffect } from "react";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import { Params, useParams } from "react-router-dom";
import Spinner from "../UI/Spinner";
import useHttp from "../../hooks/useHttp";
import usePaginate from "../../hooks/usePaginate";
import Loading from "../UI/Loading";
import NoData from "../UI/NoData";
import DataNotFound from "../UI/DataNotFound";
import useAuth from "../../hooks/useAuth";
const PersonalDetails = () => {
  const axiosPrivate = useAxiosIntercept();
  const { auth } = useAuth();
  const [loading, isloading] = useState(false);
  const [personalDetails, setPersonalDetails] = useState("");
  const [hasMore, setHasMore] = useState(false);
  const [total_records, setTotalRecords] = useState(0);
  //const [success, setSuccess] = useState(false);
  const [pageNumber, setPageNumber] = useState(1);
  const params = useParams();
  const user_id = params.user_id;
  const perPageLimit = 10;
  const url = process.env.REACT_APP_GET_PERSONAL_DETAILS+`&user_id=${user_id}&page=${pageNumber}&limit=${perPageLimit}`;

  // useEffect(() => {
  //   let isMounted = true;
  //   const controller = new AbortController();
  //   const getPersonalDetails = async () => {
  //     isLoading(true);
  //     try {
  //       const URL = process.env.REACT_APP_GET_PERSONAL_DETAILS;
  //       const response = await axiosPrivate.get(URL + `&user_id=${user_id}`, {
  //         signal: controller.signal,
  //       });

  //       //console.log("jkjkj",response?.data?.response?.data?.user_profiles_info);
  //       isMounted &&
  //         setPersonalDetails(
  //           response?.data?.response?.data?.user_profiles_info
  //         );
  //       isLoading(false);
  //     } catch (err) {
  //       isLoading(false);
  //       console.log(err);
  //     }
  //   };
  //   getPersonalDetails();

  //   return () => {
  //     isMounted = false;
  //     controller.abort();
  //   };
  // }, []);
  

  const { isLoading, sendRequest: getusers } = useHttp();

  const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);
 
  useEffect(() => {
    const setSearchedusers = (searchedUsers) => {
      const { data } = searchedUsers?.data?.response;
   
      if (data?.user_profiles_info && data?.user_profiles_info.length > 0) {
        setPersonalDetails((prev) => {
          return [...new Set([...prev, ...data?.user_profiles_info])];
        });
        setTotalRecords(data?.total_records);
      } else {
        setPersonalDetails({});
      }

      if (data?.total_records == data?.user_profiles_info?.length) {
        setHasMore(false);
      } else {
        setHasMore(searchedUsers.data.response.data?.user_profiles_info.length > 0);
      }
    };
    if (
      pageNumber == 1 ||
      Math.ceil(parseInt(total_records) / perPageLimit) >= pageNumber
    ) {
      getusers(
        {
          url,
        },
        setSearchedusers
      );
    }
  }, [url, pageNumber, getusers]);

  return (
   
   <> 
    {
      personalDetails.length==""?(<Spinner/>):Object.keys(personalDetails).length !== 0?
      (
      auth.priviliges.includes("read_customer_profile")?
      <div className="addressLists">
            <h5 className="mb-16">Saved address</h5>
            <div class="boxT1">
              <ul>
                {personalDetails.map((details,i) => {
                
                  if(personalDetails.length==i+1)
                  {
                 
                    return (
                      <>
                        <li ref={lastElementRef}>
                          <p>{details.firstname + " " + details.lastname}</p>
                          {details.address_2 ? (
                            <>
                              <span>
                                {details.address + " " + details.address_2}
                              </span>
                            </>
                          ) : (
                            <>
                              <span>{details.address}</span>
                            </>
                          )}
                          <br></br>
                          <span>{details.phone}</span>
                        </li>
                      </>
                    );
                  }
                  else{
                
                    return (
                      <>
                        <li>

                          <p>{details.firstname + " " + details.lastname}</p>
                          {details.address_2 ? (
                            <>
                              <span>
                                {details.address + " " + details.address_2}
                              </span>
                            </>
                          ) : (
                            <>
                              <span>{details.address}</span>
                            </>
                          )}
                          <br></br>
                          <span>{details.phone}</span>
                        </li>
                      </>
                    );
                  }
                 
                })}
              </ul>
            </div>
          </div>:<><DataNotFound message="no priviliges"/></>
      ):(
      
        <DataNotFound/>
      )
    }
    <div>{isLoading && pageNumber != 1 && <Loading/>}</div>
     {pageNumber != "1" && pageNumber > Math.ceil(total_records / perPageLimit) && (<NoData/>)}
      
    </> 
     
  );
};

export default PersonalDetails;
