import React from 'react'
import moment from 'moment'
import Image from '../UI/Image'

import { batteryColorClass } from '../../configuration/PuppyBatteryCapacityClass'
export default function PuppyAndAttendantDetails({ booking_note, driver_firstname, driver_lastname, driver_phone_number, puppy_registration_no, charging, address1, address2, driver_image, bookingstatus, puppystatus,
  driver_reaching_time, battery_percentage, current_location
}) {
  {

  }
  const reached_time = moment(driver_reaching_time).format("hh:mm A");

  return (
    <div class="puppyDetails">
      <div class="wrap">
        <div class="">
          <h5>Attendant details</h5>
          <div class="userInfo">
            <div class="imgBlock">
              <div>
                <Image userImage={driver_image} name={driver_firstname} />
              </div>
            </div>
            <div class="name">
              <span>{driver_firstname + " " + driver_lastname}</span>
              <span>{driver_phone_number}</span>
            </div>
          </div>
        </div>
        <div class="pDetail">
          <h5>Puppy details</h5>
          <div class="battery">
            <span>{puppy_registration_no ? puppy_registration_no : "N/A"}</span>
            <div class="tagsList">
              {charging ? (<>
                <span class={batteryColorClass(battery_percentage)}>
                  <i class="material-symbols-rounded mt-s">battery_5_bar</i>
                  {charging} kWh left
                </span>
              </>) : "N/A"}

            </div>
          </div>
          {current_location && <div class="liveLocation">
            <p>
              <i class="material-symbols-rounded mt-m grey">
                my_location
              </i>
              <span>{current_location}</span>
            </p>
          </div>}

        </div>
      </div>
      {booking_note && (
        <section class="noteTxt">
          <i class="material-symbols-rounded mt-m grey">sticky_note_2</i>
          <p>
            <span>Note from customer:</span> {booking_note}
          </p>
        </section>
      )}

      {puppystatus == "R" || bookingstatus == "I" ? (
        <>
          <div class="reachedLocation mt-24">
            <p>
              Reached at <b>{"" + reached_time}</b>
            </p>
            <span>{address1}</span>
            <span>{address2}</span>
          </div>
        </>
      ) : (
        ""
      )}

      {/* <div class="reachedLocation mt-24">
        <p>
          Reached at <b>09:32 am</b>
        </p>
        <span>{address1}</span>
        <span>{address2}</span>
      </div> */}
    </div>
  );
}
