import React, { useEffect, useState } from "react";
import { Time } from "../../utils/Time";
import { FormatDate } from "../../utils/FormatDate";
import UpcomingBookingDetails from "./UpcomingBookingDetails";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import Pagination from "./Pagination";
import moment from "moment";
import Spinner from "../UI/Spinner";
import { puppy_assigned_duration } from "../../configuration/GlobalConfig";
import DataNotFound from "../UI/DataNotFound";
import useAuth from "../../hooks/useAuth";
import NoPriviliges from "../UI/NoPriviliges";

const UpComingBookings = ({
  upComingBookingData,
  setupcomingBookings,
  userImage,
  total_records,
  currentPage,
  setCurrentPage,
  usersPerPage,
  setUsersPerPage,
  isAttendantChanged,
  setisAttendantChanged,
  isPuppyChanged,
  setisPuppyChanged,
  paginate,
  lastElementRef,
  isCancelled,
  setisCancelled
}) => {
  let currentDate = new Date();
  const { auth } = useAuth();
  currentDate = moment(currentDate).format("D MMMM");
  const axiosPrivate = useAxiosIntercept();
  const [bookingData, setBookingData] = useState(0);
  //const [currentPage, setCurrentPage] = useState(1);
  //const [usersPerPage, setUsersPerPage] = useState(5);

  const [eventInitiated, setEventInitiated] = useState(false);
  const [isSelected, setIsSelected] = useState(0);
  const handleClick = (e, index) => {
    setIsSelected(index);

    var singleBookingData = index;
    setBookingData(singleBookingData);
  };
  const removeBooking = (booking_index) => {
    if (booking_index !== -1) {
      const currentbookingdetails = [...upComingBookingData];
      currentbookingdetails.splice(booking_index, 1);
      setupcomingBookings(currentbookingdetails);
    }
  };

  return upComingBookingData == "" ? (
    <Spinner />
  ) : Object.keys(upComingBookingData).length !== 0 ? (
    auth.priviliges.includes("read_bookings") ?
      <div class="bookingsData">
        <div class="bTimings customScroll">
          {upComingBookingData?.length !== 0 ? (
            <>
              {upComingBookingData.map((bookingdata, i) => {
                const firstname = bookingdata?.user_profile_data?.firstname
                  ? bookingdata?.user_profile_data?.firstname
                  : "Guest";
                const lastname = bookingdata?.user_profile_data?.lastname
                  ? bookingdata?.user_profile_data?.lastname
                  : "";
                const registration_no = bookingdata?.vehicle_info?.registration_no
                  ? bookingdata?.vehicle_info?.registration_no
                  : "N/A";
                const time = Time(bookingdata?.booking_info?.booking_slot);
                const date = bookingdata?.booking_info?.booking_slot
                  ? FormatDate(bookingdata?.booking_info?.booking_slot).split(",")
                  : "";
                const sub_note = bookingdata?.booking_info?.booking_sub_note;
                const puppy_status = bookingdata?.booking_info?.puppy_status;
                const driver_firstname = bookingdata?.driver_details
                  ? bookingdata?.driver_details?.firstname
                  : "N/A";
                const driver_lastname = bookingdata?.driver_details
                  ? bookingdata?.driver_details?.lastname
                  : "N/A";
                const driver_userid = bookingdata?.driver_details?.user_id
                  ? bookingdata?.driver_details?.user_id
                  : "";
                // const puppy_reg_no = bookingData?.driver_details ? bookingData?.driver_details?.registration_no : "N/A";
                const booking_status = bookingdata?.booking_info?.booking_status;
                const booking_status_desc =
                  bookingdata?.booking_info?.booking_status_desc;
                const puppy_registration_no = bookingdata?.puppy_info
                  ? bookingdata?.puppy_info?.registration_no
                  : "N/A";
                const puppy_assigned_time = moment(time, "h:mm A")
                  .subtract("hours", puppy_assigned_duration)
                  .format("h:mm A");

                const vehicle_brand = bookingdata?.vehicle_info?.brand_name
                  ? bookingdata?.vehicle_info?.brand_name
                  : "";
                const vehicle_model = bookingdata?.vehicle_info?.model_name
                  ? bookingdata?.vehicle_info?.model_name
                  : "";
                const vehicle_battery_capacity = bookingdata?.vehicle_info
                  ?.vehicle_battery_capacity
                  ? bookingdata?.vehicle_info?.vehicle_battery_capacity
                  : "";
                const address1 = bookingdata?.user_profile_data?.address
                  ? bookingdata?.user_profile_data?.address
                  : "";
                const address2 = bookingData?.user_profile_data?.address_2
                  ? bookingData?.user_profile_data?.address_2
                  : "";
                const booking_type = bookingdata.booking_info.booking_type;
                if (upComingBookingData.length == i + 1) {
                  return (
                    <div
                      ref={lastElementRef}
                      id={i}
                      onClick={(e) => handleClick(e, i)}
                      class={
                        isSelected === i || (i == "0" && !isSelected)
                          ? "boxT1 fill"
                          : "boxT1 pending"
                      }
                    >
                      <h4>
                        <span>{currentDate == date[0] ? "Today" : date[0]}</span>
                        <i class="elip"></i>
                        <span>{time}</span>
                      </h4>
                      <div className="rowList">
                        <p>
                          <i class="material-symbols-rounded mt-m grey">person</i>
                          <span>{firstname + " " + lastname}</span>
                          <i class="elip"></i>
                          <em>{registration_no}</em>
                        </p>

                        {/* {(booking_status == "N" || booking_status == "R" || booking_status == "T") && driver_userid ?  */}
                        <p class="vDetail">
                          <i class="material-symbols-rounded mt-m white">
                            person
                          </i>
                          <em>{vehicle_brand + " " + vehicle_model}</em>
                          <i class="elip"></i>
                          <em>{vehicle_battery_capacity} kWh</em>
                        </p>
                        {/* : ""} */}
                        {address1 && (
                          <p class="vDetail">
                            <i class="material-symbols-rounded mt-m white">
                              person
                            </i>
                            <em>{address1}</em>
                          </p>
                        )}
                        {address2 && (
                          <p class="vDetail">
                            <i class="material-symbols-rounded mt-m white">
                              person
                            </i>
                            <em>{address2}</em>
                          </p>
                        )}
                      </div>

                      {(booking_status == "N" ||
                        booking_status == "R" ||
                        booking_status == "T") &&
                        driver_userid == "" ? (
                        <div className="rowList">
                          <p class="assignName">
                            <i class="material-symbols-rounded mt-m">
                              airport_shuttle
                            </i>
                            <em>
                              {"Puppy will be assigned by" +
                                " " +
                                puppy_assigned_time}
                            </em>
                          </p>
                        </div>
                      ) : (
                        <div className="rowList">
                          <p class="assignName">
                            <i class="material-symbols-rounded mt-m">
                              airport_shuttle
                            </i>
                            <span>{driver_firstname + " " + driver_lastname}</span>
                            <i class="elip"></i>
                            <em>{puppy_registration_no}</em>
                          </p>
                          {(booking_status == "N" ||
                            booking_status == "R" ||
                            booking_status == "T") &&
                            driver_userid && (
                              <p class="vDetail">
                                <i className="material-symbols-rounded mt-m white">
                                  airport_shuttle
                                </i>
                                <em>
                                  {"Final puppy will be assigned by" +
                                    " " +
                                    puppy_assigned_time}
                                </em>
                              </p>
                            )}
                        </div>
                      )}

                      <div class="tagsList">
                        {booking_type == "normal" &&
                          <span
                            class={
                              isSelected === i || (i == "0" && !isSelected)
                                ? "success"
                                : "pending"
                            }
                          >
                            {booking_status_desc}
                          </span>}
                        {booking_type != "normal" &&
                          <span class="error">Recovery insurance</span>}
                      </div>
                    </div>
                  );
                } else {
                  return (
                    <div
                      id={i}
                      onClick={(e) => handleClick(e, i)}
                      class={
                        isSelected === i || (i == "0" && !isSelected)
                          ? "boxT1 fill"
                          : "boxT1 pending"
                      }
                    >
                      <h4>
                        <span>{currentDate == date[0] ? "Today" : date[0]}</span>
                        <i class="elip"></i>
                        <span>{time}</span>
                      </h4>
                      <div className="rowList">
                        <p>
                          <i class="material-symbols-rounded mt-m grey">person</i>
                          <span>{firstname + " " + lastname}</span>
                          <i class="elip"></i>
                          <em>{registration_no}</em>
                        </p>

                        {/* {(booking_status == "N" || booking_status == "R" || booking_status == "T") && driver_userid ?  */}
                        <p class="vDetail">
                          <i class="material-symbols-rounded mt-m white">
                            person
                          </i>
                          <em>{vehicle_brand + " " + vehicle_model}</em>
                          <i class="elip"></i>
                          <em>{vehicle_battery_capacity} kWh</em>
                        </p>
                        {/* : ""} */}
                        {address1 && (
                          <p class="vDetail">
                            <i class="material-symbols-rounded mt-m white">
                              person
                            </i>
                            <em>{address1}</em>
                          </p>
                        )}
                        {address2 && (
                          <p class="vDetail">
                            <i class="material-symbols-rounded mt-m white">
                              person
                            </i>
                            <em>{address2}</em>
                          </p>
                        )}
                      </div>

                      {(booking_status == "N" ||
                        booking_status == "R" ||
                        booking_status == "T") &&
                        driver_userid == "" ? (
                        <div className="rowList">
                          <p class="assignName">
                            <i class="material-symbols-rounded mt-m">
                              airport_shuttle
                            </i>
                            <em>
                              {"Puppy will be assigned by" +
                                " " +
                                puppy_assigned_time}
                            </em>
                          </p>
                        </div>
                      ) : (
                        <div className="rowList">
                          <p class="assignName">
                            <i class="material-symbols-rounded mt-m">
                              airport_shuttle
                            </i>
                            <span>{driver_firstname + " " + driver_lastname}</span>
                            <i class="elip"></i>
                            <em>{puppy_registration_no}</em>
                          </p>
                          {(booking_status == "N" ||
                            booking_status == "R" ||
                            booking_status == "T") &&
                            driver_userid && (
                              <p class="vDetail">
                                <i className="material-symbols-rounded mt-m white">
                                  airport_shuttle
                                </i>
                                <em>
                                  {"Final puppy will be assigned by" +
                                    " " +
                                    puppy_assigned_time}
                                </em>
                              </p>
                            )}
                        </div>
                      )}

                      <div class="tagsList">
                        {booking_type=="normal"&&
                        <span
                          class={
                            isSelected === i || (i == "0" && !isSelected)
                              ? "success"
                              : "pending"
                          }
                        >
                          {booking_status_desc}
                        </span>}
                        {booking_type != "normal" &&
                          <span class="error">Recovery insurance</span>}
                      </div>
                    </div>
                  );
                }
              })}
            </>
          ) : (
            <></>
          )}
          <Pagination
            currentPage={currentPage}
            usersPerPage={usersPerPage}
            setUsersPerPage={setUsersPerPage}
            setCurrentPage={setCurrentPage}
            eventInitiated={eventInitiated}
            total_records={total_records}
            paginate={paginate}
          />
        </div>

        {upComingBookingData.length > 0 && (
          <UpcomingBookingDetails
            bookingData={upComingBookingData[bookingData]}
            index={bookingData}
            removeBooking={removeBooking}
            userImage={userImage}
            isAttendantChanged={isAttendantChanged}
            isPuppyChanged={isPuppyChanged}
            setisPuppyChanged={setisPuppyChanged}
            setisAttendantChanged={setisAttendantChanged}
            upComingBookingData={upComingBookingData}
            setupcomingBookings={setupcomingBookings}
            isCancelled={isCancelled}
            setisCancelled={setisCancelled}
          />
        )}
      </div> : <NoPriviliges message="no priviliges" />
  ) : (
    <DataNotFound />
  );
};

export default UpComingBookings;
