import React from "react";
import { useEffect } from "react";
import { useState } from "react";
import { Link } from "react-router-dom";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import { FormatDate } from "../../utils/FormatDate";
import { JobStatus } from "../Package/addonsStatusConfig";
import { addonsIcon } from "../Package/addonsStatusConfig";
import Map from "./Map";
import BatteryStatus from "./BatteryStatus";
import PuppyAssigned from "./PuppyAssigned";
import PuppyAndAttendantDetails from "./PuppyAndAttendantDetails";
import CancelBooking from "../../utils/CancelBooking";
import { Time } from "../../utils/Time";
import Image from "../UI/Image";
import FindingsPopUp from "./FindingsPopUp";
import JobDetails from "./JobDetails";
import moment from "moment";
import ChangeAttendant from "../Bookings/ChangeAttendant";
import ChangePuppy from "../Bookings/ChangePuppy";
import ImagePopUp from "../../utils/ImagePopUp";
import {
  puppy_assigned_duration,
  unavailable,
} from "../../configuration/GlobalConfig";

export default function UpcomingBookingDetails({
  bookingData,
  index,
  removeBooking,
  userImage,
  isAttendantChanged,
  isPuppyChanged,
  setisPuppyChanged,
  setisAttendantChanged,
  upComingBookingData,
  setupcomingBookings,
  setisCancelled,

  isCancelled,
}) {
  const axiosPrivate = useAxiosIntercept();
  const [findings, setfindings] = useState();
  const [changeAttendantPopup, setchangeAttendantpopup] = useState(false);
  const [changePuppyPopup, setchangePuppyPopup] = useState(false);
  const [attendantList, setAttendantList] = useState("");
  const [puppyList, setpuppyList] = useState("");

  const [showpopup, setshowpopup] = useState(false);
  const [showJobDetails, setShowJobDetails] = useState(false);
  const [findingpopup, setfindingpopup] = useState(false);
  const [cancellationReason, setCancellationReasns] = useState();
  const pup_id = bookingData?.booking_info?.pup_id;
  const booking_note = bookingData?.booking_info?.booking_note
    ? bookingData?.booking_info?.booking_note
    : "";
  const user_firstname = bookingData?.user_profile_data?.firstname
    ? bookingData?.user_profile_data?.firstname
    : "";
  const user_lastname = bookingData?.user_profile_data?.firstname
    ? bookingData?.user_profile_data?.lastname
    : "";
  const user_phone = bookingData?.user_profile_data?.phone
    ? bookingData?.user_profile_data?.phone
    : "";
  const package_name = bookingData?.package_info?.package_name
    ? bookingData?.package_info?.package_name
    : "";
  const vehicle_registration_no = bookingData?.vehicle_info?.registration_no
    ? bookingData?.vehicle_info?.registration_no
    : "";
  const vehicle_brand = bookingData?.vehicle_info?.brand_name
    ? bookingData?.vehicle_info?.brand_name
    : "";
  const vehicle_model = bookingData?.vehicle_info?.model_name
    ? bookingData?.vehicle_info?.model_name
    : "";
  const addOns = bookingData?.booking_add_ons
    ? bookingData?.booking_add_ons
    : "";
  const service_status_description = bookingData?.booking_add_ons
    ? bookingData?.booking_add_ons?.bookingData?.booking_add_ons
    : "";
  const charge_rate = bookingData?.package_info?.package_charge_rate;
  const booking_created_on = bookingData?.booking_info?.booking_created_on
    ? FormatDate(bookingData?.booking_info?.booking_created_on).split(",")
    : "";
  const booking_id = bookingData?.booking_info?.booking_id;
  const address1 = bookingData?.user_profile_data?.address
    ? bookingData?.user_profile_data?.address
    : "";
  const address2 = bookingData?.user_profile_data?.address_2
    ? bookingData?.user_profile_data?.address_2
    : "";
  const driver_firstname = bookingData?.driver_details?.firstname
    ? bookingData?.driver_details?.firstname
    : "";
  const driver_lastname = bookingData?.driver_details?.lastname
    ? bookingData?.driver_details?.lastname
    : "";
  const driver_phone_number = bookingData?.driver_details?.phone_number
    ? bookingData?.driver_details?.phone_number
    : "";
  const sub_note = bookingData?.booking_info?.booking_sub_note;
  const [registration_no, setregistration_no] = useState();
  const [available_charging_capacity, setavailable_charging_capacity] =
    useState();
  const customerImage = bookingData?.user_profile_data?.user_image
    ? bookingData?.user_profile_data?.user_image
    : "";
  const driver_image = bookingData?.driver_details?.driver_image;
  const latitude = bookingData?.user_profile_data?.latitude
    ? bookingData?.user_profile_data?.latitude
    : "";
  const longitude = bookingData?.user_profile_data?.longitude
    ? bookingData?.user_profile_data?.longitude
    : "";
  const date = bookingData?.booking_info?.booking_slot
    ? FormatDate(bookingData?.booking_info?.booking_slot).split(",")
    : "";
  const time =
    bookingData?.booking_info?.booking_slot &&
    Time(bookingData?.booking_info?.booking_slot);
  const bookingstatus = bookingData?.booking_info?.booking_status;
  const puppystatus = bookingData?.booking_info?.puppy_status;
  const variant_image = bookingData?.vehicle_info?.variant_image;
  const puppy_assigned_time = moment(time, "h:mm A")
    .subtract("hours", puppy_assigned_duration)
    .format("h:mm A");
  const driver_reaching_time = bookingData?.booking_info
    ? bookingData?.booking_info?.driver_reaching_time
    : "";
  const user_id = bookingData?.user_profile_data?.user_id;
  const package_price = bookingData?.package_info?.package_price;
  const battery_percentage =
    bookingData?.puppy_info?.charger_info?.battery_percentage;
  const current_location = bookingData?.puppy_info?.current_location;
  const charging_cost = bookingData?.charging_data?.charging_cost;
  const [jobHistory, setjobHistory] = useState("");
  const [imageData, setimageData] = useState({
    heading: "",
    tabs: "",
    time: "",
    image: "",
    subheading: "",
  });
  const [openImage, setOpenImage] = useState(false);
  const service_charge = bookingData?.package_info?.service_fee
    ? bookingData?.package_info?.service_fee
    : "0";
  const service_fee_without_addon = bookingData?.package_info
    ?.service_fee_without_add_on
    ? bookingData?.package_info?.service_fee_without_add_on
    : "0";
  const booking_slot = bookingData?.booking_info?.booking_slot
    ? bookingData?.booking_info?.booking_slot
    : "";
  const puppy_vehicle_id = bookingData?.puppy_info?.vehicle_id
    ? bookingData?.puppy_info?.vehicle_id
    : "";
  const driver_user_id = bookingData?.driver_details?.user_id
    ? bookingData?.driver_details?.user_id
    : "";

  const registrationNo = bookingData?.puppy_info?.registration_no
    ? bookingData?.puppy_info?.registration_no
    : unavailable;

  const batteryLeft = bookingData?.puppy_info?.charger_info
    ? bookingData?.puppy_info?.charger_info?.available_charging_capacity
      ? bookingData?.puppy_info?.charger_info?.available_charging_capacity
      : ""
    : "";

  const bookingDateTime =
    bookingData?.booking_info?.booking_slot &&
    bookingData?.booking_info?.booking_slot;
  const bookingType = bookingData?.booking_info?.booking_type;
  const bookingDateTimeArray = bookingDateTime && bookingDateTime.split(" ");

  // const getpuppyData = async (driver_id) => {
  //   const URL = process.env.REACT_APP_GET_PUPPY;
  //   const puppyData = await axiosPrivate.get(URL + `&user_id=${driver_id}`);
  //   setregistration_no(
  //     puppyData?.data?.response?.data?.puppy_info?.registration_no
  //   );

  //   setavailable_charging_capacity(
  //     puppyData?.data?.response?.data?.puppy_info?.charger_info
  //       ?.available_charging_capacity
  //   );
  // };

  if (pup_id != 0) {
    const driver_id = bookingData?.driver_details?.user_id;

    // const puppyData = getpuppyData(driver_id);
  }
  const getCancellationReasons = async () => {
    const reasons = await axiosPrivate.get(
      process.env.REACT_APP_BOOKING_CANCELLATION_REASON + `&object_type=B`
    );

    setCancellationReasns(reasons?.data?.response?.data?.cancellation_reasons);

    return;
  };
  const cancelbooking = () => {
    getCancellationReasons();

    setshowpopup(true);
  };
  const onBackdropClick = () => {
    document.body.classList.remove("hidden");
    setshowpopup(false);
  };
  const findingsData = async () => {
    const body = {
      booking_id: booking_id,
    };
    const response = await axiosPrivate.post(
      process.env.REACT_APP_GET_FINDINGS_IN_CAR,
      body
    );
    setfindings(response?.data?.response?.data?.findings);

    //setfindingpopup(true);
  };
  const closefindDatapopup = () => {
    document.body.classList.remove("hidden");
    setfindingpopup(false);
  };

  const closeJobDetails = () => {
    document.body.classList.remove("hidden");
    setShowJobDetails(false);
  };
  const jobDetailsPopUp = async () => {
    const body = {
      booking_id: booking_id,
    };
    const response = await axiosPrivate.post(
      process.env.REACT_APP_GET_SERVICE_HISTORY,
      body
    );
    if (response?.data?.status == "200") {
      setjobHistory(response?.data?.response?.data?.service_log);
    }
    setShowJobDetails(true);
  };
  const showchangeAttendant = async () => {
    setchangeAttendantpopup(true);
    const response = await axiosPrivate.get(
      process.env.REACT_APP_GET_ATTENDANTS_LIST +
        `&slot_data=1&slot_date=${bookingDateTimeArray[0]}&start_time=${bookingDateTimeArray[1]}&limit=1000`
    );
    if (response?.data?.status == "200") {
      setAttendantList(response?.data?.response?.data?.user_info);
    }
  };
  const showchangePuppy = async () => {
    setchangePuppyPopup(true);
    const response = await axiosPrivate.get(
      process.env.REACT_APP_GET_PUPPY_LIST +
        `&slot_data=1&slot_date=${bookingDateTimeArray[0]}&start_time=${bookingDateTimeArray[1]}&limit=1000&show_charger_info=1`
    );
    if (response?.data?.status == "200") {
      setpuppyList(response?.data?.response?.data?.puppy_vehicles);
    }
  };

  useEffect(() => {
    findingsData();
  }, [bookingData]);
  return (
    <>
      {openImage && (
        <ImagePopUp
          imageData={imageData}
          setOpenImage={setOpenImage}
          setimageData={setimageData}
        />
      )}
      {changeAttendantPopup && (
        <ChangeAttendant
          user_firstname={user_firstname}
          user_lastname={user_lastname}
          vehicle_registration_no={vehicle_registration_no}
          driver_firstname={driver_firstname}
          driver_lastname={driver_lastname}
          registration_no={registrationNo}
          date={date}
          time={time}
          attendantList={attendantList}
          setchangeAttendantpopup={setchangeAttendantpopup}
          puppy_vehicle_id={puppy_vehicle_id}
          driver_user_id={driver_user_id}
          booking_slot={booking_slot}
          isAttendantChanged={isAttendantChanged}
          setisAttendantChanged={setisAttendantChanged}
          bookingData={upComingBookingData}
          setbookingData={setupcomingBookings}
          index={index}
          booking_id={booking_id}
        />
      )}
      {changePuppyPopup && (
        <ChangePuppy
          user_firstname={user_firstname}
          user_lastname={user_lastname}
          vehicle_registration_no={vehicle_registration_no}
          driver_firstname={driver_firstname}
          driver_lastname={driver_lastname}
          registration_no={registrationNo}
          date={date}
          time={time}
          setchangePuppyPopup={setchangePuppyPopup}
          puppyList={puppyList}
          puppy_vehicle_id={puppy_vehicle_id}
          driver_user_id={driver_user_id}
          booking_slot={booking_slot}
          isPuppyChanged={isPuppyChanged}
          setisPuppyChanged={setisPuppyChanged}
          bookingData={upComingBookingData}
          setbookingData={setupcomingBookings}
          index={index}
          booking_id={booking_id}
        />
      )}

      {showJobDetails && (
        <JobDetails
          closeJobDetails={closeJobDetails}
          jobData={bookingData?.booking_add_ons}
          vehicle_registration_no={vehicle_registration_no}
          package_name={package_name}
          vehicle_brand={vehicle_brand}
          vehicle_model={vehicle_model}
          variant_image={variant_image}
          jobHistory={jobHistory}
          setOpenImage={setOpenImage}
          openImage={openImage}
          imageData={imageData}
          setimageData={setimageData}
          booking_type={bookingType}
        />
      )}

      {showpopup && (
        <CancelBooking
          onBackdropClick={onBackdropClick}
          setshowpopup={setshowpopup}
          user_firstname={user_firstname}
          user_lastname={user_lastname}
          vehicle_registration_no={vehicle_registration_no}
          driver_firstname={driver_firstname}
          driver_lastname={driver_lastname}
          registration_no={registrationNo}
          cancellationReason={cancellationReason}
          date={date}
          booking_id={booking_id}
          index={index}
          removeBooking={removeBooking}
          time={time}
          user_id={user_id}
          bookingstatus={bookingstatus}
          puppy_assigned_time={puppy_assigned_time}
          isCancelled={isCancelled}
          setisCancelled={setisCancelled}
        />
      )}
      {findingpopup && (
        <FindingsPopUp
          closefindDatapopup={closefindDatapopup}
          vehicle_registration_no={vehicle_registration_no}
          vehicle_brand={vehicle_brand}
          vehicle_model={vehicle_model}
          package_name={package_name}
          findings={findings}
          variant_image={variant_image}
          setOpenImage={setOpenImage}
          openImage={openImage}
          imageData={imageData}
          setimageData={setimageData}
        />
      )}

      <div className="bDetails">
        <div className="boxT1">
          <div className="headWrap">
            <div className="head">
              <h5>Booking details</h5>
              <p>
                <span>{"# " + booking_id}</span>
                <i class="elip"></i>
                <em>Placed on {booking_created_on}</em>
              </p>
            </div>
            <div href="" className="actionNav wBorder ml-24">
              <i className="material-symbols-rounded mt-m grey">more_vert</i>
              <div className="dropMenuWrap">
                <ul className="dropMenu" style={{ width: "180px" }}>
                  <li>
                    {" "}
                    <Link
                      to=""
                      className="open_model"
                      data-target=""
                      onClick={cancelbooking}
                      style={{ color: "#E02727" }}
                    >
                      Cancel booking
                    </Link>{" "}
                  </li>
                  <li>
                    {" "}
                    <Link
                      onClick={showchangeAttendant}
                      class="open_model"
                      data-target="changeAttendantP"
                    >
                      Change attendant
                    </Link>{" "}
                  </li>
                  <li>
                    {" "}
                    <Link
                      onClick={showchangePuppy}
                      class="open_model"
                      data-target="changePuppyP"
                    >
                      Change puppy
                    </Link>{" "}
                  </li>
                </ul>
              </div>
            </div>
          </div>

          <div className="subSection">
            {puppystatus == "N" && (
              <div
                className={
                  bookingType == "rescue"
                    ? "bookingStatus successBG"
                    : "bookingStatus"
                }
              >
                {bookingType == "normal" ? (
                  <p>
                    Time to reach <em>{time}</em>
                  </p>
                ) : (
                  <p>Emergency recovery</p>
                )}

                <span>{address1}</span>
                <span>{address2}</span>
              </div>
            )}
            {puppystatus == "A" && (
              <div
                className={
                  bookingType == "rescue"
                    ? "bookingStatus successBG"
                    : "bookingStatus"
                }
              >
                {bookingType == "normal" ? (
                  <p>
                    Time to reach <em>{time}</em>
                  </p>
                ) : (
                  <p>Emergency recovery</p>
                )}

                <span>{address1}</span>
                <span>{address2}</span>
              </div>
            )}

            {puppystatus == "R" && (
              <BatteryStatus
                bookingstatus={bookingstatus}
                bookingData={bookingData}
                vehicle_registration_no={vehicle_registration_no}
                package_name={package_name}
                vehicle_brand={vehicle_brand}
                vehicle_model={vehicle_model}
                variant_image={variant_image}
                booking_id={booking_id}
                setOpenImage={setOpenImage}
                openImage={openImage}
                imageData={imageData}
                setimageData={setimageData}
              />
            )}
            {puppystatus == "O" && (
              <Map latitude={latitude} longitude={longitude} />
            )}
          </div>

          {puppystatus == "N" && driver_user_id == "" ? (
            <PuppyAssigned
              sub_note={"Puppy will be assigned by" + " " + puppy_assigned_time}
            />
          ) : (
            <></>
          )}

          <div className="subSection">
            <h6>
              Jobs to be done{" "}
              {bookingstatus == "I" && addOns && addOns?.length > "0" && (
                <Link
                  href=""
                  className="open_modelr"
                  data-target="servicesDetailsP"
                  onClick={jobDetailsPopUp}
                >
                  See job details
                </Link>
              )}
            </h6>
            <ul className="servicesLists">
              <li>
                {addOns && addOns?.length > 0
                  ? addOns.map((addon) => {
                      return (
                        <p>
                          <i class="material-symbols-rounded mt-m grey">
                            {addonsIcon[addon.service_id]}
                          </i>
                          <span>
                            <span>{addon.service_name}</span>{" "}
                            <span>(10 mins)</span>
                          </span>
                          <span
                            class={
                              addon.service_status === "5"
                                ? "statusU completed"
                                : "statusU"
                            }
                          >
                            {addon.service_status === "5" && (
                              <i class="material-symbols-rounded mt-s grey fill">
                                check_circle
                              </i>
                            )}

                            <span>
                              {addon?.service_status == "1"
                                ? ""
                                : addon?.service_status == "2"
                                ? "Inprogress"
                                : addon.service_status_description}
                            </span>
                          </span>
                        </p>
                      );
                    })
                  : "No add ons"}
              </li>
            </ul>
          </div>
          {findings && findings?.length > 0 && (
            <div className="subSection">
              <section className="otherFindings">
                <i className="material-symbols-rounded mt-m grey mr-8">
                  sticky_note_2
                </i>
                <div>
                  <h4>Any findings in the car</h4>
                  <p>(eg. found a wallet or fixed a dent)</p>
                </div>
                <i
                  className="material-symbols-rounded grey arrowRight mt-m arrow open_modelr"
                  data-target="aFindingsP"
                  onClick={() => {
                    setfindingpopup(true);
                  }}
                >
                  expand_more
                </i>
              </section>
            </div>
          )}
          {driver_user_id && (
            <div className="subSection">
              <PuppyAndAttendantDetails
                booking_note={booking_note}
                driver_firstname={driver_firstname}
                driver_lastname={driver_lastname}
                driver_phone_number={driver_phone_number}
                puppy_registration_no={registrationNo}
                charging={batteryLeft}
                address1={address1}
                address2={address2}
                driver_image={driver_image}
                bookingstatus={bookingstatus}
                puppystatus={puppystatus}
                driver_reaching_time={driver_reaching_time}
                battery_percentage={battery_percentage}
                current_location={current_location}
              />
            </div>
          )}

          <div className="subSection">
            <h5>Customer details</h5>
            <div className="cDetail">
              <div className="cVehicleInfo">
                <div className="vPackage">
                  <p>
                    {vehicle_registration_no}
                    <span>{package_name}</span>
                  </p>
                  <p className="vName">
                    {vehicle_brand}
                    {vehicle_model && `-${vehicle_model}`}
                  </p>
                </div>
                <div className="vImg">
                  <img src={variant_image} alt="" />
                </div>
              </div>
              <div className="userInfo mt-16">
                <div className="imgBlock">
                  <div>
                    <Image userImage={customerImage} name={user_firstname} />
                  </div>
                </div>
                <div className="name">
                  <span>{user_firstname + " " + user_lastname}</span>
                  <span>{user_phone}</span>
                </div>
              </div>
            </div>
          </div>
          {/*  */}
          <div className="subSection">
            <h5>Bill details</h5>
            <div className="billDetail">
              {package_name && (
                <p>
                  <span>{package_name}</span>
                  <span>{"$" + parseInt(package_price)}</span>
                </p>
              )}

              <p>
                <span>
                  Charge rate
                  {charge_rate?.slice(2, 3) == "0" ? "" : " @" + charge_rate}
                </span>
                {charge_rate?.slice(2, 3) === "0" ? (
                  <span>Unlimited</span>
                ) : (
                  <span>$ {charging_cost}</span>
                )}
                {/* <span>{"$" + charge_rate}</span> */}
              </p>
              {addOns?.length > 0
                ? addOns.map((addon) => {
                    return (
                      <>
                        {addon?.service_status == "6" ? (
                          ""
                        ) : (
                          <p>
                            <span>{addon.service_name}</span>
                            <span
                              className={
                                addon?.service_charge == "0.00" ? "success" : ""
                              }
                            >
                              {addon?.service_charge > 0
                                ? "$" + parseInt(addon.service_charge)
                                : "Free"}
                            </span>
                          </p>
                        )}
                      </>
                    );
                  })
                : ""}
              <p>
                <span>Service charge</span>
                <span>
                  {addOns && addOns?.length > 0
                    ? "$" + service_charge
                    : "$" + service_fee_without_addon}
                </span>
              </p>

              <p className="gTotal" style={{ borderBottom: "0" }}>
                <span>Total bill till now</span>
                <span>To be Calculated</span>
              </p>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}
