import React, { useState, useEffect } from "react";
import { useLocation, useParams, Link } from "react-router-dom";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import CustomerPlanData from "./CustomerPlanData";
import PlanData from "./CustomerPlanData";
import SecondaryData from "./SecondaryData";
import Spinner from "../UI/Spinner";
import useHttp from "../../hooks/useHttp";
import usePaginate from "../../hooks/usePaginate";
import Loading from "../UI/Loading";
import NoData from "../UI/NoData";
import DataNotFound from "../UI/DataNotFound";
import useAuth from "../../hooks/useAuth";
import NoPriviliges from "../UI/NoPriviliges";

const VehicleDetails = ({ firstname, lastname }) => {
  const { auth, setAuth } = useAuth();
  const params = useParams();
  const axiosPrivate = useAxiosIntercept();
  const [userVehicleDetails, setUserVehicleDetails] = useState("");
  const [vehiclePlanDetail, getVehiclePlanDetail] = useState({});
  const [id, setId] = useState([]);
  const [hasMore, setHasMore] = useState(false);
  const [total_records, setTotalRecords] = useState(0);
  const [success, setSuccess] = useState(false);
  const [pageNumber, setPageNumber] = useState(1);

  // const [users, setUsers] = useState("");
  // const [vehicleId, setVehicleId] = useState([]);
  const [Toggle, setToggle] = useState({});
  const [loading, isloading] = useState(false);
  const [secondaryMembersDetail, setsecondaryMemberDetail] = useState([]);

  const perPageLimit = 10;
  const getVehicleData = (e, vehicleid) => {
    isloading(true);
    setId(e.target.id);
    setToggle({ [e.target.id]: !Toggle[e.target.id] });
    isloading(false);

    const getuserDetalis = async () => {
      const URL = process.env.REACT_APP_GET_USER_VEHICLE_MEMBER;
      try {
        const response = await axiosPrivate.get(
          URL + `&vehicle_id=${vehicleid}`
        );
        setsecondaryMemberDetail(response?.data?.response?.data);
      } catch (err) {
        //console.error(err);
      }
    };
    getuserDetalis();
  };
  const url = process.env.REACT_APP_GET_USER_VEHICLES_LIST + `&user_id=${params.user_id}&page=${pageNumber}&limit=${perPageLimit}`;

  const { isLoading, sendRequest: getusers } = useHttp();

  const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);
  useEffect(() => {
    const setSearchedusers = (searchedUsers) => {
      const { data } = searchedUsers?.data?.response;

      if (data?.user_vehicles && data?.user_vehicles.length > 0) {
        setUserVehicleDetails((prev) => {
          return [...new Set([...prev, ...data?.user_vehicles])];
        });
        setTotalRecords(data?.total);
      } else {
        setUserVehicleDetails({});
      }

      if (data?.total == data?.user_vehicles?.length) {
        setHasMore(false);
      } else {
        setHasMore(searchedUsers.data.response.data?.user_vehicles.length > 0);
      }
    };
    if (
      pageNumber == 1 ||
      Math.ceil(parseInt(total_records) / perPageLimit) >= pageNumber
    ) {
      getusers(
        {
          url,
        },
        setSearchedusers
      );
    }
  }, [url, pageNumber, getusers]);
  const renderSecondaryData = (index, vehicle_id) => {
    if (Toggle[index] && !loading) {
      return (
        <SecondaryData
          vehicleid={vehicle_id}
          secondaryMembersDetail={secondaryMembersDetail}
        />
      );
    } else if (Toggle[index] && loading) {
      return <p>Loading...</p>;
    }
  };

  return (

    <>
      {
        userVehicleDetails.length == "" ? (<Spinner />) : Object.keys(userVehicleDetails).length !== 0 ? (<>
          {
            auth.priviliges.includes("read_customer_vehicle") ?

              <div className="boxType1 bgBox2 customersDetails">
                {userVehicleDetails.map((uservehicleinfo, i) => {
                  const {
                    variant_image,
                    variant_name,
                    brand_name,
                    registration_no,
                    model_name,
                    variant_year,
                    battery_capacity,
                    secondary_driver_count,
                    nickname,
                    vehicle_id,
                  } = uservehicleinfo;
                  if (userVehicleDetails.length == i + 1) {
                    return (
                      <>
                        <section key={i} ref={lastElementRef}>
                          <div className="head" key={i} >
                            <p>
                              <img src={variant_image} alt="" />
                            </p>
                            <div className="headindTxt">
                              <p>
                                <span>{brand_name + " " + model_name}</span>
                              </p>
                              <ul className="tabsList">
                                <li>{registration_no}</li>
                              </ul>
                              <span className="nextLine subHeading">{`${variant_name} ${variant_year !== null ? "-" + variant_year : ""
                                }`}</span>
                            </div>
                            {/* <Link className="actionNav">
                        <i className="material-symbols-rounded mt-m grey">
                          more_vert
                        </i>
                      </Link> */}
                          </div>
                          <div className="dataTable">
                            <div>
                              <p>
                                <span>Battery</span>
                                <span>{`${battery_capacity}kwh`}</span>
                              </p>
                              <p>
                                <span>Secondary drivers</span>
                                <span>{secondary_driver_count}</span>
                              </p>
                              <p>
                                <span>Current plan</span>
                                {uservehicleinfo.package_info ? (
                                  <>
                                    <span>
                                      {uservehicleinfo.package_info[0].package_name}
                                    </span>
                                  </>
                                ) : (
                                  <>
                                    <span>N/A</span>
                                  </>
                                )}
                              </p>
                              <p>
                                <span>Car nickname</span>
                                <span>{nickname ? nickname : "N/A"}</span>
                              </p>
                              <p style={{ cursor: "pointer" }} className="moreInfoBtn">
                                {Toggle[i] ? (
                                  <i
                                    className="material-symbols-rounded arrowTop mt-l"
                                    onClick={(event) =>
                                      getVehicleData(event, vehicle_id)
                                    }
                                    id={i}
                                  >
                                    expand_more
                                  </i>
                                ) : (
                                  <i
                                    className="material-symbols-rounded arrowdown mt-l"
                                    onClick={(event) =>
                                      getVehicleData(event, vehicle_id)
                                    }
                                    id={i}
                                  >
                                    expand_more
                                  </i>
                                )}
                              </p>
                            </div>
                          </div>

                          {Toggle[i] ? (
                            <div className="xRow vehicleDetails pt-0 pad-24 dashboard">
                              {renderSecondaryData(i, vehicle_id)}

                              <CustomerPlanData
                                id={id}
                                planData={userVehicleDetails}
                                isLoading={loading}
                                firstname={firstname}
                                lastname={lastname}
                                success={success}
                                setSuccess={setSuccess}
                                userVehicleDetails={userVehicleDetails}
                                setUserVehicleDetails={setUserVehicleDetails}

                              />
                            </div>
                          ) : (
                            <></>
                          )}
                        </section>
                      </>
                    );

                  }
                  else {
                    return (
                      <>
                        <section key={i}>
                          <div className="head" key={i}>
                            <p>
                              <img src={variant_image} alt="" />
                            </p>
                            <div className="headindTxt">
                              <p>
                                <span>{brand_name + " " + model_name}</span>
                              </p>
                              <ul className="tabsList">
                                <li>{registration_no}</li>
                              </ul>
                              <span className="nextLine subHeading">{`${variant_name} ${variant_year !== null ? "-" + variant_year : ""
                                }`}</span>
                            </div>
                            
                          </div>
                          <div className="dataTable">
                            <div>
                              <p>
                                <span>Battery</span>
                                <span>{`${battery_capacity}kwh`}</span>
                              </p>
                              <p>
                                <span>Secondary drivers</span>
                                <span>{secondary_driver_count}</span>
                              </p>

                              {
                                uservehicleinfo.package_info ? (
                                  uservehicleinfo.package_info.map((plandata) => {
                                    return (
                                      <p>
                                        <span>{plandata.package_group=="normal"?"Current plan":"Recovery insurance"}</span>
                                        {uservehicleinfo.package_info ? (
                                          <>
                                            
                                              <span>
                                                {plandata.package_name}
                                              </span>
                                          </>
                                        ) : (
                                          <>
                                            <span>N/A</span>
                                          </>
                                        )}
                                      </p>
                                    )
                                  })
                                )

                                  : <>
                                  <p>
                                        <span>Current plan</span>
                                       
                                            <span>N/A</span>
                                          
                                        
                                      </p>
                                  </>
                              }


                              <p>
                                <span>Car nickname</span>
                                <span>{nickname ? nickname : "N/A"}</span>
                              </p>
                              <p style={{ cursor: "pointer" }} className="moreInfoBtn">
                                {Toggle[i] ? (
                                  <i
                                    className="material-symbols-rounded arrowTop mt-l"
                                    onClick={(event) =>
                                      getVehicleData(event, vehicle_id)
                                    }
                                    id={i}
                                  >
                                    expand_more
                                  </i>
                                ) : (
                                  <i
                                    className="material-symbols-rounded arrowdown mt-l"
                                    onClick={(event) =>
                                      getVehicleData(event, vehicle_id)
                                    }
                                    id={i}
                                  >
                                    expand_more
                                  </i>
                                )}
                              </p>
                            </div>
                          </div>

                          {Toggle[i] ? (
                            <div className="xRow vehicleDetails pt-0 pad-24 dashboard">
                              {renderSecondaryData(i, vehicle_id)}

                              <CustomerPlanData
                                id={id}
                                planData={userVehicleDetails}
                                isLoading={loading}
                                firstname={firstname}
                                lastname={lastname}
                                success={success}
                                setSuccess={setSuccess}
                                userVehicleDetails={userVehicleDetails}
                                setUserVehicleDetails={setUserVehicleDetails}

                              />
                            </div>
                          ) : (
                            <></>
                          )}
                        </section>
                      </>
                    );
                  }

                })}
              </div> : <NoPriviliges message="no priviliges" />}
        </>) : (<>
          <DataNotFound />
        </>)
      }
      <div>{isLoading && pageNumber != 1 && <Loading />}</div>
      {pageNumber != "1" && pageNumber > Math.ceil(total_records / perPageLimit) && (<NoData />)}

    </>




  );
};

export default VehicleDetails;
