
import React from 'react';
import { useState, useRef, useEffect } from 'react';
import BarGraph from '../../utils/BarGraph';
import moment from 'moment';
import useHttp from '../../hooks/useHttp';
import DropDown from '../UI/DropDown';
import DropdownWrapper from '../UI/DropdownWrapper';
import Spinner from '../UI/Spinner';
import { graphMonthFilterOption } from '../../configuration/GlobalConfig';
import OutsideClickSection from '../UI/OutsideClickSection';
const CustomerGraph = ({}) => {
  const effectRef = useRef(true);
  const [openSelect, setOpenSelect] = useState(false);
  const [selected, setSelected] = useState(0);
  const [totalcustomer, setTotalcustomer] = useState(0);
  const [localCustomerData, setLocalCustomerData] = useState([]);
  const [labeldata, setLabeldata] = useState([]);
  const [date, setDate] = useState({
    fromDate: '',
    toDate: '',
  });
  const classobj = {
    divClassName: 'selectDrop customScroll hFix',
    liClassName: 'selected',
  };
  useEffect(() => {
    const today = new Date();
    if (effectRef.current) {
      setDate((prev) => {
        return {
          ...prev,
          fromDate: moment(today).startOf('month').format('YYYY-MM-DD') + ' 00:00:00',
          toDate: moment(today).format('YYYY-MM-DD') + ' 23:59:59',
        };
      });
      effectRef.current = false;
    }
  }, []);
  const selectedFilter = (e) => {
    setSelected(e.target.id);
    getDataForCustomer(e.target.id);
  };
  let url = process.env.REACT_APP_GET_STATISTICS_GRAPH_DETAILS + '&info_type[0]=customer';
  const { isLoading, sendRequest: getData } = useHttp();
  useEffect(() => {
    if (date.toDate != '' && date.fromDate != '') {
      const getCustomerData = (customerData) => {
        const { data } = customerData;
        if (data?.response?.data?.customer?.total_customers) {
          setTotalcustomer(data?.response?.data?.customer.total_customers);
        }
        if (data?.response?.data?.customer?.customer_data) {
          data?.response?.data?.customer.customer_data.forEach((item) => {
            setLocalCustomerData((prevState) => [...prevState, item.customers]);
            setLabeldata((prevState) => [...prevState, item.month]);
          });
        }
      };
      getData(
        {
          request_method: 'post',
          url,
          request_body: {
            from_date: date.fromDate,
            to_date: date.toDate,
          },
        },
        getCustomerData
      );
    }
  }, [date]);
  const handelDropdown = (e) => {
    setOpenSelect((prevState) => !prevState);
  };
  const getDataForCustomer = (data) => {
    setLocalCustomerData([]);
    setLabeldata([]);
    const today = new Date();
    setDate({
      toDate: moment(today).subtract(1, 'months').endOf('month').format('YYYY-MM-DD') + ' 23:59:59',
    });
    if (data == 0) {
      setDate((prev) => {
        return {
          ...prev,
          fromDate: moment(today).startOf('month').format('YYYY-MM-DD') + ' 00:00:00',
          toDate: moment(today).format('YYYY-MM-DD') + ' 23:59:59',
        };
      });
    } else if (data > 0) {
      setDate((prev) => {
        return {
          ...prev,
          fromDate: moment(today).subtract(data, 'months').startOf('month').format('YYYY-MM-DD') + ' 00:00:00',
          toDate: moment(today).subtract(1, 'months').endOf('month').format('YYYY-MM-DD') + ' 23:59:59',
        };
      });
    }
  };
  return (
    <>
      {isLoading && <Spinner />}
      <div className='column pr-24'>
        <div className='boxT1'>
          <h4>
            New customers
            <DropdownWrapper
              attributes={{
                id: '',
                className: openSelect ? 'selectBox open' : 'selectBox',
              }}
              handelDropdown={handelDropdown}
              selected_label={selected != 0 ? ` last ${selected} months` : `This month`}>
              <DropDown
                data={graphMonthFilterOption}
                checkedOption={selected}
                classobj={classobj}
                callBackFunction={selectedFilter}
                listItemIdentifier='id'
              />
            </DropdownWrapper>
          </h4>
          <div className='recordCount'>{totalcustomer != null ? <span>{totalcustomer}</span> : <span>NA</span>}</div>
          <div className='graph mt-24'>
            {/*Place graph view*/}
            <BarGraph
              xAxisLabel={labeldata}
              data={localCustomerData}
              barGraphType='single'
              graphLabel="Customers"
            />
          </div>
        </div>
        {openSelect && <OutsideClickSection callBackFunction={handelDropdown} />}
      </div>
    </>
  );
};
export default CustomerGraph;
