/** @format */

import React, { useEffect, useRef, useState } from 'react';
import RevenueGraph from './RevenueGraph';
import CustomerGraph from './CustomerGraph';
import DashboardSummary from './DashboardSummary';
import useAuth from '../../hooks/useAuth';
import Spinner from '../UI/Spinner';
import NoPriviliges from '../UI/NoPriviliges';
import GeoMap from './GeoMap';
import HeatMap from './HeatMap';
function DashboardData(props) {
  const { auth, setAuth } = useAuth();
  return (
    <div>
      <h2>Dashboard</h2>
      {auth.priviliges.length > '0' ? (
        auth.priviliges.includes('read_dashboard') ? (
          <div className='subContent'>
            <div className='xRow fullWidth lookUpDataDashboard mb-24'>
              <DashboardSummary />
            </div>
            <div className='xRow pDashboard'>
              <CustomerGraph />
              <RevenueGraph />
              <GeoMap />
              <HeatMap />
            </div>
          </div>
        ) : (
          <NoPriviliges />
        )
      ) : (
        <Spinner />
      )}
    </div>
  );
}

export default DashboardData;
