import React from "react";
import { useState } from "react";
import { useEffect } from "react";
import SummaryCard from "../UI/SummaryCard";
import useHttp from "../../hooks/useHttp";
const DashboardSummary = () => {
  const [dashboardSummary, setDashboardSummary] = useState([]);
  let url = process.env.REACT_APP_GET_STATISTICS_DETAILS + `&info_type[0]=dashboard_summary`;
  const { isLoading, sendRequest: getData } = useHttp();
 useEffect(() => {
   const getSummaryData = (summaryData) => {
     const { data } = summaryData;
     if (isLoading == false)
        setDashboardSummary(data?.response.data);   
   };
     getData(
       {
         url,
       },
       getSummaryData
     );
   
 }, []);
  return (
    <div className='xRow fullWidth lookUpDataDashboard mb-24'>
      <SummaryCard
        value={dashboardSummary?.total_customers ? dashboardSummary?.total_customers : '0'}
        label='Total customers'
        className='boxT1'
      />
      <SummaryCard
        value={dashboardSummary?.avg_retention_rate ? parseFloat(dashboardSummary?.avg_retention_rate).toFixed(2) + '%' : '0'}
        label='Avg. retention rate'
        className='boxT1'
      />
      <SummaryCard
        value={dashboardSummary?.avg_charge_amount ? '$' + parseFloat(dashboardSummary?.avg_charge_amount).toFixed(2) : '0'}
        label='Avg. charge amount'
        className='boxT1'
      />
      <SummaryCard
        value={dashboardSummary?.avg_upsells ? '$' + parseFloat(dashboardSummary?.avg_upsells).toFixed(2) : '$0'}
        label='Avg. upsells/booking'
        className='boxT1'
      />
    </div>
  );
};

export default DashboardSummary;
