/** @format */
import React from 'react';
import { useEffect, useRef, useState } from 'react';
import moment from 'moment';
import { graphTimeFilterOptions } from '../../configuration/GlobalConfig';
import useHttp from '../../hooks/useHttp';
import Spinner from '../UI/Spinner';
import DropDown from '../UI/DropDown';
import DropdownWrapper from '../UI/DropdownWrapper';
import OutsideClickSection from '../UI/OutsideClickSection';
export default function GeoMap({}) {
  const effectRef = useRef(true);
  const [openSelect, setOpenSelect] = useState(false);
  const [time, setTime] = useState('12am - 6am');
  const [bookingdistribution, setBookingdistribution] = useState([]);
  const [date, setDate] = useState({
    fromDate: '',
    toDate: '',
  });
  useEffect(() => {
    const today = new Date();
    var duration = moment.duration({ days: 6 });
    if (effectRef.current) {
      setDate((prev) => {
        return {
          ...prev,
          fromDate: moment(today).subtract(duration).format('YYYY-MM-DD') + ' 00:00:00',
          toDate: moment(today).format('YYYY-MM-DD') + ' 06:00:00',
        };
      });
      effectRef.current = false;
    }
  }, []);
  let url = process.env.REACT_APP_GET_STATISTICS_GRAPH_DETAILS + '&info_type[0]=booking_distribution';
  const { isLoading, sendRequest: getData } = useHttp();
  useEffect(() => {
    if (date.toDate != '' && date.fromDate != '') {
      const getBookingDistributionData = (bookingdistributiondata) => {
        const { data } = bookingdistributiondata;
        if (data?.response?.data?.booking_distribution) {
          setBookingdistribution(data?.response?.data?.booking_distribution?.distribution_data);
        }
      };
      getData(
        {
          request_method: 'post',
          url,
          request_body: {
            from_date: date.fromDate,
            to_date: date.toDate,
          },
        },
        getBookingDistributionData
      );
    }
  }, [date]);
  const getDataForCustomer = (e, data) => {
    setTime(data.label);
    const today = new Date();
    var duration = moment.duration({ days: 6 });
    setDate((prev) => {
      return {
        ...prev,
        fromDate: moment(today).subtract(duration).format('YYYY-MM-DD') + ' ' + data.from_time,
        toDate: moment(today).format('YYYY-MM-DD') + ' ' + data.to_time,
      };
    });
  };
  const series = bookingdistribution;
  const handelDropdown = () => {
    setOpenSelect((prevState) => !prevState);
  };
  const classobj = {
    divClassName: 'selectDrop',
    liClassName: 'selected',
  };
  return (
    <>
      {isLoading && <Spinner />}
      <div className='column pt-24 pr-24'>
        <div className='boxT1'>
          <h4>
            Booking distribution
            <DropdownWrapper
              attributes={{
                id: '',
                className: openSelect ? 'selectBox open' : 'selectBox',
              }}
              handelDropdown={handelDropdown}
              selected_label={time ? time : `12 am - 6 am`}>
              <DropDown
                data={graphTimeFilterOptions}
                checkedOption={time}
                classobj={classobj}
                callBackFunction={getDataForCustomer}
                listItemIdentifier='label'
              />
            </DropdownWrapper>
          </h4>
          <div
            className='graph mt-24'
            style={{ minHeight: '335px' }}>
            <div
              className='dataTableDynamic'
              style={{ maxHeight: '335px', overflowY: 'scroll' }}>
              <table>
                <tbody>
                  <tr>
                    <th>Address</th>
                    <th>Postal district code</th>
                    <th>Count</th>
                  </tr>
                  {series && series?.length > '0' ? (
                    series.map((stateDetails, i) => {
                      return (
                        <React.Fragment key={stateDetails?.postal_district_code.toString()}>
                          <tr>
                            <td>{stateDetails?.address ? stateDetails?.address : '-'}</td>
                            <td>{stateDetails?.postal_district_code ? stateDetails?.postal_district_code : '-'}</td>
                            <td>{stateDetails?.count ? stateDetails?.count : '-'}</td>
                          </tr>
                        </React.Fragment>
                      );
                    })
                  ) : (
                    <tr>
                      <td colSpan='3'>No data found</td>
                    </tr> 
                  )}
                </tbody>
              </table>
            </div>
          </div>
        </div>
        {openSelect && <OutsideClickSection callBackFunction={handelDropdown} />}
      </div>
    </>
  );
}
