/** @format */

import React, { useRef } from 'react';
import Chart from 'react-apexcharts';
import moment from 'moment';
import { useState } from 'react';
import './HeatMap.css';
import { graphTimeFilterOptions } from '../../configuration/GlobalConfig';
import useHttp from '../../hooks/useHttp';
import { useEffect } from 'react';
import Spinner from '../UI/Spinner';
import DropDown from '../UI/DropDown';
import DropdownWrapper from '../UI/DropdownWrapper';
import OutsideClickSection from '../UI/OutsideClickSection';
const HeatMap = ({}) => {
  const effectRef = useRef(true);
  const [bookingTimedistribution, setBookingTimedistribution] = useState([]);
  const [bookingCounterdata, setBookingCounterdata] = useState([]);
  const [openFilter, setOpenFilter] = useState(false);
  const [time, setTime] = useState('12am - 6am');
  const [date, setDate] = useState({
    fromDate: '',
    toDate: '',
  });
  useEffect(() => {
    const today = new Date();
    var duration = moment.duration({ days: 6 });
    if (effectRef.current) {
      setDate((prev) => {
        return {
          ...prev,
          fromDate: moment(today).subtract(duration).format('YYYY-MM-DD') + ' 00:00:00',
          toDate: moment(today).format('YYYY-MM-DD') + ' 06:00:00',
        };
      });
      effectRef.current = false;
    }
  }, []);
  let url = process.env.REACT_APP_GET_STATISTICS_GRAPH_DETAILS + '&info_type[0]=booking_time_distribution';
  const { isLoading, sendRequest: getData } = useHttp();
  useEffect(() => {
    if (date.toDate != '' && date.fromDate != '') {
      const getBookingTimeDistributionData = (bookingtimedistributiondata) => {
        const { data } = bookingtimedistributiondata;
        if (data?.response?.data?.booking_time_distribution) {
          setBookingTimedistribution(data?.response?.data?.booking_time_distribution?.series);
          setBookingCounterdata(data?.response?.data?.booking_time_distribution?.booking_counter_data);
        }
      };
      getData(
        {
          request_method: 'post',
          url,
          request_body: {
            from_date: date.fromDate,
            to_date: date.toDate,
          },
        },
        getBookingTimeDistributionData
      );
    }
  }, [date]);
  const getDataForCustomer = (e, data) => {
    setTime(data.label);
    const today = new Date();
    var duration = moment.duration({ days: 6 });
    setDate((prev) => {
      return {
        ...prev,
        fromDate: moment(today).subtract(duration).format('YYYY-MM-DD') + ' ' + data.from_time,
        toDate: moment(today).format('YYYY-MM-DD') + ' ' + data.to_time,
      };
    });
  };
  const classobj = {
    divClassName: 'selectDrop',
    liClassName: 'selected',
  };
  const options = {
    xaxis: {
      position: 'top',
      labels: {
        style: {
          fontSize: '10px',
        },
      },
    },
    chart: {
      height: 300,
      type: 'heatmap',
    },
    dataLabels: {
      enabled: false,
    },

    colors: ['#0E6655'],
    title: {
      // text: "HeatMap Chart (Single color)",
    },
    plotOptions: {
      heatmap: {
        colorScale: {
          ranges: bookingCounterdata,
        },
      },
    },
  };
  const handelDropdown = () => {
    setOpenFilter(!openFilter);
  };
  const series = bookingTimedistribution;
  return (
    <>
      {isLoading && <Spinner />}
      <div className='column  pt-24'>
        <div className='boxT1'>
          <h4>
            Booking time distribution
            <DropdownWrapper
              attributes={{
                id: '',
                className: openFilter ? 'selectBox open' : 'selectBox',
              }}
              handelDropdown={handelDropdown}
              selected_label={time ? time : `12 am - 6 am`}>
              <DropDown
                data={graphTimeFilterOptions}
                checkedOption={time}
                classobj={classobj}
                callBackFunction={getDataForCustomer}
                listItemIdentifier='label'
              />
            </DropdownWrapper>
          </h4>
          <div className='graph mt-24 booking_time_distribution'>
            <Chart
              options={options}
              series={series}
              type='heatmap'
              height={320}
            />
          </div>
        </div>
        {openFilter && <OutsideClickSection callBackFunction={handelDropdown} />}
      </div>
    </>
  );
};
export default HeatMap;
