/** @format */

import React from 'react';
import { useState, useRef, useEffect } from 'react';
import BarGraph from '../../utils/BarGraph';
import moment from 'moment';
import useHttp from '../../hooks/useHttp';
import DropDown from '../UI/DropDown';
import DropdownWrapper from '../UI/DropdownWrapper';
import Spinner from '../UI/Spinner';
import { graphMonthFilterOption } from '../../configuration/GlobalConfig';
import OutsideClickSection from '../UI/OutsideClickSection';
const RevenueGraph = ({}) => {
  const effectRef = useRef(true);
  const [salesdata, setsalesdata] = useState({
    purchase_sales: [],
    booking_sales:[]
  });
  const [salesLabeldata, setSalesLabeldata] = useState([]);
  const [revenue, setRevenue] = useState({
    total_sales: 0,
    purchase_sales: 0,
    booking_sales:0
  });
  const [selectedSale, setSelectedSale] = useState(0);
  const [openSelectSale, setOpenSelectSale] = useState(false);
  const [date, setDate] = useState({
    fromDate: '',
    toDate: '',
  });
  const classobj = {
    divClassName: 'selectDrop customScroll hFix',
    liClassName: 'selected',
  };
  useEffect(() => {
    const today = new Date();
    if (effectRef.current) {
      setDate(() => {
        return {
          fromDate: moment(today).startOf('month').format('YYYY-MM-DD') + ' 00:00:00',
          toDate: moment(today).format('YYYY-MM-DD') + ' 23:59:59',
        };
      });
      effectRef.current = false;
    }
  }, []);
  const selectedFilter = (e) => {
    setSelectedSale(e.target.id);
    getDataForSales(e.target.id);
  };
  const handelDropdown = (e) => {
    setOpenSelectSale((prevState) => !prevState);
  };
  let url = process.env.REACT_APP_GET_STATISTICS_GRAPH_DETAILS + '&info_type[0]=revenue';
  const { isLoading, sendRequest: getData } = useHttp();
  useEffect(() => {
    if (date.toDate != '' && date.fromDate != '') {
      const getSalesData = (salesData) => {
        const { data } = salesData;
        if (data?.response?.data?.revenue) {
          setRevenue((prev) => {
            return {
              ...prev,
              total_sales: data?.response?.data?.revenue?.total_sales && data?.response?.data?.revenue?.total_sales,
              purchase_sales: data?.response?.data?.revenue?.purchase_sales && data?.response?.data?.revenue?.purchase_sales,
              booking_sales: data?.response?.data?.revenue?.booking_sales && data?.response?.data?.revenue?.booking_sales,
            };
          })
        }
        if (data?.response?.data?.revenue?.sales_data) {
          data?.response?.data?.revenue?.sales_data.forEach((item) => {
            setsalesdata((prev) => {
               return {
                 ...prev,
                 purchase_sales: [...(prev.purchase_sales || []), item.purchase_sales_amount ? item.purchase_sales_amount : '0'],
                 booking_sales: [...(prev.booking_sales || []), item.booking_sales_amount ? item.booking_sales_amount : '0'],
               };
            })
            setSalesLabeldata((prevState) => [...prevState, item.month]);
          });
        }
      };
      getData(
        {
          request_method: 'post',
          url,
          request_body: {
            from_date: date.fromDate,
            to_date: date.toDate,
          },
        },
        getSalesData
      );
    }
  }, [date]);
  const getDataForSales = (data) => {
    setsalesdata([]);
    setSalesLabeldata([]);
    const today = new Date();
    setDate({
      toDate: moment(today).subtract(1, 'months').endOf('month').format('YYYY-MM-DD') + ' 23:59:59',
    });
    if (data == 0) {
      setDate((prev) => {
        return {
          ...prev,
          fromDate: moment(today).startOf('month').format('YYYY-MM-DD') + ' 00:00:00',
          toDate: moment(today).format('YYYY-MM-DD') + ' 23:59:59',
        };
      });
    } else if (data > 0) {
      setDate((prev) => {
        return {
          ...prev,
          fromDate: moment(today).subtract(data, 'months').startOf('month').format('YYYY-MM-DD') + ' 00:00:00',
          toDate: moment(today).subtract(1, 'months').endOf('month').format('YYYY-MM-DD') + ' 23:59:59',
        };
      });
    }
  };
  return (
    <>
      {isLoading && <Spinner />}
      <div className='column pr-24'>
        <div className='boxT1'>
          <h4>
            Revenue
            <DropdownWrapper
              attributes={{
                id: '',
                className: openSelectSale ? 'selectBox open' : 'selectBox',
              }}
              handelDropdown={handelDropdown}
              selected_label={selectedSale != 0 ? ` last ${selectedSale} months` : `This month`}>
              <DropDown
                data={graphMonthFilterOption}
                checkedOption={selectedSale}
                classobj={classobj}
                callBackFunction={selectedFilter}
                listItemIdentifier='id'
              />
            </DropdownWrapper>
          </h4>
          <div className='recordCount'>
            <span>{revenue.total_sales && '$' + revenue.total_sales}</span>
            <div>
              {revenue.purchase_sales ? 'Package: $' + revenue.purchase_sales : 'Package: $0'}
              {'\u00A0'} {'\u00A0'}
              {revenue.booking_sales ? 'Booking: $' + revenue.booking_sales : 'Booking: $0'}
            </div>
          </div>
          <div className='graph mt-4'>
            <BarGraph
              xAxisLabel={salesLabeldata}
              data={[salesdata.booking_sales, salesdata.purchase_sales]}
              barGraphType="grouped"
              graphLabel={['Booking', 'Package']}
            />
          </div>
        </div>
        {openSelectSale && <OutsideClickSection callBackFunction={handelDropdown} />}
      </div>
    </>
  );
};

export default RevenueGraph;
