import { useState, useEffect, useRef } from "react";
import { useNavigate, useLocation, Link } from "react-router-dom";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import DriversListing from "./DriversListing";
// import Pagination from "./Pagination";
import Pagination from "../Customer/Pagination";
const DriversInfo = ({ searchValue }) => {
  const [driverInfo, setDriverInfo] = useState();
  const navigate = useNavigate();
  const location = useLocation();
  const axiosPrivate = useAxiosIntercept();
  // const effectRun = useRef(false);
  const search_keyword = searchValue;
  const [currentPage, setCurrentPage] = useState(1);
  const [usersPerPage, setUsersPerPage] = useState(5);
  const [total_records, setTotalRecords] = useState(0);
  const search_by = "firstname";
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getDrivers = async () => {
      let URL = process.env.REACT_APP_DRIVERS_INFO_URL;
      if (searchValue === "")
        URL = URL + `&page=${currentPage}&limit=${usersPerPage}`;
      if (searchValue != "") {
        URL =
          URL +
          `&search_by=${search_by}&search_keyword=${search_keyword}&limit=${usersPerPage}`;
      }
      try {
        const response = await axiosPrivate.get(URL, {
          signal: controller.signal,
        });
        isMounted && setDriverInfo(response?.data?.response?.data?.user_info);
        setTotalRecords(response?.data?.response?.data?.total_records);
      } catch (err) {
        console.log(err);
        // navigate("/", { state: { from: location }, replace: true });
      }
    };

    // Check if useEffect has run the first time
    // if (!effectRun.current) {
        getDrivers();
    // }

    return () => {
      isMounted = false;
      controller.abort();
      // effectRun.current = true; // update the value of effectRun to true
    };
  }, [searchValue, currentPage]);

  const paginate = (number) => {
    setCurrentPage(number);
  };
  return (
    <>
      <DriversListing driverInfo={driverInfo} />
      <Pagination
        paginate={paginate}
        currentPage={currentPage}
        usersPerPage={usersPerPage}
        total_records={total_records}
        setUsersPerPage={setUsersPerPage}
        setCurrentPage={setCurrentPage}
      />
      
    </>
  );
};

export default DriversInfo;
