import React from "react";
import { useNavigate } from "react-router-dom";
import Image from "../UI/Image";
import { FormatDate } from "../../utils/FormatDate";
const DriversListing = ({ driverInfo }) => {
  const navigate = useNavigate();
  return (
    <>
      {driverInfo?.[0] ? (
        <div className="customersList">
          {driverInfo.map((driver, i) => {
            return (
              <div
              key={i}
                className="infoEntry"
               
              >
                <div className="userInfo">
                  <Image userImage={driver.user_image} name={driver.firstname?driver.firstname:"Guest"}  className="imgBlock"/>
                  <div className="name">
                    {driver.firstname?<span>{`${driver.firstname} ${driver.lastname}`}</span>:<span>Guest</span>}
                    <span>Active since: {FormatDate(driver.created_at)}</span>
                  </div>
                </div>

                <div className="userInfo">
                  <div className="email">
                    <span>Email</span>
                    {driver.email == "" ? (
                      <>
                        <span>N/A</span>
                      </>
                    ) : (
                      <>
                        <span>{driver?.email}</span>
                      </>
                    )}
                  </div>
                </div>
                <div className="userInfo">
                  <div className="contactInfo">
                    <span>Phone</span>
                    {driver.phone == "" || driver.phone == 0 ? (
                      <>
                        <span>N/A</span>
                      </>
                    ) : (
                      <>
                        <span>{driver?.phone}</span>
                      </>
                    )}
                  </div>
                </div>
                <div className="userInfo">
                  <div className="vehiclesType">
                    <span>Vehicles</span>
                    <span>{driver?.vehicle_count}</span>
                  </div>
                </div>
                <div className="moreInfoBtn">
                  <i className="material-symbols-rounded arrowRight mt-l">
                    expand_more
                  </i>
                </div>
              </div>
            );
          })}
        </div>
      ) : (
        <p>No users to Display</p>
      )}
    </>
  );
};
export default DriversListing;
