import React from "react";
import { useState, useEffect } from "react";

import Logo from "../../assets/images/spinner.gif";

import { Chart as ChartJS, ArcElement, Tooltip, Legend } from "chart.js";

import { Doughnut } from "react-chartjs-2";

ChartJS.register(ArcElement, Tooltip, Legend);

const PackagesAdded = () => {
  const [packageData, setPackageData] = useState({
    labels: "",
    datasets: [
      {
        label: "",
        data: "",
      },
    ],
  });
  const [isLoading, setIsLoading] = useState(false);

  const controller = new AbortController();

  useEffect(() => {
    const renderUserData = async () => {
      setIsLoading(true);
      setPackageData({
        labels: [
          "Pay-As-You-Go",
          "Subscription",
          "Partner",
          "Corporate",
          "Promo",
        ],
        datasets: [
          {
            label: "Packages Created",
            data: [12, 19, 3, 5, 2],
            backgroundColor: [
              "rgba(255, 99, 132, 0.2)",
              "rgba(54, 162, 235, 0.2)",
              "rgba(255, 206, 86, 0.2)",
              "rgba(75, 192, 192, 0.2)",
              "rgba(153, 102, 255, 0.2)",
              "rgba(255, 159, 64, 0.2)",
            ],
            borderColor: [
              "rgba(255, 99, 132, 1)",
              "rgba(54, 162, 235, 1)",
              "rgba(255, 206, 86, 1)",
              "rgba(75, 192, 192, 1)",
              "rgba(153, 102, 255, 1)",
              "rgba(255, 159, 64, 1)",
            ],
            borderWidth: 1,
          },
        ],
      });
    };

    setTimeout(() => {
      renderUserData();
    }, 500);

    return () => {
      controller.abort();
    };
  }, []);

  return isLoading === false ? (
    <div className="pupLogin" style={{ background: `none` }}>
      <div className="loginBlock">
        <div className="logo">
          <img src={Logo} alt="P.UP" />
        </div>
      </div>
    </div>
  ) : (
    <Doughnut data={packageData} />
  );
};

export default PackagesAdded;
