import React from "react";
import { useState, useEffect } from "react";

import Logo from "../../assets/images/spinner.gif";

import {
  Chart as ChartJS,
  CategoryScale,
  LinearScale,
  PointElement,
  LineElement,
  Title,
  Tooltip,
  Legend,
} from "chart.js";

import { Line } from "react-chartjs-2";

ChartJS.register(
  CategoryScale,
  LinearScale,
  PointElement,
  LineElement,
  Title,
  Tooltip,
  Legend
);

const labels = [
  "October",
  "November",
  "December",
  "January",
  "February",
  "March",
];

const RegisteredBrands = () => {
  const [brandData, setBrandData] = useState({
    labels: "",
    datasets: [
      {
        label: "",
        data: "",
      },
    ],
  });
  const [isLoading, setIsLoading] = useState(false);

  const controller = new AbortController();

  useEffect(() => {
    const renderUserData = async () => {
      setIsLoading(true);
      setBrandData({
        labels,
        datasets: [
          {
            label: "Brands",
            data: [7, 15, 9, 23, 35, 9],
            borderColor: "rgb(255, 99, 132)",
            backgroundColor: "rgba(255, 99, 132, 0.5)",
          },
        ],
      });
    };

    setTimeout(() => {
      renderUserData();
    }, 500);

    return () => {
      controller.abort();
    };
  }, []);

  return isLoading === false ? (
    <div className="pupLogin" style={{ background: `none` }}>
      <div className="loginBlock">
        <div className="logo">
          <img src={Logo} alt="P.UP" />
        </div>
      </div>
    </div>
  ) : (
    <Line data={brandData} />
  );
};

export default RegisteredBrands;
