import React from "react";
import { useState, useEffect } from "react";

import Logo from "../../assets/images/spinner.gif";

import {
  Chart as ChartJS,
  CategoryScale,
  LinearScale,
  PointElement,
  LineElement,
  Title,
  Tooltip,
  Filler,
  Legend,
} from "chart.js";

import { Line } from "react-chartjs-2";

ChartJS.register(
  CategoryScale,
  LinearScale,
  PointElement,
  LineElement,
  Title,
  Tooltip,
  Filler,
  Legend
);

const labels = [
  "October",
  "November",
  "December",
  "January",
  "February",
  "March",
];

const RegisteredDrivers = () => {
  const [driverData, setDriverData] = useState({
    labels: "",
    datasets: [
      {
        label: "",
        data: "",
      },
    ],
  });
  const [isLoading, setIsLoading] = useState(false);

  const controller = new AbortController();

  useEffect(() => {
    const renderUserData = async () => {
      setIsLoading(true);
      setDriverData({
        labels,
        datasets: [
          {
            fill: true,
            label: "Registered Drivers",
            data: [4, 17, 9, 23, 35, 12],
            borderColor: "rgb(53, 162, 235)",
            backgroundColor: "rgba(53, 162, 235, 0.5)",
          },
        ],
      });
    };

    setTimeout(() => {
      renderUserData();
    }, 500);

    return () => {
      controller.abort();
    };
  }, []);

  return isLoading === false ? (
    <div className="pupLogin" style={{ background: `none` }}>
      <div className="loginBlock">
        <div className="logo">
          <img src={Logo} alt="P.UP" />
        </div>
      </div>
    </div>
  ) : (
    <Line data={driverData} />
  );
};

export default RegisteredDrivers;
