import React from "react";
import { useState, useEffect } from "react";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";

import Logo from "../../assets/images/spinner.gif";

import {
  Chart as ChartJS,
  BarElement,
  CategoryScale,
  LinearScale,
  Tooltip,
  Legend,
} from "chart.js";

import { Bar } from "react-chartjs-2";

ChartJS.register(BarElement, CategoryScale, LinearScale, Tooltip, Legend);

const RegisteredUsers = () => {
  const axiosPrivate = useAxiosIntercept();
  const [userData, setUserData] = useState({
    labels: "",
    datasets: [
      {
        label: "",
        data: "",
      },
    ],
  });
  const [userCount, setUserCount] = useState(false);

  const controller = new AbortController();
  const getUserData = async () => {
    try {
      const response = await axiosPrivate.get(
        process.env.REACT_APP_GET_USER_GRAPH_DATA,
        {
          signal: controller.signal,
        }
      );
      const { total_count, monthly_count } =
        response?.data?.response?.data.user;
      //   console.log(response);
      //   return response?.data?.response?.data?.user?.monthly_count;
      return {
        userCount: total_count,
        monthlyUsers: monthly_count,
      };
    } catch (err) {
      console.error(err);
    }
  };

  useEffect(() => {
    const renderUserData = async () => {
      const registeredUserData = await getUserData();
      if (registeredUserData.monthlyUsers.length != 0) {
        setUserCount(registeredUserData.userCount);
        setUserData({
          labels: registeredUserData.monthlyUsers.map((data) => {
            return data.year + " " + data.month;
          }),
          datasets: [
            {
              label: "Registered Users",
              data: registeredUserData.monthlyUsers.map((data) => data.count),
            },
          ],
        });
      }
    };

    renderUserData();
    return () => {
      controller.abort();
    };
  }, []);

  return userCount === false ? (
    <div className="pupLogin" style={{ background: `none` }}>
      <div className="loginBlock">
        <div className="logo">
          <img src={Logo} alt="P.UP" />
        </div>
      </div>
    </div>
  ) : (
    <Bar data={userData} />
  );
};

export default RegisteredUsers;
